/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.minelib.plugin.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.hsgamer.votiful.lib.minelib.plugin.base.Loadable;
import org.bukkit.plugin.java.JavaPlugin;

public class BasePlugin
extends JavaPlugin
implements Loadable {
    private final List<Object> components = this.getComponents();
    private final Map<Class<?>, Object> lookupMap = new ConcurrentHashMap();

    protected List<Object> getComponents() {
        return Collections.emptyList();
    }

    public final <T> T get(Class<T> type) {
        return type.cast(this.lookupMap.computeIfAbsent(type, t -> {
            for (Object component : this.components) {
                if (!type.isInstance(component)) continue;
                return component;
            }
            throw new IllegalArgumentException("No component of type " + type.getName() + " found");
        }));
    }

    public final <T> void call(Class<T> type, Consumer<T> consumer, boolean reverse) {
        int step;
        int index;
        int size = this.components.size();
        if (reverse) {
            index = size - 1;
            step = -1;
        } else {
            index = 0;
            step = 1;
        }
        while (index >= 0 && index < size) {
            Object component = this.components.get(index);
            if (type.isInstance(component)) {
                consumer.accept(type.cast(component));
            }
            index += step;
        }
    }

    public final <T> void call(Class<T> type, Consumer<T> consumer) {
        this.call(type, consumer, false);
    }

    public final void onLoad() {
        this.call(Loadable.class, Loadable::load);
        this.load();
    }

    public final void onEnable() {
        this.call(Loadable.class, Loadable::enable);
        this.enable();
    }

    public final void onDisable() {
        this.call(Loadable.class, Loadable::disable, true);
        this.disable();
    }
}

