/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.minelib.scheduler.common.util.task;

import java.util.function.BooleanSupplier;
import me.hsgamer.votiful.lib.minelib.scheduler.common.task.Task;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitTask
implements Task {
    private final org.bukkit.scheduler.BukkitTask bukkitTask;

    public BukkitTask(org.bukkit.scheduler.BukkitTask bukkitTask) {
        this.bukkitTask = bukkitTask;
    }

    public static BukkitRunnable wrapRunnable(final BooleanSupplier runnable) {
        return new BukkitRunnable(){

            public void run() {
                if (!runnable.getAsBoolean()) {
                    this.cancel();
                }
            }
        };
    }

    public org.bukkit.scheduler.BukkitTask getBukkitTask() {
        return this.bukkitTask;
    }

    @Override
    public boolean isCancelled() {
        try {
            return this.bukkitTask.isCancelled();
        }
        catch (Throwable throwable) {
            int taskId = this.bukkitTask.getTaskId();
            return !Bukkit.getScheduler().isQueued(taskId) && !Bukkit.getScheduler().isCurrentlyRunning(taskId);
        }
    }

    @Override
    public boolean isDone() {
        try {
            if (this.bukkitTask.isCancelled()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int taskId = this.bukkitTask.getTaskId();
        return !Bukkit.getScheduler().isQueued(taskId) && !Bukkit.getScheduler().isCurrentlyRunning(taskId);
    }

    @Override
    public void cancel() {
        this.bukkitTask.cancel();
    }

    @Override
    public Plugin getPlugin() {
        return this.bukkitTask.getOwner();
    }
}

