/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.topper.data.simple;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.votiful.lib.topper.data.core.DataEntry;
import me.hsgamer.votiful.lib.topper.data.core.DataHolder;
import me.hsgamer.votiful.lib.topper.data.simple.SimpleDataEntry;
import org.jetbrains.annotations.Nullable;

public class SimpleDataHolder<K, V>
implements DataHolder<K, V> {
    private final Map<K, DataEntry<K, V>> entryMap = new ConcurrentHashMap<K, DataEntry<K, V>>();

    @Override
    @Nullable
    public V getDefaultValue() {
        return null;
    }

    @Override
    public DataEntry<K, V> getOrCreateEntry(K key) {
        return this.entryMap.computeIfAbsent(key, u -> {
            SimpleDataEntry entry = new SimpleDataEntry(u, this);
            this.onCreate(entry);
            return entry;
        });
    }

    @Override
    public Optional<DataEntry<K, V>> getEntry(K key) {
        return Optional.ofNullable(this.entryMap.get(key));
    }

    @Override
    public void removeEntry(K key) {
        Optional.ofNullable(this.entryMap.remove(key)).ifPresent(this::onRemove);
    }

    @Override
    public Map<K, DataEntry<K, V>> getEntryMap() {
        return Collections.unmodifiableMap(this.entryMap);
    }

    @Override
    public void clear() {
        this.entryMap.values().forEach(this::onRemove);
        this.entryMap.clear();
    }
}

