/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.topper.storage.flat.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.hsgamer.votiful.lib.topper.storage.flat.core.FlatValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexFlatValueConverter<T>
implements FlatValueConverter<T> {
    private final String stringSeparator;
    private final List<Entry<T>> entries;
    private final Supplier<T> constructor;

    private ComplexFlatValueConverter(String stringSeparator, List<Entry<T>> entries, Supplier<T> constructor) {
        this.stringSeparator = stringSeparator;
        this.entries = entries;
        this.constructor = constructor;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public String toString(@NotNull T value) {
        StringJoiner joiner = new StringJoiner(this.stringSeparator);
        for (Entry<T> entry : this.entries) {
            String rawString = ((Entry)entry).converter.toString(((Entry)entry).getter.apply(value));
            joiner.add(rawString);
        }
        return joiner.toString();
    }

    @Override
    @Nullable
    public T fromString(@NotNull String value) {
        String[] values = value.split(Pattern.quote(this.stringSeparator), -1);
        if (values.length != this.entries.size()) {
            return null;
        }
        Object instance = this.constructor.get();
        for (int i = 0; i < values.length; ++i) {
            Entry<T> entry = this.entries.get(i);
            Object objectValue = ((Entry)entry).converter.fromString(values[i]);
            if (objectValue == null) {
                return null;
            }
            instance = ((Entry)entry).setter.apply(instance, objectValue);
        }
        return instance;
    }

    public static class Builder<T> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
        private String stringSeparator = "||";
        private Supplier<T> constructor;

        private Builder() {
        }

        public Builder<T> stringSeparator(String rawStringSeparator) {
            this.stringSeparator = rawStringSeparator;
            return this;
        }

        public Builder<T> constructor(Supplier<T> constructor) {
            this.constructor = constructor;
            return this;
        }

        public <V> Builder<T> entry(FlatValueConverter<V> converter, Function<T, V> getter, BiFunction<T, V, T> setter) {
            FlatValueConverter<V> objectConverter = converter;
            Function<T, V> objectGetter = getter;
            BiFunction<T, V, T> objectSetter = setter;
            Entry entry = new Entry(objectConverter, objectGetter, objectSetter);
            this.entries.add(entry);
            return this;
        }

        public ComplexFlatValueConverter<T> build() {
            if (this.constructor == null) {
                throw new IllegalStateException("Constructor is not set");
            }
            if (this.entries.isEmpty()) {
                throw new IllegalStateException("Entries are empty");
            }
            return new ComplexFlatValueConverter(this.stringSeparator, this.entries, this.constructor);
        }
    }

    private static class Entry<T> {
        private final FlatValueConverter<Object> converter;
        private final Function<T, Object> getter;
        private final BiFunction<T, Object, T> setter;

        private Entry(FlatValueConverter<Object> converter, Function<T, Object> getter, BiFunction<T, Object, T> setter) {
            this.converter = converter;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

