/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.topper.storage.flat.core;

import java.io.File;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.hsgamer.votiful.lib.topper.storage.core.DataStorage;
import me.hsgamer.votiful.lib.topper.storage.flat.core.FlatValueConverter;

public abstract class FlatDataStorage<F, K, V>
implements DataStorage<K, V> {
    private final File baseFolder;
    private final String name;
    private final FlatValueConverter<K> keyConverter;
    private final FlatValueConverter<V> valueConverter;
    private F file;

    public FlatDataStorage(File baseFolder, String name, FlatValueConverter<K> keyConverter, FlatValueConverter<V> valueConverter) {
        this.baseFolder = baseFolder;
        this.name = name;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    protected abstract F setupFile(File var1, String var2);

    protected abstract Map<String, String> loadFromFile(F var1);

    protected abstract Optional<String> loadFromFile(F var1, String var2);

    protected abstract void saveFile(F var1);

    protected abstract void setValue(F var1, String var2, String var3);

    protected abstract void removeValue(F var1, String var2);

    private void checkFile() {
        if (this.file == null) {
            throw new IllegalStateException("Data storage is not registered");
        }
    }

    @Override
    public final void onRegister() {
        this.file = this.setupFile(this.baseFolder, this.name);
        if (this.file == null) {
            throw new IllegalStateException("Failed to get the file for " + this.name);
        }
    }

    @Override
    public final void onUnregister() {
        if (this.file != null) {
            this.saveFile(this.file);
            this.file = null;
        }
    }

    @Override
    public final Map<K, V> load() {
        this.checkFile();
        Map<String, String> rawData = this.loadFromFile(this.file);
        return rawData.entrySet().stream().map(entry -> {
            K key = this.keyConverter.fromString((String)entry.getKey());
            V value = this.valueConverter.fromString((String)entry.getValue());
            return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }).filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Optional<V> load(K key) {
        this.checkFile();
        return this.loadFromFile(this.file, this.keyConverter.toString(key)).map(this.valueConverter::fromString);
    }

    @Override
    public Optional<DataStorage.Modifier<K, V>> modify() {
        this.checkFile();
        return Optional.of(new DataStorage.Modifier<K, V>(){
            private final List<Runnable> runnableList = new LinkedList<Runnable>();

            @Override
            public void save(Map<K, V> map) {
                if (map.isEmpty()) {
                    return;
                }
                this.runnableList.add(() -> map.forEach((k, v) -> {
                    String key = FlatDataStorage.this.keyConverter.toString(k);
                    String value = FlatDataStorage.this.valueConverter.toString(v);
                    FlatDataStorage.this.setValue(FlatDataStorage.this.file, key, value);
                }));
            }

            @Override
            public void remove(Collection<K> keys) {
                if (keys.isEmpty()) {
                    return;
                }
                this.runnableList.add(() -> keys.forEach(key -> {
                    String keyString = FlatDataStorage.this.keyConverter.toString(key);
                    FlatDataStorage.this.removeValue(FlatDataStorage.this.file, keyString);
                }));
            }

            @Override
            public void commit() {
                this.runnableList.forEach(Runnable::run);
                this.runnableList.clear();
                FlatDataStorage.this.saveFile(FlatDataStorage.this.file);
            }

            @Override
            public void rollback() {
                this.runnableList.clear();
            }
        });
    }
}

