/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.lib.topper.storage.sql.converter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.hsgamer.votiful.lib.topper.storage.sql.core.SqlValueConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplexSqlValueConverter<T>
implements SqlValueConverter<T> {
    private final List<Entry<T>> entries;
    private final Supplier<T> constructor;
    private final String[] sqlColumns;
    private final String[] sqlColumnDefinitions;

    private ComplexSqlValueConverter(List<Entry<T>> entries, Supplier<T> constructor) {
        this.entries = Collections.unmodifiableList(entries);
        this.constructor = constructor;
        ArrayList<String> sqlColumns = new ArrayList<String>();
        ArrayList<String> sqlColumnDefinitions = new ArrayList<String>();
        for (Entry<T> entry : entries) {
            String[] columns = ((Entry)entry).converter.getSqlColumns();
            String[] columnDefinitions = ((Entry)entry).converter.getSqlColumnDefinitions();
            sqlColumns.addAll(Arrays.asList(columns));
            sqlColumnDefinitions.addAll(Arrays.asList(columnDefinitions));
        }
        this.sqlColumns = sqlColumns.toArray(new String[0]);
        this.sqlColumnDefinitions = sqlColumnDefinitions.toArray(new String[0]);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Override
    public String[] getSqlColumns() {
        return this.sqlColumns;
    }

    @Override
    public String[] getSqlColumnDefinitions() {
        return this.sqlColumnDefinitions;
    }

    @Override
    public Object[] toSqlValues(@NotNull T value) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Entry<T> entry : this.entries) {
            Object[] objectValues = ((Entry)entry).converter.toSqlValues(((Entry)entry).getter.apply(value));
            values.addAll(Arrays.asList(objectValues));
        }
        return values.toArray(new Object[0]);
    }

    @Override
    @Nullable
    public T fromSqlResultSet(@NotNull ResultSet resultSet) throws SQLException {
        Object instance = this.constructor.get();
        for (Entry<T> entry : this.entries) {
            Object objectValue = ((Entry)entry).converter.fromSqlResultSet(resultSet);
            if (objectValue == null) {
                return null;
            }
            instance = ((Entry)entry).setter.apply(instance, objectValue);
        }
        return instance;
    }

    private static class Entry<T> {
        private final SqlValueConverter<Object> converter;
        private final Function<T, Object> getter;
        private final BiFunction<T, Object, T> setter;

        private Entry(SqlValueConverter<Object> converter, Function<T, Object> getter, BiFunction<T, Object, T> setter) {
            this.converter = converter;
            this.getter = getter;
            this.setter = setter;
        }
    }

    public static class Builder<T> {
        private final List<Entry<T>> entries = new ArrayList<Entry<T>>();
        private Supplier<T> constructor;

        private Builder() {
        }

        public Builder<T> constructor(Supplier<T> constructor) {
            this.constructor = constructor;
            return this;
        }

        public <V> Builder<T> entry(SqlValueConverter<V> converter, Function<T, V> getter, BiFunction<T, V, T> setter) {
            SqlValueConverter<V> objectConverter = converter;
            Function<T, V> objectGetter = getter;
            BiFunction<T, V, T> objectSetter = setter;
            Entry entry = new Entry(objectConverter, objectGetter, objectSetter);
            this.entries.add(entry);
            return this;
        }

        public ComplexSqlValueConverter<T> build() {
            if (this.constructor == null) {
                throw new IllegalStateException("Constructor is not set");
            }
            if (this.entries.isEmpty()) {
                throw new IllegalStateException("Entries are empty");
            }
            return new ComplexSqlValueConverter(this.entries, this.constructor);
        }
    }
}

