/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.votiful.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import me.hsgamer.votiful.Votiful;
import me.hsgamer.votiful.config.MainConfig;
import me.hsgamer.votiful.data.VoteTableDiffSnapshot;
import me.hsgamer.votiful.event.Event;
import me.hsgamer.votiful.event.GlobalEvent;
import me.hsgamer.votiful.lib.minelib.plugin.base.Loadable;

public class EventManager
implements Loadable {
    private final Votiful plugin;
    private final List<Event> events = new ArrayList<Event>();

    public EventManager(Votiful plugin) {
        this.plugin = plugin;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<String> handle(VoteTableDiffSnapshot snapshot) {
        ArrayList<String> commands = new ArrayList<String>();
        for (Event event : this.events) {
            commands.addAll(event.handle(snapshot));
        }
        return commands;
    }

    @Override
    public void enable() {
        Map<String, Map<String, Object>> eventSettings = this.plugin.get(MainConfig.class).getEvents();
        for (Map.Entry<String, Map<String, Object>> entry : eventSettings.entrySet()) {
            String eventName = entry.getKey();
            Map<String, Object> eventSetting = entry.getValue();
            try {
                GlobalEvent globalEvent = GlobalEvent.create(eventSetting);
                this.events.add(globalEvent);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error while creating event: " + eventName, e);
            }
        }
    }

    @Override
    public void disable() {
        this.events.clear();
    }
}

