/*
 * Decompiled with CFR 0.152.
 */
package dev.caoimhe.oneclickjoin.event;

import dev.caoimhe.oneclickjoin.config.OneClickJoinConfig;
import dev.caoimhe.oneclickjoin.gui.widget.QuickJoinButtonWidget;
import dev.caoimhe.oneclickjoin.util.ScreenUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import org.jetbrains.annotations.Nullable;

public class ScreenEventListener {
    private static final String MULTIPLAYER_I18N_KEY = "menu.multiplayer";

    public void afterScreenInitialized(Screen screen, Consumer<AbstractWidget> addClickableWidget) {
        if (!(screen instanceof TitleScreen)) {
            return;
        }
        ServerList serverList = new ServerList(Minecraft.getInstance());
        serverList.load();
        @Nullable String serverAddress = OneClickJoinConfig.INSTANCE.lastServerAddress();
        ServerData serverInfo = serverAddress != null ? serverList.get(serverAddress) : null;
        @Nullable Button multiplayerButton = ScreenUtil.findButtonWithTranslationKey(screen, MULTIPLAYER_I18N_KEY);
        addClickableWidget.accept((AbstractWidget)new QuickJoinButtonWidget(multiplayerButton, serverInfo));
    }
}

