/*
 * Decompiled with CFR 0.152.
 */
package dev.caoimhe.oneclickjoin.gui.widget;

import com.mojang.blaze3d.platform.NativeImage;
import dev.caoimhe.oneclickjoin.OneClickJoin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class QuickJoinButtonWidget
extends Button {
    private static final int DEFAULT_X = 5;
    private static final int DEFAULT_Y = 5;
    private static final int WIDTH = 20;
    private static final int HEIGHT = 20;
    private static final int IMAGE_PADDING = 2;
    @Nullable
    private final Button neighbor;
    @Nullable
    private final FaviconTexture worldIcon;

    public QuickJoinButtonWidget(@Nullable Button neighbor, @Nullable ServerData serverInfo) {
        super(5, 5, 20, 20, (Component)Component.empty(), widget -> {
            if (serverInfo == null) {
                return;
            }
            ConnectScreen.startConnecting((Screen)new TitleScreen(), (Minecraft)Minecraft.getInstance(), (ServerAddress)ServerAddress.parseString((String)serverInfo.ip), (ServerData)serverInfo, (boolean)false, null);
        }, Button.DEFAULT_NARRATION);
        this.neighbor = neighbor;
        if (serverInfo != null) {
            this.worldIcon = FaviconTexture.forServer((TextureManager)Minecraft.getInstance().getTextureManager(), (String)serverInfo.ip);
            this.setTooltip(Tooltip.create((Component)Component.literal((String)("Join server " + serverInfo.name + "..."))));
            byte[] bytes = serverInfo.getIconBytes();
            if (bytes != null && bytes.length > 0) {
                try {
                    this.worldIcon.upload(NativeImage.read((byte[])bytes));
                }
                catch (Exception e) {
                    OneClickJoin.LOGGER.warn("Failed to load icon for server '{}'", (Object)serverInfo.ip, (Object)e);
                }
            }
        } else {
            this.worldIcon = null;
            this.active = false;
            this.setTooltip(Tooltip.create((Component)Component.literal((String)"Join a server to be able to quick-join!")));
        }
    }

    public int getX() {
        if (this.neighbor != null) {
            return this.neighbor.getX() + this.neighbor.getWidth() + 4;
        }
        return 5;
    }

    public int getY() {
        if (this.neighbor != null) {
            return this.neighbor.getY();
        }
        return 5;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        if (this.worldIcon != null) {
            context.blit(this.worldIcon.textureLocation(), this.getX() + 1, this.getY() + 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
    }
}

