/*
 * Decompiled with CFR 0.152.
 */
package dev.luxmiyu.miniteleport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniTeleport
implements ModInitializer {
    static final String MOD_ID = "miniteleport";
    static final Logger LOGGER = LoggerFactory.getLogger((String)"miniteleport");
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    static final Predicate<class_2168> PERMISSIONS_NORMAL = source -> source.method_9259(0);
    static final Predicate<class_2168> PERMISSIONS_ADMIN = source -> source.method_9259(4);
    static final long REQUEST_TIMEOUT_MS = 60000L;
    final List<TeleportRequest> pendingRequests = new CopyOnWriteArrayList<TeleportRequest>();

    Path getDir(MinecraftServer server) {
        return server.method_27050(class_5218.field_24188).resolve(MOD_ID);
    }

    File getFile(MinecraftServer server, @Nullable UUID uuid) {
        Path worldDir = this.getDir(server);
        Path path = uuid == null ? worldDir.resolve("warps.json") : worldDir.resolve("homes/" + String.valueOf(uuid) + ".json");
        return path.toFile();
    }

    void createDir(MinecraftServer server) {
        try {
            Files.createDirectories(this.getDir(server).resolve("homes"), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create data directory", (Throwable)e);
        }
    }

    Warp[] getWarps(File file) {
        Warp[] warpArray;
        if (!file.exists()) {
            return new Warp[0];
        }
        FileReader reader = new FileReader(file);
        try {
            warpArray = (Warp[])GSON.fromJson((Reader)reader, Warp[].class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load warps from {}", (Object)file, (Object)e);
                return new Warp[0];
            }
        }
        reader.close();
        return warpArray;
    }

    @Nullable
    Warp getWarp(MinecraftServer server, String name, @Nullable UUID uuid) {
        for (Warp warp : this.getWarps(this.getFile(server, uuid))) {
            if (!warp.name().equals(name)) continue;
            return warp;
        }
        return null;
    }

    void writeFile(File file, Object object) {
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(file.getParentFile().toPath(), "tmp-", ".json", new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(tempFile.toFile());){
                GSON.toJson(object, (Appendable)writer);
            }
            Files.move(tempFile, file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save warps to {}", (Object)file, (Object)e);
        }
    }

    void setWarp(String name, class_3222 player, @Nullable UUID uuid) {
        MinecraftServer server = player.method_51469().method_8503();
        ArrayList<Warp> warps = new ArrayList<Warp>(List.of(this.getWarps(this.getFile(server, uuid))));
        String dimension = player.method_51469().method_27983().method_29177().toString();
        Warp warp = new Warp(name, (int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318()), (int)Math.floor(player.method_23321()), dimension);
        boolean warpExists = false;
        for (int i = 0; i < warps.size(); ++i) {
            if (!warps.get(i).name().equals(name)) continue;
            warps.set(i, warp);
            warpExists = true;
        }
        if (!warpExists) {
            warps.add(warp);
        }
        CompletableFuture.runAsync(() -> this.writeFile(this.getFile(server, uuid), warps));
    }

    int delWarp(String name, class_3222 player, @Nullable UUID uuid) {
        String start;
        MinecraftServer server = player.method_51469().method_8503();
        ArrayList<Warp> warps = new ArrayList<Warp>(List.of(this.getWarps(this.getFile(server, uuid))));
        int delIndex = -1;
        for (int i = 0; i < warps.size(); ++i) {
            if (!warps.get(i).name().equals(name)) continue;
            delIndex = i;
            break;
        }
        String string = start = uuid == null ? "Warp '" : "Home '";
        if (delIndex == -1) {
            player.method_7353((class_2561)class_2561.method_43470((String)(start + name + "' does not exist!")).method_27692(class_124.field_1061), false);
            return 0;
        }
        warps.remove(delIndex);
        CompletableFuture.runAsync(() -> this.writeFile(this.getFile(server, uuid), warps));
        player.method_7353((class_2561)class_2561.method_43470((String)(start + name + "' deleted!")).method_27692(class_124.field_1075), false);
        return 1;
    }

    void doTeleportEffect(class_3218 world, class_3222 player) {
        world.method_43128(null, (double)player.method_31477() + 0.5, (double)player.method_31478() + 0.5, (double)player.method_31479() + 0.5, class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        world.method_14199((class_2394)class_2398.field_11214, (double)player.method_31477() + 0.5, (double)player.method_31478() + 0.5, (double)player.method_31479() + 0.5, 25, 0.25, 0.25, 0.25, 0.0);
    }

    int warpPlayer(class_3222 player, @Nullable Warp warp) {
        if (warp == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"That warp doesn't exist!").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_3218 world = player.method_51469().method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)warp.dimension())));
        if (world == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"That dimension doesn't exist!").method_27692(class_124.field_1061), false);
            return 0;
        }
        this.setWarp("back", player, player.method_5667());
        player.method_48105(world, (double)warp.x() + 0.5, (double)warp.y() + 0.1, (double)warp.z() + 0.5, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455());
        this.doTeleportEffect(world, player);
        if (List.of("home", "back").contains(warp.name())) {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Teleported %s!", warp.name())).method_27692(class_124.field_1075), false);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Teleported to %s!", warp.name())).method_27692(class_124.field_1075), false);
        }
        return 1;
    }

    class_2561 listWarps(MinecraftServer server, @Nullable UUID uuid) {
        Warp[] warps = this.getWarps(this.getFile(server, uuid));
        if (warps.length == 0) {
            return class_2561.method_43470((String)(uuid == null ? "There are no warps." : "You have no homes.")).method_27692(class_124.field_1061);
        }
        class_5250 text = class_2561.method_43470((String)(uuid == null ? "Warps:" : "Homes:"));
        for (Warp warp : warps) {
            text.method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)warp.name()).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, (uuid == null ? "/warp " : "/home ") + warp.name())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Teleport to " + warp.name()))))));
        }
        return text;
    }

    void addRequest(TeleportRequest request) {
        this.pendingRequests.removeIf(r -> r.sender().equals(request.sender()) && r.receiver().equals(request.receiver()));
        this.pendingRequests.add(request);
    }

    void removeRequest(TeleportRequest request) {
        this.pendingRequests.remove(request);
    }

    TeleportRequest getMostRecentRequest(UUID receiver) {
        return this.pendingRequests.stream().filter(r -> r.receiver().equals(receiver)).max(Comparator.comparingLong(TeleportRequest::expiry)).orElse(null);
    }

    TeleportRequest getRequest(UUID receiver, UUID sender) {
        return this.pendingRequests.stream().filter(r -> r.receiver().equals(receiver) && r.sender().equals(sender)).findFirst().orElse(null);
    }

    void cleanupExpiredRequests() {
        long now = System.currentTimeMillis();
        this.pendingRequests.removeIf(r -> r.expiry() < now);
    }

    void sendTeleportRequest(class_3222 sender, class_3222 receiver, boolean here) {
        this.cleanupExpiredRequests();
        long expiry = System.currentTimeMillis() + 60000L;
        TeleportRequest request = new TeleportRequest(sender.method_5667(), receiver.method_5667(), here, expiry);
        this.addRequest(request);
        class_5250 message = class_2561.method_43470((String)String.format("%s wants to teleport %s. ", sender.method_5477().getString(), here ? "you to them" : "to you")).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"[Accept]").method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpaccept " + sender.method_5477().getString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Accept teleport request from " + sender.method_5477().getString())))))).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"[Deny]").method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tpdeny " + sender.method_5477().getString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Deny teleport request from " + sender.method_5477().getString()))))));
        receiver.method_7353((class_2561)message, false);
        sender.method_7353((class_2561)class_2561.method_43470((String)("Teleport request sent to " + receiver.method_5477().getString())).method_27692(class_124.field_1075), false);
    }

    void cancelTeleportRequest(class_3222 sender) {
        this.cleanupExpiredRequests();
        List<TeleportRequest> requests = this.pendingRequests.stream().filter(r -> r.sender().equals(sender.method_5667())).toList();
        if (requests.isEmpty()) {
            sender.method_7353((class_2561)class_2561.method_43470((String)"You have no pending teleport requests.").method_27692(class_124.field_1061), false);
            return;
        }
        for (TeleportRequest request : requests) {
            class_3222 receiver = sender.method_51469().method_8503().method_3760().method_14602(request.receiver());
            if (receiver != null) {
                receiver.method_7353((class_2561)class_2561.method_43470((String)(sender.method_5477().getString() + " cancelled their teleport request.")).method_27692(class_124.field_1054), false);
            }
            this.removeRequest(request);
        }
        sender.method_7353((class_2561)class_2561.method_43470((String)"Teleport request cancelled.").method_27692(class_124.field_1054), false);
    }

    void acceptTeleportRequest(class_3222 receiver, @Nullable class_3222 sender) {
        this.cleanupExpiredRequests();
        TeleportRequest request = sender != null ? this.getRequest(receiver.method_5667(), sender.method_5667()) : this.getMostRecentRequest(receiver.method_5667());
        if (request == null) {
            receiver.method_7353((class_2561)class_2561.method_43470((String)"Teleport request expired or doesn't exist.").method_27692(class_124.field_1061), false);
            return;
        }
        class_3222 actualSender = receiver.method_51469().method_8503().method_3760().method_14602(request.sender());
        if (actualSender == null) {
            receiver.method_7353((class_2561)class_2561.method_43470((String)"Request sender is no longer online.").method_27692(class_124.field_1061), false);
            this.removeRequest(request);
            return;
        }
        if (request.here()) {
            this.warpPlayer(receiver, new Warp(actualSender.method_5477().getString(), (int)actualSender.method_23317(), (int)actualSender.method_23318(), (int)actualSender.method_23321(), actualSender.method_51469().method_27983().method_29177().toString()));
            actualSender.method_7353((class_2561)class_2561.method_43470((String)"Teleport request accepted!").method_27692(class_124.field_1075), false);
        } else {
            this.warpPlayer(actualSender, new Warp(receiver.method_5477().getString(), (int)receiver.method_23317(), (int)receiver.method_23318(), (int)receiver.method_23321(), receiver.method_51469().method_27983().method_29177().toString()));
            receiver.method_7353((class_2561)class_2561.method_43470((String)"Teleport request accepted!").method_27692(class_124.field_1075), false);
        }
        this.removeRequest(request);
    }

    void denyTeleportRequest(class_3222 receiver, @Nullable class_3222 sender) {
        this.cleanupExpiredRequests();
        TeleportRequest request = sender != null ? this.getRequest(receiver.method_5667(), sender.method_5667()) : this.getMostRecentRequest(receiver.method_5667());
        if (request == null) {
            receiver.method_7353((class_2561)class_2561.method_43470((String)"Teleport request expired or doesn't exist.").method_27692(class_124.field_1061), false);
            return;
        }
        class_3222 actualSender = receiver.method_51469().method_8503().method_3760().method_14602(request.sender());
        if (actualSender == null) {
            receiver.method_7353((class_2561)class_2561.method_43470((String)"Request sender is no longer online.").method_27692(class_124.field_1061), false);
            this.removeRequest(request);
            return;
        }
        this.removeRequest(request);
    }

    MinecraftServer getServer(CommandContext<class_2168> context) {
        return ((class_2168)context.getSource()).method_9211();
    }

    class_3222 getPlayer(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You must be a player to use this command."));
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create();
        }
        return player;
    }

    SuggestionProvider<class_2168> suggestWarps(boolean player) {
        return (context, builder) -> {
            MinecraftServer server = this.getPlayer((class_2168)context.getSource()).method_51469().method_8503();
            UUID uuid = null;
            if (player) {
                uuid = this.getPlayer((class_2168)context.getSource()).method_5667();
            }
            for (Warp warp : this.getWarps(this.getFile(server, uuid))) {
                builder.suggest(warp.name());
            }
            return builder.buildFuture();
        };
    }

    SuggestionProvider<class_2168> suggestPlayers() {
        return (context, builder) -> {
            class_3222 sender = this.getPlayer((class_2168)context.getSource());
            List players = sender.method_51469().method_8503().method_3760().method_14571();
            for (class_3222 player : players) {
                if (sender.method_5667().equals(player.method_5667())) continue;
                builder.suggest(player.method_5477().getString());
            }
            return builder.buildFuture();
        };
    }

    void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(PERMISSIONS_NORMAL)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"name");
            this.setWarp(homeName, player, player.method_5667());
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Home %s set!", homeName)).method_27692(class_124.field_1075), false);
            return 1;
        }))).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            this.setWarp("home", player, player.method_5667());
            player.method_7353((class_2561)class_2561.method_43470((String)"Home set!").method_27692(class_124.field_1075), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(PERMISSIONS_NORMAL)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.suggestWarps(true)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"name");
            return this.delWarp(homeName, player, player.method_5667());
        }))).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            return this.delWarp("home", player, player.method_5667());
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(PERMISSIONS_NORMAL)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.suggestWarps(true)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String homeName = StringArgumentType.getString((CommandContext)context, (String)"name");
            return this.warpPlayer(player, this.getWarp(this.getServer((CommandContext<class_2168>)context), homeName, player.method_5667()));
        }))).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            return this.warpPlayer(player, this.getWarp(this.getServer((CommandContext<class_2168>)context), "home", player.method_5667()));
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            player.method_7353(this.listWarps(this.getServer((CommandContext<class_2168>)context), player.method_5667()), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            return this.warpPlayer(player, this.getWarp(this.getServer((CommandContext<class_2168>)context), "back", player.method_5667()));
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(PERMISSIONS_ADMIN)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String warpName = StringArgumentType.getString((CommandContext)context, (String)"name");
            this.setWarp(warpName, player, null);
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("Warp %s set!", warpName)).method_27692(class_124.field_1075), false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(PERMISSIONS_ADMIN)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.suggestWarps(false)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String warpName = StringArgumentType.getString((CommandContext)context, (String)"name");
            return this.delWarp(warpName, player, null);
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(PERMISSIONS_NORMAL)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.suggestWarps(false)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            String warpName = StringArgumentType.getString((CommandContext)context, (String)"name");
            return this.warpPlayer(player, this.getWarp(this.getServer((CommandContext<class_2168>)context), warpName, null));
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            player.method_7353(this.listWarps(this.getServer((CommandContext<class_2168>)context), null), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setspawn").requires(PERMISSIONS_ADMIN)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            this.setWarp("spawn", player, null);
            class_3218 world = player.method_51469();
            world.method_8554(player.method_24515(), 0.0f);
            ((class_1928.class_4312)world.method_8503().method_3767().method_20746(class_1928.field_19403)).method_35236(0, world.method_8503());
            player.method_7353((class_2561)class_2561.method_43470((String)"Spawn set!").method_27692(class_124.field_1075), false);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 player = this.getPlayer((class_2168)context.getSource());
            return this.warpPlayer(player, this.getWarp(this.getServer((CommandContext<class_2168>)context), "spawn", null));
        }));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).requires(PERMISSIONS_NORMAL)).suggests(this.suggestPlayers()).executes(context -> {
            class_3222 target;
            class_3222 sender = this.getPlayer((class_2168)context.getSource());
            if (sender.equals((Object)(target = class_2186.method_9315((CommandContext)context, (String)"target")))) {
                sender.method_7353((class_2561)class_2561.method_43470((String)"You cannot teleport to yourself!").method_27692(class_124.field_1061), false);
                return 0;
            }
            this.sendTeleportRequest(sender, target, false);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).requires(PERMISSIONS_NORMAL)).suggests(this.suggestPlayers()).executes(context -> {
            class_3222 target;
            class_3222 sender = this.getPlayer((class_2168)context.getSource());
            if (sender.equals((Object)(target = class_2186.method_9315((CommandContext)context, (String)"target")))) {
                sender.method_7353((class_2561)class_2561.method_43470((String)"You cannot teleport to yourself!").method_27692(class_124.field_1061), false);
                return 0;
            }
            this.sendTeleportRequest(sender, target, true);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpcancel").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 sender = this.getPlayer((class_2168)context.getSource());
            this.cancelTeleportRequest(sender);
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 receiver = this.getPlayer((class_2168)context.getSource());
            this.acceptTeleportRequest(receiver, null);
            return 1;
        })).then(class_2170.method_9244((String)"sender", (ArgumentType)class_2186.method_9305()).suggests(this.suggestPlayers()).executes(context -> {
            class_3222 receiver = this.getPlayer((class_2168)context.getSource());
            class_3222 sender = class_2186.method_9315((CommandContext)context, (String)"sender");
            this.acceptTeleportRequest(receiver, sender);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpdeny").requires(PERMISSIONS_NORMAL)).executes(context -> {
            class_3222 receiver = this.getPlayer((class_2168)context.getSource());
            this.denyTeleportRequest(receiver, null);
            return 1;
        })).then(class_2170.method_9244((String)"sender", (ArgumentType)class_2186.method_9305()).suggests(this.suggestPlayers()).executes(context -> {
            class_3222 receiver = this.getPlayer((class_2168)context.getSource());
            class_3222 sender = class_2186.method_9315((CommandContext)context, (String)"sender");
            this.denyTeleportRequest(receiver, sender);
            return 1;
        })));
    }

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, cause) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                this.setWarp("back", player, player.method_5667());
            }
        });
        ServerWorldEvents.LOAD.register((server, world) -> this.createDir(server));
        LOGGER.info("Initialized!");
    }

    record Warp(String name, int x, int y, int z, String dimension) {
    }

    record TeleportRequest(UUID sender, UUID receiver, boolean here, long expiry) {
    }
}

