/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.block.pcReader;

import com.awesoft.ccx.CCX;
import com.awesoft.ccx.block.pcReader.PCReaderBlockEntity;
import com.awesoft.ccx.registry.CCXBlockEntities;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PCReaderBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public PCReaderBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PCReaderBlockEntity(pos, state);
    }

    public static int getSlotFromHit(BlockState state, BlockHitResult hit) {
        if (hit.m_82434_() != Direction.UP) {
            return -1;
        }
        Vec3 hitVec = hit.m_82450_().m_82492_((double)hit.m_82425_().m_123341_(), (double)hit.m_82425_().m_123342_(), (double)hit.m_82425_().m_123343_());
        float x = (float)hitVec.f_82479_;
        float z = (float)hitVec.f_82481_;
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (facing) {
            case SOUTH: {
                x = 1.0f - x;
                z = 1.0f - z;
                break;
            }
            case WEST: {
                float t = x;
                x = z;
                z = 1.0f - t;
                break;
            }
            case EAST: {
                float t = x;
                x = 1.0f - z;
                z = t;
            }
        }
        x = 1.0f - x;
        float pixelX = x * 16.0f;
        float pixelY = (float)(hitVec.f_82480_ * 16.0);
        if (pixelY < 16.0f || pixelY > 16.0f) {
            return -1;
        }
        if (pixelX >= 4.0f && pixelX < 11.0f) {
            return 0;
        }
        return -1;
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @javax.annotation.Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        try {
            int sessionId = tag.m_128451_("SessionId");
            UUID instanceId = tag.m_128342_("InstanceId");
            if (instanceId != null) {
                return registry.get(sessionId, instanceId);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        if (server != null) {
            try {
                ServerContext.get((MinecraftServer)server);
            }
            catch (Exception e) {
                return null;
            }
            return PCReaderBlock.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
        }
        return null;
    }

    private static void openImpl(Player player, ItemStack stack, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((MenuType)ModRegistry.Menus.COMPUTER.get(), id, inventory, p -> true, computer), (ContainerData)new ComputerContainerData(computer, stack));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PCReaderBlockEntity)) {
            return InteractionResult.PASS;
        }
        PCReaderBlockEntity pcreader = (PCReaderBlockEntity)blockEntity;
        int slot = PCReaderBlock.getSlotFromHit(state, hit);
        ItemStack held = player.m_21120_(hand);
        ItemStack slotStack = pcreader.getInventory().m_8020_(0);
        if (slot == 0) {
            if (held.m_41619_()) {
                if (!slotStack.m_41619_()) {
                    ItemStack toDrop = slotStack.m_41777_();
                    pcreader.disconnectServer(slot);
                    pcreader.getInventory().m_7407_(slot, 1);
                    if (!player.m_36356_(toDrop)) {
                        player.m_36176_(toDrop, false);
                    }
                    pcreader.m_6596_();
                    level.m_7260_(pos, state, state, 3);
                    level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.8f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (slotStack.m_41619_()) {
                ItemStack insert = held.m_41777_();
                insert.m_41764_(1);
                pcreader.getInventory().m_6836_(slot, insert);
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                pcreader.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (player.m_20194_() == null) {
                CCX.LOGGER.info("you'll never see this message! isn't that interesting?");
                return InteractionResult.CONSUME;
            }
            ItemStack slotStackReal = pcreader.getInventory().m_8020_(0);
            if (slotStackReal.m_41619_() || slotStackReal.m_41613_() == 0) {
                return InteractionResult.FAIL;
            }
            CompoundTag tag = slotStackReal.m_41783_();
            ServerComputerRegistry registry = ServerContext.get((MinecraftServer)player.m_20194_()).registry();
            try {
                ServerContext.get((MinecraftServer)player.m_20194_());
            }
            catch (Exception e) {
                return InteractionResult.FAIL;
            }
            ServerComputer comp = PCReaderBlock.getServerComputer(registry, slotStackReal);
            if (comp == null) {
                player.m_5661_((Component)Component.m_237113_((String)"That item isn't a computer type item!"), true);
                return InteractionResult.FAIL;
            }
            PCReaderBlock.openImpl(player, slotStackReal, false, comp);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof PCReaderBlockEntity) {
            PCReaderBlockEntity rack = (PCReaderBlockEntity)blockEntity;
            Direction side = null;
            for (Direction d : Direction.values()) {
                if (!pos.m_121945_(d).equals((Object)fromPos)) continue;
                side = d;
                break;
            }
            if (side != null) {
                rack.neighborChanged(side, fromPos);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PCReaderBlockEntity) {
                PCReaderBlockEntity rack = (PCReaderBlockEntity)blockEntity;
                rack.disconnectAllServers();
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = rack.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                }
                level.m_46717_(pos, (Block)this);
                level.m_46747_(pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return PCReaderBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CCXBlockEntities.PC_READER_ENTITY.get()), PCReaderBlockEntity::tick);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

