/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.block.pcie;

import com.awesoft.ccx.block.pcie.PCIeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PCIeBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public PCIeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PCIeBlockEntity(pos, state);
    }

    public static int getSlotFromHit(BlockState state, BlockHitResult hit) {
        Vec3 hitVec = hit.m_82450_().m_82492_((double)hit.m_82425_().m_123341_(), (double)hit.m_82425_().m_123342_(), (double)hit.m_82425_().m_123343_());
        float x = (float)hitVec.f_82479_;
        float y = (float)hitVec.f_82480_;
        float z = (float)hitVec.f_82481_;
        if (y < 0.4375f || y > 0.5625f) {
            return -1;
        }
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (facing) {
            case SOUTH: {
                x = 1.0f - x;
                z = 1.0f - z;
                break;
            }
            case WEST: {
                float t = x;
                x = z;
                z = 1.0f - t;
                break;
            }
            case EAST: {
                float t = x;
                x = 1.0f - z;
                z = t;
            }
        }
        x = 1.0f - x;
        float pixelX = x * 16.0f;
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            if (pixelX >= 2.0f && pixelX < 4.0f) {
                return 0;
            }
            if (pixelX >= 5.0f && pixelX < 8.0f) {
                return 1;
            }
            if (pixelX >= 10.0f && pixelX < 12.0f) {
                return 2;
            }
            if (pixelX >= 13.0f && pixelX <= 16.0f) {
                return 3;
            }
        } else {
            if (pixelX >= 2.0f && pixelX < 4.0f) {
                return 3;
            }
            if (pixelX >= 5.0f && pixelX < 8.0f) {
                return 2;
            }
            if (pixelX >= 10.0f && pixelX < 12.0f) {
                return 1;
            }
            if (pixelX >= 13.0f && pixelX <= 16.0f) {
                return 0;
            }
        }
        return -1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof PCIeBlockEntity)) {
            return InteractionResult.PASS;
        }
        PCIeBlockEntity rack = (PCIeBlockEntity)blockEntity;
        int slot = PCIeBlock.getSlotFromHit(state, hit);
        if (slot == -1) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(hand);
        ItemStack slotStack = rack.getInventory().m_8020_(slot);
        TagKey CARDS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("ccx", "pcie_card"));
        if (held.m_41619_()) {
            if (!slotStack.m_41619_()) {
                ItemStack toDrop = slotStack.m_41777_();
                rack.getInventory().m_7407_(slot, 1);
                if (!player.m_36356_(toDrop)) {
                    player.m_36176_(toDrop, false);
                }
                rack.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (slotStack.m_41619_() && held.m_204117_(CARDS)) {
            ItemStack insert = held.m_41777_();
            insert.m_41764_(1);
            rack.getInventory().m_6836_(slot, insert);
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            rack.m_6596_();
            level.m_7260_(pos, state, state, 3);
            level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.8f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PCIeBlockEntity) {
                PCIeBlockEntity rack = (PCIeBlockEntity)blockEntity;
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = rack.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                }
                level.m_46717_(pos, (Block)this);
                level.m_46747_(pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

