/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.block.rack;

import com.awesoft.ccx.block.rack.RackBlockEntity;
import com.awesoft.ccx.item.rack.server.ServerPocketItem;
import com.awesoft.ccx.registry.CCXBlockEntities;
import com.awesoft.ccx.registry.CCXItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RackBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SERVER_SLOT = IntegerProperty.m_61631_((String)"server_slot", (int)0, (int)12);

    public RackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SERVER_SLOT, (Comparable)Integer.valueOf(0))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{SERVER_SLOT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() == null) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RackBlockEntity(pos, state);
    }

    public static int getSlotFromHit(BlockState state, BlockHitResult hit) {
        Vec3 hitVec = hit.m_82450_().m_82492_((double)hit.m_82425_().m_123341_(), (double)hit.m_82425_().m_123342_(), (double)hit.m_82425_().m_123343_());
        float x = (float)hitVec.f_82479_;
        float y = (float)hitVec.f_82480_;
        float z = (float)hitVec.f_82481_;
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (facing) {
            case SOUTH: {
                x = 1.0f - x;
                z = 1.0f - z;
                break;
            }
            case WEST: {
                float t = x;
                x = z;
                z = 1.0f - t;
                break;
            }
            case EAST: {
                float t = x;
                x = 1.0f - z;
                z = t;
            }
        }
        if (y > 0.875f || y < 0.125f) {
            return -1;
        }
        float pixelY = y * 16.0f;
        if (pixelY >= 2.0f && pixelY < 5.0f) {
            return 3;
        }
        if (pixelY >= 5.0f && pixelY < 8.0f) {
            return 2;
        }
        if (pixelY >= 8.0f && pixelY < 11.0f) {
            return 1;
        }
        if (pixelY >= 11.0f && pixelY < 14.0f) {
            return 0;
        }
        return -1;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof RackBlockEntity)) {
            return InteractionResult.PASS;
        }
        RackBlockEntity rack = (RackBlockEntity)blockEntity;
        int slot = RackBlock.getSlotFromHit(state, hit);
        if (slot == -1) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(hand);
        ItemStack slotStack = rack.getInventory().m_8020_(slot);
        if (held.m_41619_()) {
            if (!slotStack.m_41619_()) {
                ItemStack toDrop = slotStack.m_41777_();
                rack.disconnectServer(slot);
                rack.getInventory().m_7407_(slot, 1);
                if (!player.m_36356_(toDrop)) {
                    player.m_36176_(toDrop, false);
                }
                rack.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (slotStack.m_41619_() && held.m_41720_() instanceof ServerPocketItem || slotStack.m_41619_() && held.m_150930_((Item)CCXItems.SERVER_REMOTE.get())) {
                ItemStack insert = held.m_41777_();
                insert.m_41764_(1);
                rack.getInventory().m_6836_(slot, insert);
                if (!player.m_7500_() || held.m_150930_((Item)CCXItems.SERVER_COMMAND.get())) {
                    held.m_41774_(1);
                }
                rack.m_6596_();
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!slotStack.m_41619_() && held.m_150930_((Item)CCXItems.REMOTE_TERMINAL.get())) {
                if (slotStack.m_150930_((Item)CCXItems.SERVER_REMOTE.get())) {
                    CompoundTag tag = held.m_41784_();
                    CompoundTag rackPos = new CompoundTag();
                    rackPos.m_128405_("x", rack.m_58899_().m_123341_());
                    rackPos.m_128405_("y", rack.m_58899_().m_123342_());
                    rackPos.m_128405_("z", rack.m_58899_().m_123343_());
                    tag.m_128365_("rackPos", (Tag)rackPos);
                    tag.m_128405_("slot", slot);
                    player.m_5661_((Component)Component.m_237113_((String)"Bound to Remote Server!"), true);
                    return InteractionResult.SUCCESS;
                }
            } else if (!slotStack.m_41619_() && held.m_150930_((Item)CCXItems.REMOTE_TERMINAL_ADVANCED.get()) && slotStack.m_150930_((Item)CCXItems.SERVER_REMOTE.get())) {
                CompoundTag tag = held.m_41784_();
                if (tag.m_128423_("rackNum") == null) {
                    tag.m_128405_("rackNum", 1);
                }
                int rackNum = tag.m_128451_("rackNum");
                CompoundTag rackTag = new CompoundTag();
                CompoundTag rackPos = new CompoundTag();
                rackPos.m_128405_("x", rack.m_58899_().m_123341_());
                rackPos.m_128405_("y", rack.m_58899_().m_123342_());
                rackPos.m_128405_("z", rack.m_58899_().m_123343_());
                rackTag.m_128365_("rackPos", (Tag)rackPos);
                rackTag.m_128405_("slot", slot);
                tag.m_128365_("rack_" + rackNum, (Tag)rackTag);
                player.m_5661_((Component)Component.m_237113_((String)("Bound to Remote Server: " + rackNum)), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof RackBlockEntity) {
            RackBlockEntity rack = (RackBlockEntity)blockEntity;
            Direction side = null;
            for (Direction d : Direction.values()) {
                if (!pos.m_121945_(d).equals((Object)fromPos)) continue;
                side = d;
                break;
            }
            if (side != null) {
                rack.neighborChanged(side, fromPos);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RackBlockEntity) {
                RackBlockEntity rack = (RackBlockEntity)blockEntity;
                rack.disconnectAllServers();
                for (int i = 0; i < 4; ++i) {
                    ItemStack stack = rack.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
                }
                level.m_46717_(pos, (Block)this);
                level.m_46747_(pos);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RackBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)CCXBlockEntities.RACK_ENTITY.get()), RackBlockEntity::tick);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

