/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.block.rack;

import com.awesoft.ccx.block.rack.RackInventory;
import com.awesoft.ccx.item.rack.server.ServerBrain;
import com.awesoft.ccx.item.rack.server.ServerHolder;
import com.awesoft.ccx.item.rack.server.ServerPocketItem;
import com.awesoft.ccx.item.rack.server.ServerServerComputer;
import com.awesoft.ccx.lib.DirectionLib;
import com.awesoft.ccx.registry.CCXBlockEntities;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RackBlockEntity
extends BlockEntity
implements Container {
    private int invalidSides = 0;
    private final ComponentAccess<IPeripheral> peripherals = PlatformHelper.get().createPeripheralAccess((BlockEntity)this, d -> this.invalidSides |= 1 << d.ordinal());
    public Map<ComputerSide, IPeripheral> periphs;
    private boolean initialized = false;
    boolean suppressUpdates = false;
    private final RackInventory inventory = new RackInventory(this, 4);
    private boolean firstTickHasPast = false;

    public void onChange() {
        this.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.suppressUpdates) {
            return;
        }
        this.updateComputers();
        this.turnOnComputers();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public RackBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CCXBlockEntities.RACK_ENTITY.get(), pPos, pBlockState);
    }

    private void turnOnComputers() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int slot = 0; slot < this.inventory.m_6643_(); ++slot) {
            Item item;
            ItemStack stack = this.inventory.m_8020_(slot);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ServerPocketItem)) continue;
            ServerPocketItem item2 = (ServerPocketItem)item;
            ServerBrain brain = item2.getOrCreateBrain(serverLevel, new ServerHolder.RackHolder(this, slot), stack);
            brain.computer().turnOn();
        }
    }

    public void disconnectAllServers() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int slot = 0; slot < this.inventory.m_6643_(); ++slot) {
            Item item;
            ItemStack stack = this.inventory.m_8020_(slot);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ServerPocketItem)) continue;
            ServerPocketItem item2 = (ServerPocketItem)item;
            ServerBrain brain = item2.getOrCreateBrain(serverLevel, new ServerHolder.RackHolder(this, slot), stack);
            ServerServerComputer comp = brain.computer();
            comp.shutdown();
            for (ComputerSide side : ComputerSide.values()) {
                comp.setPeripheral(side, null);
            }
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void disconnectServer(int slot) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = this.inventory.m_8020_(slot);
        if (stack.m_41619_()) {
            return;
        }
        Item item = stack.m_41720_();
        if (item instanceof ServerPocketItem) {
            ServerPocketItem item2 = (ServerPocketItem)item;
            ServerBrain brain = item2.getOrCreateBrain(serverLevel, new ServerHolder.RackHolder(this, slot), stack);
            ServerServerComputer comp = brain.computer();
            comp.shutdown();
            for (ComputerSide side : ComputerSide.values()) {
                comp.setPeripheral(side, null);
            }
        }
    }

    private void updateComputers() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.f_58857_.m_7654_() == null) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        for (int slot = 0; slot < this.inventory.m_6643_(); ++slot) {
            Item item;
            ItemStack stack = this.inventory.m_8020_(slot);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ServerPocketItem)) continue;
            ServerPocketItem item2 = (ServerPocketItem)item;
            ServerBrain brain = item2.getOrCreateBrain(serverLevel, new ServerHolder.RackHolder(this, slot), stack);
            for (Direction dir : Direction.values()) {
                IPeripheral periph = (IPeripheral)this.peripherals.get(dir);
                ComputerSide side = DirectionLib.toComputerSide(dir, facing);
                if (periph != null) {
                    brain.computer().setPeripheral(side, periph);
                    continue;
                }
                brain.computer().setPeripheral(side, null);
            }
            brain.computer().keepAlive();
        }
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.f_58857_ = level;
        if (level == null || level.f_46443_) {
            return;
        }
        if (!this.initialized && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.m_7654_();
            if (server == null) {
                return;
            }
            this.initialized = true;
        }
    }

    public void neighborChanged(Direction dir, BlockPos neighborPos) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity neighbor = this.f_58857_.m_7702_(neighborPos);
        if (neighbor == null) {
            return;
        }
        this.updateComputers();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RackBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < blockEntity.inventory.m_6643_(); ++i) {
            Item item;
            ItemStack stack = blockEntity.inventory.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ServerPocketItem)) continue;
            ServerPocketItem item2 = (ServerPocketItem)item;
            String label = "";
            MutableComponent labelComp = Component.m_237119_();
            ServerBrain brain = item2.getOrCreateBrain((ServerLevel)level, new ServerHolder.RackHolder(blockEntity, i), stack);
            item2.tick(stack, new ServerHolder.RackHolder(blockEntity, i), false);
        }
        if (!blockEntity.firstTickHasPast) {
            blockEntity.firstTickHasPast = true;
            blockEntity.updateComputers();
            blockEntity.turnOnComputers();
        }
    }

    public RackInventory getInventory() {
        return this.inventory;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.m_6836_(slot, stack);
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.m_8020_(slot);
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public ItemStack m_7407_(int i, int j) {
        return this.inventory.m_7407_(i, j);
    }

    public ItemStack m_8016_(int i) {
        return this.inventory.m_8016_(i);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.save(new CompoundTag()));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.suppressUpdates = true;
        try {
            if (tag.m_128441_("Inventory")) {
                this.inventory.load(tag.m_128469_("Inventory"));
            }
        }
        finally {
            this.suppressUpdates = false;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }
}

