/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.block.usb;

import com.awesoft.ccx.block.usb.USBBlockEntity;
import com.awesoft.ccx.luaFunctions.usb.WirelessUSBFunctions;
import com.awesoft.ccx.misc.WiFiNetwork;
import com.awesoft.ccx.registry.CCXItems;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class USBPeripheral
implements IPeripheral {
    private List<IComputerAccess> computers = new ArrayList<IComputerAccess>();
    private final USBBlockEntity blkEntity;

    public USBPeripheral(USBBlockEntity blkEntity) {
        this.blkEntity = blkEntity;
    }

    public String getType() {
        return "usb_port";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    public void attach(IComputerAccess computer) {
        super.attach(computer);
        this.computers.add(computer);
        if (this.blkEntity.getInventory().m_8020_(0).m_150930_((Item)CCXItems.WIRELESS_USB.get())) {
            ItemStack usb = this.blkEntity.getInventory().m_8020_(0);
            if (usb.m_41784_().m_128423_("channel") == null) {
                usb.m_41784_().m_128405_("channel", 1);
            }
            int channel = usb.m_41784_().m_128451_("channel");
            WiFiNetwork.open(channel, computer, this.blkEntity);
        }
    }

    public void detach(IComputerAccess computer) {
        super.detach(computer);
        this.computers.remove(computer);
        if (this.blkEntity.getInventory().m_8020_(0).m_150930_((Item)CCXItems.WIRELESS_USB.get())) {
            WiFiNetwork.close(computer);
        }
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getMethods() {
        if (this.blkEntity.m_58904_() == null || this.blkEntity.m_58904_().f_46443_) {
            return null;
        }
        HashMap<String, Object> functions = new HashMap<String, Object>();
        ItemStack item = this.blkEntity.getInventory().m_8020_(0);
        if (!item.m_41619_() && item.m_150930_((Item)CCXItems.WIRELESS_USB.get())) {
            WirelessUSBFunctions funcs = new WirelessUSBFunctions(this.blkEntity, this.computers);
            functions.put("usb", funcs.getFunctions());
        }
        return functions;
    }
}

