/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.item;

import com.awesoft.ccx.block.rack.RackBlockEntity;
import com.awesoft.ccx.registry.CCXItems;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RemoteTerminalItem
extends Item {
    public RemoteTerminalItem(Item.Properties properties) {
        super(properties);
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("SessionId") ? nbt.m_128451_("SessionId") : -1;
    }

    @javax.annotation.Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_("InstanceId") ? nbt.m_128342_("InstanceId") : null;
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        try {
            int sessionId = tag.m_128451_("SessionId");
            UUID instanceId = tag.m_128342_("InstanceId");
            if (instanceId != null) {
                return registry.get(sessionId, instanceId);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    @javax.annotation.Nullable
    public static ServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        try {
            ServerContext.get((MinecraftServer)server);
        }
        catch (Exception e) {
            return null;
        }
        if (server != null) {
            return RemoteTerminalItem.getServerComputer(ServerContext.get((MinecraftServer)server).registry(), stack);
        }
        return null;
    }

    static void openImpl(Player player, ItemStack stack, boolean isTypingOnly, ServerComputer computer) {
        PlatformHelper.get().openMenu(player, stack.m_41786_(), (id, inventory, entity) -> new ComputerMenuWithoutInventory((MenuType)ModRegistry.Menus.COMPUTER.get(), id, inventory, p -> true, computer), (ContainerData)new ComputerContainerData(computer, stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack held = player.m_21120_(interactionHand);
        CompoundTag tag = held.m_41783_();
        if (level.f_46443_ || tag == null) {
            return InteractionResultHolder.m_19100_((Object)held);
        }
        if (player.m_6047_()) {
            Vec3 look;
            Vec3 end;
            Vec3 start = player.m_20299_(1.0f);
            BlockHitResult result = level.m_45547_(new ClipContext(start, end = start.m_82549_((look = player.m_20154_()).m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (result.m_6662_() == HitResult.Type.BLOCK || held.m_41783_() == null || held.m_41783_().m_128423_("rackPos") == null) {
                return InteractionResultHolder.m_19100_((Object)held);
            }
            held.m_41783_().m_128473_("rackPos");
            held.m_41783_().m_128473_("slot");
            player.m_5661_((Component)Component.m_237113_((String)"Unlinked rack!"), true);
            return InteractionResultHolder.m_19090_((Object)held);
        }
        CompoundTag posTag = tag.m_128469_("rackPos");
        BlockEntity blkEnt = level.m_7702_(new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
        if (blkEnt instanceof RackBlockEntity) {
            ItemStack serverItem;
            RackBlockEntity rackEnt = (RackBlockEntity)blkEnt;
            int serverSlot = tag.m_128451_("slot") - 1;
            if (serverSlot < 0) {
                serverSlot = 3;
            }
            if (!(serverItem = rackEnt.getInventory().m_8020_(serverSlot)).m_150930_((Item)CCXItems.SERVER_ADVANCED.get()) && !serverItem.m_150930_((Item)CCXItems.SERVER_COMMAND.get())) {
                player.m_5661_((Component)Component.m_237113_((String)"No server above Remote Server!"), true);
                return InteractionResultHolder.m_19100_((Object)held);
            }
            ServerComputer comp = RemoteTerminalItem.getServerComputer(level.m_7654_(), serverItem);
            String label = comp.getLabel();
            if (label != null) {
                held.m_41714_((Component)Component.m_237113_((String)label));
            }
            RemoteTerminalItem.openImpl(player, serverItem, false, comp);
            return InteractionResultHolder.m_19090_((Object)held);
        }
        return InteractionResultHolder.m_19098_((Object)held);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (itemStack.m_41783_() == null || itemStack.m_41783_().m_128423_("rackPos") == null) {
            return;
        }
        CompoundTag pos = itemStack.m_41783_().m_128469_("rackPos");
        String posString = ": " + pos.m_128451_("x") + ", " + pos.m_128451_("y") + ", " + pos.m_128451_("z");
        list.add((Component)Component.m_237115_((String)"item.tooltip.terminal_blockpos").m_130946_(posString));
    }
}

