/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.item.rack.server;

import com.awesoft.ccx.item.rack.server.ServerHolder;
import com.awesoft.ccx.item.rack.server.ServerPocketItem;
import com.awesoft.ccx.item.rack.server.ServerServerComputer;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class ServerBrain
implements IPocketAccess {
    private final ServerServerComputer computer;
    private ServerHolder holder;
    private Vec3 position;
    private boolean dirty = false;
    @Nullable
    private UpgradeData<IPocketUpgrade> upgrade;
    private int colour = -1;
    private int lightColour = -1;

    public ServerBrain(ServerHolder holder, @Nullable UpgradeData<IPocketUpgrade> upgrade, ServerComputer.Properties properties) {
        this.computer = new ServerServerComputer(this, holder, properties);
        this.holder = holder;
        this.position = holder.pos();
        this.upgrade = UpgradeData.copyOf(upgrade);
        this.invalidatePeripheral();
    }

    public ServerServerComputer computer() {
        return this.computer;
    }

    ServerHolder holder() {
        return this.holder;
    }

    public void updateHolder(ServerHolder newHolder) {
        this.position = newHolder.pos();
        this.computer.setPosition(newHolder.level(), newHolder.blockPos());
        ServerHolder oldHolder = this.holder;
        if (!this.holder.equals(newHolder)) {
            ServerPlayer var10000;
            this.holder = newHolder;
            if (oldHolder instanceof ServerHolder.PlayerHolder) {
                ServerHolder.PlayerHolder p = (ServerHolder.PlayerHolder)oldHolder;
                var10000 = p.entity();
            } else {
                var10000 = null;
            }
            ServerPlayer oldPlayer = var10000;
            if (newHolder instanceof ServerHolder.PlayerHolder) {
                ServerHolder.PlayerHolder playerHolder = (ServerHolder.PlayerHolder)newHolder;
            }
        }
    }

    public boolean updateItem(ItemStack stack) {
        if (!this.dirty) {
            return false;
        }
        this.dirty = false;
        IColouredItem.setColourBasic((ItemStack)stack, (int)this.colour);
        ServerPocketItem.setUpgrade(stack, (UpgradeData<IPocketUpgrade>)UpgradeData.copyOf(this.upgrade));
        return true;
    }

    public ServerLevel getLevel() {
        return this.computer.getLevel();
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getEntity() {
        ServerHolder var2 = this.holder;
        if (var2 instanceof ServerHolder.EntityHolder) {
            ServerHolder.EntityHolder entity = (ServerHolder.EntityHolder)var2;
            if (this.holder.isValid(this.computer)) {
                Entity var10000 = entity.entity();
                return var10000;
            }
        }
        Entity var10000 = null;
        return var10000;
    }

    public int getColour() {
        return this.colour;
    }

    public void setColour(int colour) {
        if (this.colour != colour) {
            this.dirty = true;
            this.colour = colour;
        }
    }

    public int getLight() {
        return this.lightColour;
    }

    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        this.lightColour = colour;
    }

    public CompoundTag getUpgradeNBTData() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? new CompoundTag() : upgrade.data();
    }

    public void updateUpgradeNBTData() {
        this.dirty = true;
    }

    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : ((IPocketUpgrade)this.upgrade.upgrade()).createPeripheral((IPocketAccess)this);
        this.computer.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Deprecated(forRemoval=true)
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
        return upgrade == null ? Map.of() : Collections.singletonMap(((IPocketUpgrade)upgrade.upgrade()).getUpgradeID(), this.computer.getPeripheral(ComputerSide.BACK));
    }

    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        if (!Objects.equals(this.upgrade, upgrade)) {
            this.upgrade = UpgradeData.copyOf(upgrade);
            this.dirty = true;
            this.invalidatePeripheral();
        }
    }
}

