/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.item.rack.server;

import com.awesoft.ccx.item.rack.server.ServerBrain;
import com.awesoft.ccx.item.rack.server.ServerHolder;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public final class ServerServerComputer
extends ServerComputer {
    private final ServerBrain brain;
    private int oldLightColour = -1;
    @Nullable
    private ComputerState oldComputerState;
    private Set<ServerPlayer> tracking = Set.of();

    ServerServerComputer(ServerBrain brain, ServerHolder holder, ServerComputer.Properties properties) {
        super(holder.level(), holder.blockPos(), properties.terminalSize(((Integer)ConfigSpec.computerTermWidth.get()).intValue(), ((Integer)ConfigSpec.computerTermHeight.get()).intValue()));
        this.brain = brain;
        if (brain.computer() != null && brain.computer().getFamily() == ComputerFamily.COMMAND) {
            properties.addComponent(ComputerComponents.ADMIN_COMPUTER, (Object)new AdminComputer(){

                public int permissionLevel() {
                    return 4;
                }
            });
        }
    }

    public ServerBrain getBrain() {
        return this.brain;
    }

    protected void onRemoved() {
        super.onRemoved();
        ServerNetworking.sendToAllPlayers((NetworkMessage)new PocketComputerDeletedClientMessage(this.getInstanceUUID()), (MinecraftServer)this.getLevel().m_7654_());
    }
}

