/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.lib;

import dan200.computercraft.core.computer.ComputerSide;
import net.minecraft.core.Direction;

public class DirectionLib {
    public static ComputerSide toComputerSide(Direction direction, Direction blockFacing) {
        if (direction == Direction.UP) {
            return ComputerSide.TOP;
        }
        if (direction == Direction.DOWN) {
            return ComputerSide.BOTTOM;
        }
        return switch (blockFacing) {
            case Direction.NORTH -> {
                switch (direction) {
                    case NORTH: {
                        yield ComputerSide.FRONT;
                    }
                    case SOUTH: {
                        yield ComputerSide.BACK;
                    }
                    case WEST: {
                        yield ComputerSide.RIGHT;
                    }
                    case EAST: {
                        yield ComputerSide.LEFT;
                    }
                }
                yield ComputerSide.BACK;
            }
            case Direction.SOUTH -> {
                switch (direction) {
                    case NORTH: {
                        yield ComputerSide.BACK;
                    }
                    case SOUTH: {
                        yield ComputerSide.FRONT;
                    }
                    case WEST: {
                        yield ComputerSide.LEFT;
                    }
                    case EAST: {
                        yield ComputerSide.RIGHT;
                    }
                }
                yield ComputerSide.BACK;
            }
            case Direction.EAST -> {
                switch (direction) {
                    case NORTH: {
                        yield ComputerSide.RIGHT;
                    }
                    case SOUTH: {
                        yield ComputerSide.LEFT;
                    }
                    case WEST: {
                        yield ComputerSide.BACK;
                    }
                    case EAST: {
                        yield ComputerSide.FRONT;
                    }
                }
                yield ComputerSide.BACK;
            }
            case Direction.WEST -> {
                switch (direction) {
                    case NORTH: {
                        yield ComputerSide.LEFT;
                    }
                    case SOUTH: {
                        yield ComputerSide.RIGHT;
                    }
                    case WEST: {
                        yield ComputerSide.FRONT;
                    }
                    case EAST: {
                        yield ComputerSide.BACK;
                    }
                }
                yield ComputerSide.BACK;
            }
            default -> ComputerSide.BACK;
        };
    }

    public static ComputerSide fromString(String string) {
        if (string.equalsIgnoreCase("front")) {
            return ComputerSide.FRONT;
        }
        if (string.equalsIgnoreCase("back")) {
            return ComputerSide.BACK;
        }
        if (string.equalsIgnoreCase("top")) {
            return ComputerSide.TOP;
        }
        if (string.equalsIgnoreCase("bottom")) {
            return ComputerSide.BOTTOM;
        }
        if (string.equalsIgnoreCase("right")) {
            return ComputerSide.RIGHT;
        }
        if (string.equalsIgnoreCase("left")) {
            return ComputerSide.LEFT;
        }
        return null;
    }
}

