/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.lib;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class LuaConverter {
    @Nullable
    public static Object nbtToLua(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        switch (tag.m_7060_()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ((NumericTag)tag).m_7046_();
            }
            case 5: 
            case 6: {
                return ((NumericTag)tag).m_7061_();
            }
            case 8: {
                return tag.m_7916_();
            }
            case 10: {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.m_128440_());
                for (String key : compound.m_128431_()) {
                    Object value = LuaConverter.nbtToLua(compound.m_128423_(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                return map;
            }
            case 9: {
                ListTag list = (ListTag)tag;
                HashMap<Integer, Object> map = new HashMap<Integer, Object>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    map.put(i, LuaConverter.nbtToLua(list.get(i)));
                }
                return map;
            }
            case 7: {
                byte[] array = ((ByteArrayTag)tag).m_128227_();
                HashMap<Integer, Byte> map = new HashMap<Integer, Byte>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
            case 11: {
                int[] array = ((IntArrayTag)tag).m_128648_();
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(array.length);
                for (int i = 0; i < array.length; ++i) {
                    map.put(i + 1, array[i]);
                }
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> itemToLua(int invSlot, Container inv) {
        HashMap<String, Object> itemInfo = new HashMap<String, Object>();
        ItemStack item = inv.m_8020_(invSlot);
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_());
        if (item.m_41619_()) {
            return null;
        }
        itemInfo.put("displayName", item.m_41611_().getString());
        itemInfo.put("name", id.toString());
        itemInfo.put("count", item.m_41613_());
        itemInfo.put("maxStackSize", item.m_41741_());
        itemInfo.put("nbt", LuaConverter.nbtToLua((Tag)item.m_41777_().m_41784_()));
        if (item.m_41763_()) {
            itemInfo.put("damage", item.m_41773_());
            itemInfo.put("maxDamage", item.m_41776_());
        }
        return itemInfo;
    }
}

