/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx.misc;

import com.awesoft.ccx.block.usb.USBBlockEntity;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.NotAttachedException;
import java.util.ArrayList;
import java.util.List;

public class WiFiNetwork {
    private static final List<Listener> listeners = new ArrayList<Listener>();

    public static void broadcast(String message, int channel, List<IComputerAccess> computers) {
        try {
            listeners.forEach(listener -> {
                boolean isHost = false;
                for (IComputerAccess computer : computers) {
                    if (listener.computer.getID() != computer.getID()) continue;
                    isHost = true;
                }
                if (isHost) {
                    return;
                }
                if (listener.channel == channel) {
                    IComputerAccess comp = listener.computer;
                    comp.queueEvent("wifi_message", new Object[]{channel, message});
                }
            });
        }
        catch (NotAttachedException notAttachedException) {
            // empty catch block
        }
    }

    public static void open(int channel, IComputerAccess comp, USBBlockEntity blkEnt) {
        try {
            for (int i = 0; i < listeners.size(); ++i) {
                if (WiFiNetwork.listeners.get((int)i).computer.getID() != comp.getID()) continue;
                listeners.remove(i);
            }
            listeners.add(new Listener(comp, channel, blkEnt));
        }
        catch (NotAttachedException notAttachedException) {
            // empty catch block
        }
    }

    public static boolean close(IComputerAccess comp) {
        try {
            for (int i = 0; i < listeners.size(); ++i) {
                if (WiFiNetwork.listeners.get((int)i).computer.getID() != comp.getID()) continue;
                listeners.remove(i);
                return true;
            }
        }
        catch (NotAttachedException notAttachedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean closeAll(USBBlockEntity blkEnt) {
        try {
            for (int i = 0; i < listeners.size(); ++i) {
                if (WiFiNetwork.listeners.get((int)i).blkEnt == blkEnt) {
                    listeners.remove(i);
                    return true;
                }
                if (WiFiNetwork.listeners.get((int)i).blkEnt.m_58899_() != blkEnt.m_58899_()) continue;
                listeners.remove(i);
                return true;
            }
        }
        catch (NotAttachedException notAttachedException) {
            // empty catch block
        }
        return false;
    }

    static class Listener {
        public final int channel;
        public final IComputerAccess computer;
        public final USBBlockEntity blkEnt;

        Listener(IComputerAccess computer, int channel, USBBlockEntity blkEnt) {
            this.computer = computer;
            this.channel = channel;
            this.blkEnt = blkEnt;
        }
    }
}

