/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_drones.api;

import com.awesoft.ccx_drones.entity.drone.DroneEntity;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaFunction;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DroneAPI
implements ILuaAPI {
    DroneEntity drone;

    public DroneAPI(DroneEntity entity) {
        this.drone = entity;
    }

    public String[] getNames() {
        return new String[]{"drone"};
    }

    @LuaFunction
    public final MethodResult engineOn(boolean on) {
        this.drone.setEngineOn(on);
        if (!on) {
            this.drone.m_20256_(Vec3.f_82478_);
        }
        if (on) {
            return MethodResult.of((Object[])new Object[]{true, "Turned On Engine!"});
        }
        return MethodResult.of((Object[])new Object[]{true, "Turned Off Engine"});
    }

    @LuaFunction
    public final MethodResult hoverOn(boolean on) {
        this.drone.m_20242_(on);
        if (on) {
            return MethodResult.of((Object[])new Object[]{true, "Hover on!"});
        }
        return MethodResult.of((Object[])new Object[]{true, "Hover Off!"});
    }

    @LuaFunction
    public final void right(int deg) {
        this.drone.m_19884_(deg, 0.0);
    }

    @LuaFunction
    public final void left(int deg) {
        this.right(-deg);
    }

    @LuaFunction
    public final boolean isColliding() {
        return this.drone.f_19862_;
    }

    @LuaFunction
    public final void up(int amount) {
        this.drone.m_246865_(Vec3.f_82478_.m_82520_(0.0, (double)amount / 10.0, 0.0));
    }

    @LuaFunction
    public final void down(int amount) {
        this.up(-amount);
    }

    @LuaFunction
    public final MethodResult lookForward() {
        ClipContext context = new ClipContext(this.drone.m_20097_().m_252807_(), this.drone.m_20097_().m_252807_().m_82549_(this.drone.m_20156_().m_82542_(3.0, 3.0, 3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
        BlockHitResult result = this.drone.m_9236_().m_45547_(context);
        return MethodResult.of((Object)VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails((Object)new BlockReference(this.drone.m_9236_(), result.m_82425_())));
    }

    @LuaFunction
    public final float rotation() {
        return this.drone.f_19859_;
    }

    @LuaFunction
    public final MethodResult lookBack() {
        ClipContext context = new ClipContext(this.drone.m_20097_().m_252807_(), this.drone.m_20097_().m_252807_().m_82549_(this.drone.m_20156_().m_82542_(-3.0, -3.0, -3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
        BlockHitResult result = this.drone.m_9236_().m_45547_(context);
        return MethodResult.of((Object)VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails((Object)new BlockReference(this.drone.m_9236_(), result.m_82425_())));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult moveTo(int x, int y, int z) {
        double newPosX = this.drone.m_20097_().m_123341_() + x;
        double newPosY = this.drone.m_20097_().m_123342_() + y;
        double newPosZ = this.drone.m_20097_().m_123343_() + z;
        this.drone.setTargetPos(new Vec3(newPosX, newPosY, newPosZ));
        return MethodResult.of((Object[])new Object[]{true, "Moving to new pos!"});
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getUpgradesFunctions() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        ILuaFunction breakForward = args -> {
            if (this.drone.hasUpgrade("ccx_drones:mine_upgrade")) {
                ClipContext context = new ClipContext(this.drone.m_20097_().m_252807_(), this.drone.m_20097_().m_252807_().m_82549_(this.drone.m_20156_().m_82542_(3.0, 3.0, 3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
                BlockHitResult result = this.drone.m_9236_().m_45547_(context);
                this.drone.m_9236_().m_46953_(result.m_82425_(), true, (Entity)this.drone);
                return MethodResult.of((Object[])new Object[]{true, "Broke Block!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Mining Upgrade not installed!"});
        };
        if (this.drone.hasUpgrade("ccx_drones:mine_upgrade")) {
            info.put("breakForward", breakForward);
        }
        ILuaFunction pickupBlock = args -> {
            if (this.drone.hasUpgrade("ccx_drones:carry_upgrade")) {
                ClipContext context = new ClipContext(this.drone.m_20097_().m_252807_(), this.drone.m_20097_().m_252807_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
                BlockHitResult result = this.drone.m_9236_().m_45547_(context);
                this.drone.setCarrying(result.m_82425_());
                return MethodResult.of((Object[])new Object[]{true, "Picked Up Block!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Carry Upgrade not installed!"});
        };
        ILuaFunction dropBlock = args -> {
            if (this.drone.hasUpgrade("ccx_drones:carry_upgrade")) {
                ClipContext context = new ClipContext(this.drone.m_20097_().m_252807_(), this.drone.m_20097_().m_252807_().m_82520_(0.0, -2.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
                BlockHitResult result = this.drone.m_9236_().m_45547_(context);
                this.drone.dropCarrying(result.m_82425_().m_7494_());
                return MethodResult.of((Object[])new Object[]{true, "Dropped Block!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Carry Upgrade not installed!"});
        };
        ILuaFunction pickUpEntity = args -> {
            if (this.drone.hasUpgrade("ccx_drones:carry_upgrade")) {
                List targets = this.drone.m_9236_().m_45976_(Entity.class, new AABB(this.drone.m_20097_().m_7918_(-2, -2, -2), this.drone.m_20097_().m_7918_(2, 0, 2)));
                if (!targets.isEmpty()) {
                    ((Entity)targets.get(this.drone.m_217043_().m_188503_(targets.size()))).m_20329_((Entity)this.drone);
                    return MethodResult.of((Object[])new Object[]{true, "Picked up Entity!"});
                }
                return MethodResult.of((Object[])new Object[]{false, "No Entities Nearby!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Carry Upgrade Not Installed!"});
        };
        ILuaFunction dropEntity = args -> {
            if (this.drone.hasUpgrade("ccx_drones:carry_upgrade")) {
                if (!this.drone.m_20197_().isEmpty()) {
                    this.drone.m_20153_();
                    return MethodResult.of((Object[])new Object[]{true, "Ejected Passenger!"});
                }
                return MethodResult.of((Object[])new Object[]{false, "No Passengers!"});
            }
            return MethodResult.of((Object[])new Object[]{false, "Carry Upgrade Not Installed!"});
        };
        if (this.drone.hasUpgrade("ccx_drones:carry_upgrade")) {
            info.put("pickupBlock", pickupBlock);
            info.put("dropBlock", dropBlock);
            info.put("pickupEntity", pickUpEntity);
            info.put("dropEntity", dropEntity);
        }
        ILuaFunction getPos = args -> {
            if (this.drone.hasUpgrade("ccx_drones:modem_upgrade")) {
                HashMap<String, Double> posinfo = new HashMap<String, Double>();
                posinfo.put("x", this.drone.m_20182_().f_82479_);
                posinfo.put("y", this.drone.m_20182_().f_82480_);
                posinfo.put("z", this.drone.m_20182_().f_82481_);
                return MethodResult.of((Object[])new Object[]{true, posinfo});
            }
            return MethodResult.of((Object[])new Object[]{false, "Modem Upgrade Not Installed!"});
        };
        if (this.drone.hasUpgrade("ccx_drones:modem_upgrade")) {
            info.put("getPos", getPos);
        }
        ILuaFunction raycast = args -> {
            Vec3 start = this.drone.m_20299_(0.0f);
            Vec3 end = start.m_82549_(this.drone.m_20156_().m_82490_(5.0));
            ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.drone);
            BlockHitResult result = this.drone.m_9236_().m_45547_(context);
            if (result.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = result.m_82425_();
                Block block = this.drone.m_9236_().m_8055_(pos).m_60734_();
                HashMap<String, Object> blockinfo = new HashMap<String, Object>();
                blockinfo.put("id", BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
                blockinfo.put("distance", start.m_82554_(result.m_82450_()));
                return MethodResult.of((Object[])new Object[]{true, blockinfo});
            }
            return MethodResult.of((Object[])new Object[]{false, "Raycast hit non block!"});
        };
        if (this.drone.hasUpgrade("ccx_drones:survey_upgrade")) {
            info.put("raycast", raycast);
        }
        return info;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listUpgrades() {
        ArrayList<String> result = new ArrayList<String>();
        int size = this.drone.getInventory().m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.drone.getInventory().m_8020_(i);
            if (stack.m_41619_()) continue;
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            result.add(id.toString());
        }
        return MethodResult.of((Object[])new Object[]{true, result});
    }

    @LuaFunction(mainThread=true)
    public final MethodResult hasUpgrade(String upgradeid) {
        return MethodResult.of((Object)this.drone.hasUpgrade(upgradeid));
    }
}

