/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_drones.entity.drone;

import com.awesoft.ccx.CCX;
import com.awesoft.ccx_drones.entity.drone.DroneBrain;
import com.awesoft.ccx_drones.entity.drone.DroneInventory;
import com.awesoft.ccx_drones.menu.DroneMenu;
import com.awesoft.ccx_drones.registry.CCXDComponents;
import com.awesoft.ccx_drones.registry.CCXDItems;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DroneEntity
extends Mob {
    private Vec3 targetPos;
    DroneBrain brain = new DroneBrain(this);
    public static final EntityDataAccessor<CompoundTag> EXTRA = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public static final EntityDataAccessor<CompoundTag> CLIENT_INVENTORY = SynchedEntityData.m_135353_(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    int INVENTORY_SIZE = 7;
    private final DroneInventory inventory = new DroneInventory(this.INVENTORY_SIZE, this);
    private boolean loaderActive = false;
    public float propellerRotation;

    public DroneEntity(EntityType<DroneEntity> e, Level level) {
        super(e, level);
    }

    public int getInvSize() {
        return this.INVENTORY_SIZE;
    }

    public Container getInventory() {
        return this.inventory;
    }

    public void setTargetPos(Vec3 pos) {
        this.targetPos = pos;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.m_21224_()) {
            ServerComputer computer = this.createOrUpkeepComputer();
            computer.keepAlive();
            if (this.targetPos != null) {
                Vec3 targetCenter = new Vec3(this.targetPos.f_82479_ + 0.5, this.targetPos.f_82480_ + 0.5, this.targetPos.f_82481_ + 0.5);
                Vec3 dir = targetCenter.m_82546_(this.m_20182_()).m_82541_();
                double speed = 0.1;
                this.m_20256_(this.m_20184_().m_82490_(0.9).m_82549_(dir.m_82490_(speed)));
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, targetCenter);
                if (this.m_20182_().m_82509_((Position)targetCenter, 0.5)) {
                    this.targetPos = null;
                    this.m_20256_(Vec3.f_82478_);
                    Object[] eventarg = new Object[]{"drone_movement"};
                    computer.queueEvent("task_complete", eventarg);
                }
            }
        }
        if (this.engineOn()) {
            this.m_20256_(this.m_20156_().m_82542_(0.1, 0.1, 0.1));
        }
        this.propellerRotation = (this.propellerRotation + 25.0f) % 360.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (!this.m_9236_().f_46443_ && held.m_41619_()) {
            ServerComputer computer = this.getServerComputer();
            if (computer == null) {
                return InteractionResult.FAIL;
            }
            PlatformHelper.get().openMenu(player, player.m_21120_(hand).m_41786_(), (id, inventory, entity) -> new DroneMenu(id, p -> true, ComputerFamily.ADVANCED, computer, null, player.m_150109_(), this.getInventory(), (net.minecraft.world.inventory.ContainerData)((SingleContainerData)this.brain::getSelectedSlot)), (ContainerData)new ComputerContainerData(computer, ItemStack.f_41583_));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("extra", (Tag)this.f_19804_.m_135370_(EXTRA));
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            this.inventory.m_8020_(i).m_41739_(itemTag);
            itemsList.add((Object)itemTag);
        }
        compoundTag.m_128365_("Inventory", (Tag)itemsList);
    }

    protected void m_8097_() {
        super.m_8097_();
        CompoundTag a = new CompoundTag();
        this.f_19804_.m_135372_(EXTRA, (Object)a.m_6426_());
        this.f_19804_.m_135372_(CLIENT_INVENTORY, (Object)new CompoundTag());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(EXTRA, (Object)compoundTag.m_128469_("extra"));
        ListTag itemsList = compoundTag.m_128437_("Inventory", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemTag = itemsList.m_128728_(i);
            byte slot = itemTag.m_128445_("Slot");
            if (slot < 0 || slot >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
        this.syncInventoryToClient();
    }

    public void setComputerID(int computerID) {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        tag.m_128405_("computerID", computerID);
        this.f_19804_.m_135381_(EXTRA, (Object)tag);
    }

    public void setCarrying(BlockPos pos) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        System.out.println("picking up!");
        BlockState state = this.m_9236_().m_8055_(pos);
        BlockEntity entity = this.m_9236_().m_7702_(pos);
        CCX.LOGGER.info((Object)entity);
        CCX.LOGGER.info((Object)this.m_9236_().m_7702_(new BlockPos(7, -52, 20)));
        CompoundTag stateTag = NbtUtils.m_129202_((BlockState)state);
        tag.m_128365_("carryingState", (Tag)stateTag);
        if (entity != null) {
            CompoundTag entityTag = entity.m_187480_();
            entityTag.m_128473_("x");
            entityTag.m_128473_("y");
            entityTag.m_128473_("z");
            tag.m_128365_("carryingEntity", (Tag)entityTag);
            this.f_19804_.m_276349_(EXTRA, (Object)tag, true);
            tag = null;
            Clearable.m_18908_((Object)entity);
        }
        if (tag != null) {
            this.f_19804_.m_276349_(EXTRA, (Object)tag, true);
        }
        this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public void dropCarrying(BlockPos pos) {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        if (tag.m_128441_("carryingState")) {
            System.out.println("dropping!");
            BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tag.m_128469_("carryingState"));
            this.m_9236_().m_7731_(pos, state, 2);
            if (tag.m_128441_("carryingEntity")) {
                BlockEntity entity = BlockEntity.m_155241_((BlockPos)pos, (BlockState)state, (CompoundTag)tag.m_128469_("carryingEntity"));
                entity.m_142339_(this.m_9236_());
                entity.m_155250_(state);
                this.m_9236_().m_151523_(entity);
                tag.m_128473_("carryingEntity");
            }
            tag.m_128473_("carryingState");
            this.f_19804_.m_276349_(EXTRA, (Object)tag, true);
        }
    }

    public boolean canPlayerUse(Player player) {
        return true;
    }

    public boolean isCarryingBlock() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        return tag.m_128441_("carryingState");
    }

    public void setComputerUUID(UUID computerUUID) {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        tag.m_128362_("computerUUID", computerUUID);
        this.f_19804_.m_135381_(EXTRA, (Object)tag);
    }

    public void syncInventoryToClient() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            tag.m_128365_("Slot" + i, (Tag)itemTag);
        }
        this.f_19804_.m_135381_(CLIENT_INVENTORY, (Object)tag);
    }

    public ItemStack getSlotForRenderer(int slot) {
        if (!this.m_9236_().f_46443_) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(CLIENT_INVENTORY);
        if (tag.m_128441_("Slot" + slot)) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_("Slot" + slot));
        }
        return ItemStack.f_41583_;
    }

    public boolean hasUpgrade(String upgrade) {
        Item stringItem = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(upgrade));
        if (stringItem != null && stringItem != Items.f_41852_) {
            return this.inventory.m_18949_(Set.of(stringItem));
        }
        return false;
    }

    public void setEngineOn(boolean on) {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        tag.m_128379_("engineOn", on);
        this.f_19804_.m_135381_(EXTRA, (Object)tag);
    }

    public boolean engineOn() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        if (tag.m_128441_("engineOn")) {
            return tag.m_128471_("engineOn");
        }
        return false;
    }

    public int getComputerID() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        if (tag.m_128441_("computerID")) {
            return tag.m_128451_("computerID");
        }
        return -1;
    }

    public UUID getComputerUUID() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(EXTRA);
        if (tag.m_128441_("computerUUID")) {
            return tag.m_128342_("computerUUID");
        }
        return null;
    }

    public void setAllData(CompoundTag tag) {
        this.f_19804_.m_135381_(EXTRA, (Object)tag);
    }

    public CompoundTag getAllData() {
        return (CompoundTag)this.f_19804_.m_135370_(EXTRA);
    }

    public ServerComputer createOrUpkeepComputer() {
        ServerContext context = ServerContext.get((MinecraftServer)this.m_20194_());
        ServerComputer computer = context.registry().get(this.getComputerUUID());
        if (computer == null) {
            if (this.getComputerID() < 0) {
                System.out.println("defining ID");
                this.setComputerID(ComputerCraftAPI.createUniqueNumberedSaveDir((MinecraftServer)this.m_20194_(), (String)"computer"));
            }
            computer = new ServerComputer((ServerLevel)this.m_9236_(), this.m_20097_(), ServerComputer.properties((int)this.getComputerID(), (ComputerFamily)ComputerFamily.ADVANCED).addComponent(CCXDComponents.DRONEAPI, (Object)this).terminalSize(39, 13));
            System.out.println("Computer ID: " + computer.getID());
            this.setComputerUUID(computer.register());
            computer.turnOn();
        }
        return computer;
    }

    public ServerComputer getServerComputer() {
        ServerContext context = ServerContext.get((MinecraftServer)this.m_20194_());
        ServerComputer computer = context.registry().get(this.getComputerUUID());
        return computer;
    }

    protected void m_6668_(DamageSource damageSource) {
        super.m_6668_(damageSource);
        ServerContext context = ServerContext.get((MinecraftServer)this.m_20194_());
        ServerComputer computer = context.registry().get(this.getComputerUUID());
        if (computer != null) {
            computer.close();
        }
        ItemStack stack = new ItemStack((ItemLike)CCXDItems.DRONE_ITEM.get());
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("extra", (Tag)this.getAllData());
        stack.m_41751_(compoundTag);
        ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)entity);
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack invItem = this.getInventory().m_8020_(i);
            if (invItem.m_41619_()) continue;
            ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), invItem);
            this.m_9236_().m_7967_((Entity)drop);
        }
    }

    public double m_6048_() {
        return -2.0;
    }
}

