/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_drones.menu;

import com.awesoft.ccx_drones.entity.drone.DroneBrain;
import com.awesoft.ccx_drones.menu.slots.DroneUpgradeSlot;
import com.awesoft.ccx_drones.menu.slots.DroneUpgradeType;
import com.awesoft.ccx_drones.registry.CCXDMenu;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.container.SingleContainerData;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DroneMenu
extends AbstractComputerMenu {
    public static final int BORDER = 8;
    public static final int PLAYER_START_Y = 134;
    public static final int TURTLE_START_X = 192;
    public static final int PLAYER_START_X = 25;
    public static final int UPGRADE_START_X = 211;
    int PLAYER_INV_START = 0;
    int PLAYER_HOTBAR_START = 27;
    int DRONE_UPGRADE_SLOT = 36;
    private final ContainerData data;

    public DroneMenu(int id, Predicate<Player> canUse, ComputerFamily family, @Nullable ServerComputer computer, @Nullable ComputerContainerData menuData, Inventory playerInventory, Container droneUpgrades, ContainerData data) {
        super((MenuType)CCXDMenu.DRONE_MENU.get(), id, canUse, family, computer, menuData);
        this.data = data;
        this.m_38884_(data);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 25 + x * 18, 135 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 25 + x * 18, 193));
        }
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.TOP, 0, 211, 135));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.INTERNAL, 1, 211, 153));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.LEFT, 2, 193, 153));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.RIGHT, 3, 229, 153));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.BOTTOM, 4, 211, 171));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.FRONT, 5, 247, 135));
        this.m_38897_(new DroneUpgradeSlot(droneUpgrades, DroneUpgradeType.BACK, 6, 247, 171));
    }

    public static DroneMenu ofBrain(int id, Inventory player, DroneBrain drone) {
        return new DroneMenu(id, p -> drone.getOwner().canPlayerUse((Player)p), ComputerFamily.ADVANCED, drone.getOwner().createOrUpkeepComputer(), null, player, drone.getOwner().getInventory(), (ContainerData)((SingleContainerData)drone::getSelectedSlot));
    }

    public static DroneMenu ofMenuData(int id, Inventory player, ComputerContainerData data) {
        return new DroneMenu(id, x -> true, data.family(), null, data, player, (Container)new SimpleContainer(7), (ContainerData)new SimpleContainerData(1));
    }

    private ItemStack tryItemMerge(Player player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        ItemStack originalStack = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            originalStack = clickedStack.m_41777_();
            if (!this.m_38903_(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() != originalStack.m_41613_()) {
                slot.m_142406_(player, clickedStack);
            } else {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    public ItemStack m_7648_(Player player, int slotNum) {
        int hotbarEnd;
        int playerInvEnd;
        int playerInvStart = 0;
        int hotbarStart = playerInvEnd = 27;
        int droneStart = hotbarEnd = hotbarStart + 9;
        int droneEnd = droneStart + 7;
        if (slotNum >= droneStart && slotNum < droneEnd) {
            return this.tryItemMerge(player, slotNum, playerInvStart, hotbarEnd, true);
        }
        if (slotNum >= playerInvStart && slotNum < hotbarEnd) {
            return this.tryItemMerge(player, slotNum, droneStart, droneEnd, false);
        }
        return ItemStack.f_41583_;
    }
}

