/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_pocket.api;

import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HeadMountDisplayAPI
implements ILuaAPI {
    private final IComputerSystem computer;
    private final IPocketAccess pocket;

    public HeadMountDisplayAPI(IComputerSystem computer, IPocketAccess pocket) {
        this.computer = computer;
        this.pocket = pocket;
    }

    public final Level getLevel() {
        return this.computer.getLevel();
    }

    public final ServerPlayer getPlayer() {
        Entity entity = this.pocket.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        return null;
    }

    public final Boolean isPlayerAlive() {
        return this.getPlayer() != null;
    }

    public final UUID getOwnerUUID() {
        if (this.getPlayer() != null) {
            return this.getPlayer().m_20148_();
        }
        return null;
    }

    public String[] getNames() {
        return new String[]{"hmd"};
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> getInfo() {
        if (!this.isPlayerAlive().booleanValue()) {
            return null;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            info.put("name", plr.m_36316_().getName());
            info.put("dimension", plr.m_9236_().m_46472_().m_135782_().toString());
            info.put("health", Float.valueOf(plr.m_21223_()));
            info.put("hunger", plr.m_36324_().m_38702_());
            info.put("saturation", Float.valueOf(plr.m_36324_().m_38722_()));
            info.put("air", plr.m_20146_());
            info.put("armor", plr.m_21230_());
            info.put("speed", Float.valueOf(plr.m_6113_()));
            info.put("yaw", Float.valueOf(plr.m_5675_(1.0f)));
            info.put("pitch", Float.valueOf(plr.m_5686_(1.0f)));
            info.put("isInPowderedSnow", plr.f_146808_);
            info.put("isInWater", plr.m_20069_());
            info.put("isHungry", plr.m_36324_().m_38721_());
        }
        return info;
    }

    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastBlock(double inputReach, boolean hitFluids) {
        if (!this.isPlayerAlive().booleanValue()) {
            return null;
        }
        double reach = Math.min(5.0, Math.max(1.0, inputReach));
        ClipContext.Fluid pFluidMode = ClipContext.Fluid.ANY;
        ServerPlayer plr = this.getPlayer();
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (plr != null) {
            Level lvl = plr.m_9236_();
            HitResult hitResult = plr.m_19907_(5.0, 0.0f, hitFluids);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHit = (BlockHitResult)hitResult;
                BlockPos pos = blockHit.m_82425_();
                String name = String.valueOf(lvl.m_8055_(pos).m_60734_().m_49954_().toString());
                Block blk = lvl.m_8055_(pos).m_60734_();
                info.put("id", BuiltInRegistries.f_256975_.m_7981_((Object)blk).toString());
                info.put("name", new ItemStack((ItemLike)blk).m_41611_().getString());
                info.put("x", pos.m_123341_());
                info.put("y", pos.m_123342_());
                info.put("z", pos.m_123343_());
            }
        }
        return info;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public final Map<String, Object> raycastEntity(double inputReach) {
        if (!this.isPlayerAlive().booleanValue()) {
            return null;
        }
        double reach = Math.min(5.0, Math.max(1.0, inputReach));
        HashMap<String, Object> info = new HashMap<String, Object>();
        ServerPlayer plr = this.getPlayer();
        if (plr != null) {
            Optional<Entity> hitEntity = HeadMountDisplayAPI.raycastEntity((Player)plr, reach);
            if (hitEntity.isPresent()) {
                Entity entity = hitEntity.get();
                info.put("id", BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString());
                info.put("uuid", entity.m_20148_().toString());
                info.put("dimension", entity.m_9236_().m_46472_().m_135782_().toString());
                info.put("x", Math.floor(entity.m_20185_()));
                info.put("y", Math.floor(entity.m_20186_()));
                info.put("z", Math.floor(entity.m_20189_()));
                info.put("yaw", Float.valueOf(entity.m_5675_(1.0f)));
                info.put("pitch", Float.valueOf(entity.m_5686_(1.0f)));
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    info.put("health", Float.valueOf(livingEntity.m_21223_()));
                    info.put("maxHealth", Float.valueOf(livingEntity.m_21233_()));
                    info.put("air", livingEntity.m_20146_());
                    info.put("maxAir", livingEntity.m_6062_());
                    info.put("armor", livingEntity.m_21230_());
                    info.put("speed", Float.valueOf(livingEntity.m_6113_()));
                    info.put("isInPowderedSnow", livingEntity.f_146808_);
                    if (livingEntity instanceof Player) {
                        Player hitPlayer = (Player)livingEntity;
                        info.put("hunger", hitPlayer.m_36324_().m_38702_());
                        info.put("saturation", Float.valueOf(hitPlayer.m_36324_().m_38722_()));
                        info.put("isHungry", hitPlayer.m_36324_().m_38721_());
                        info.put("creative", hitPlayer.m_7500_());
                        info.put("spectator", hitPlayer.m_5833_());
                    }
                }
                if (entity instanceof Player) {
                    Player hitPlayer = (Player)entity;
                    info.put("name", hitPlayer.m_36316_().getName().toString());
                } else {
                    info.put("name", entity.m_5446_().getString());
                }
                return info;
            }
            return info;
        }
        return info;
    }

    public static Optional<Entity> raycastEntity(Player player, double distance) {
        Vec3 lookVec;
        Vec3 endVec;
        Vec3 startVec;
        Level world = player.m_9236_();
        BlockHitResult blockHitResult = world.m_45547_(new ClipContext(startVec = player.m_146892_(), endVec = startVec.m_82549_(lookVec = player.m_20252_(1.0f).m_82490_(distance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockHitDistance = blockHitResult.m_82450_().m_82554_(startVec);
        if (blockHitDistance < distance) {
            endVec = blockHitResult.m_82450_();
        }
        AABB boundingBox = new AABB(startVec, endVec).m_82400_(1.0);
        Entity closestEntity = null;
        double closestDistance = distance;
        for (Entity entity : world.m_45933_((Entity)player, boundingBox)) {
            double entityDistance;
            AABB entityBoundingBox;
            Optional intersection;
            if (entity == player || !entity.m_6087_() || !(intersection = (entityBoundingBox = entity.m_20191_().m_82400_(0.3)).m_82371_(startVec, endVec)).isPresent() || !((entityDistance = startVec.m_82554_((Vec3)intersection.get())) < closestDistance)) continue;
            closestEntity = entity;
            closestDistance = entityDistance;
        }
        return Optional.ofNullable(closestEntity);
    }
}

