/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_pocket.api;

import com.awesoft.ccx_pocket.item.PocketPack.PocketPackInventory;
import com.awesoft.ccx_pocket.item.PocketPack.PocketPackItem;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.pocket.IPocketAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PocketPackAPI
implements ILuaAPI {
    private final IComputerSystem computer;
    private final IPocketAccess pocket;

    public PocketPackAPI(IComputerSystem computer, IPocketAccess pocket) {
        this.computer = computer;
        this.pocket = pocket;
    }

    public final Level getLevel() {
        return this.computer.getLevel();
    }

    public final ServerPlayer getPlayer() {
        Entity entity = this.pocket.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        return null;
    }

    public final Boolean isPlayerAlive() {
        return this.getPlayer() != null;
    }

    public final UUID getOwnerUUID() {
        if (this.getPlayer() != null) {
            return this.getPlayer().m_20148_();
        }
        return null;
    }

    public final ItemStack getPocketItem() {
        if (!this.isPlayerAlive().booleanValue()) {
            return null;
        }
        ItemStack main = this.getPlayer().m_21205_();
        ItemStack off = this.getPlayer().m_21206_();
        ItemStack chest = this.getPlayer().m_6844_(EquipmentSlot.CHEST);
        if (!main.m_41619_() && main.m_41720_() instanceof PocketPackItem) {
            return main;
        }
        if (!off.m_41619_() && off.m_41720_() instanceof PocketPackItem) {
            return off;
        }
        if (!chest.m_41619_() && chest.m_41720_() instanceof PocketPackItem) {
            return chest;
        }
        return null;
    }

    public String[] getNames() {
        return new String[]{"pack"};
    }

    public MethodResult moveItemTo(Container from, Container to, int fromSlot, int limit, int toSlot) {
        ItemStack fromItem = from.m_8020_(Math.max(0, fromSlot - 1));
        ItemStack toItem = to.m_8020_(Math.max(0, toSlot - 1));
        if (fromItem.m_41619_()) {
            return MethodResult.of((Object[])new Object[]{false, "From slot is empty!"});
        }
        if (toItem.m_41619_()) {
            if (fromItem.m_41613_() < limit) {
                return MethodResult.of((Object[])new Object[]{false, "From slot has too few items!"});
            }
            ItemStack moved = fromItem.m_41777_();
            moved.m_41764_(limit);
            fromItem.m_41774_(limit);
            from.m_6836_(Math.max(0, fromSlot - 1), fromItem);
            to.m_6836_(Math.max(0, toSlot - 1), moved);
            return MethodResult.of((Object[])new Object[]{true, limit});
        }
        if (toItem.m_41720_() != fromItem.m_41720_()) {
            return MethodResult.of((Object[])new Object[]{false, "To slot doesn't contain the same item!"});
        }
        if (!Objects.equals(toItem.m_41783_(), fromItem.m_41783_())) {
            return MethodResult.of((Object[])new Object[]{false, "Both items' NBT do not match."});
        }
        int transferable = Math.min(limit, fromItem.m_41613_());
        int space = toItem.m_41741_() - toItem.m_41613_();
        int movedAmount = Math.min(transferable, space);
        fromItem.m_41774_(movedAmount);
        toItem.m_41769_(movedAmount);
        from.m_6836_(Math.max(0, fromSlot - 1), fromItem);
        to.m_6836_(Math.max(0, toSlot - 1), toItem);
        return MethodResult.of((Object[])new Object[]{true, movedAmount});
    }

    public final Inventory getInventory() {
        if (!this.isPlayerAlive().booleanValue()) {
            return null;
        }
        return this.getPlayer().m_150109_();
    }

    public final SimpleContainer getPack() {
        ItemStack item = this.getPocketItem();
        Item item2 = item.m_41720_();
        if (item2 instanceof PocketPackItem) {
            PocketPackItem pack = (PocketPackItem)item2;
            return pack.getInventory(item);
        }
        return null;
    }

    @LuaFunction(mainThread=true)
    public final MethodResult list(String invString) {
        Inventory inv = this.getInventory();
        SimpleContainer pack = this.getPack();
        if (inv == null || pack == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (invString.equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (invString.equalsIgnoreCase("pack")) {
            contain1 = pack;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"pack\"!"});
        }
        HashMap<Integer, Map> result = new HashMap<Integer, Map>();
        int size = contain1.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = contain1.m_8020_(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        if (contain1 instanceof PocketPackInventory) {
            PocketPackInventory packInv = (PocketPackInventory)contain1;
            Item item = this.getPocketItem().m_41720_();
            if (item instanceof PocketPackItem) {
                PocketPackItem item2 = (PocketPackItem)item;
                item2.saveInventory(this.getPocketItem(), packInv);
            }
        }
        return MethodResult.of(result);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult moveItems(String fromInv, String toInv, int fromSlot, int limit, int toSlot) {
        Inventory inv = this.getInventory();
        SimpleContainer pack = this.getPack();
        if (inv == null || pack == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        Inventory contain2 = null;
        if (fromInv.equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (toInv.equalsIgnoreCase("inv")) {
            contain2 = inv;
        }
        if (fromInv.equalsIgnoreCase("pack")) {
            contain1 = pack;
        }
        if (toInv.equalsIgnoreCase("pack")) {
            contain2 = pack;
        }
        if (contain1 == null || contain2 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventories! Please use \"inv\" or \"pack\"!"});
        }
        if (contain1.m_8020_(fromSlot - 1).m_41720_() instanceof PocketPackItem) {
            return MethodResult.of((Object[])new Object[]{false, "Cannot put Pocket Pack into another Pocket Pack!"});
        }
        MethodResult result = this.moveItemTo((Container)contain1, (Container)contain2, fromSlot, limit, toSlot);
        if (contain1 instanceof PocketPackInventory) {
            PocketPackInventory packInv = (PocketPackInventory)contain1;
            Item item = this.getPocketItem().m_41720_();
            if (item instanceof PocketPackItem) {
                PocketPackItem item2 = (PocketPackItem)item;
                item2.saveInventory(this.getPocketItem(), packInv);
            }
        } else if (contain2 instanceof PocketPackInventory) {
            PocketPackInventory packInv = (PocketPackInventory)contain2;
            Item item = this.getPocketItem().m_41720_();
            if (item instanceof PocketPackItem) {
                PocketPackItem item3 = (PocketPackItem)item;
                item3.saveInventory(this.getPocketItem(), packInv);
            }
        }
        return MethodResult.of((Object)result);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItemDetail(int slotNumFake, String targetInv) {
        Inventory inv = this.getInventory();
        SimpleContainer pack = this.getPack();
        if (inv == null || pack == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (targetInv.equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (targetInv.equalsIgnoreCase("pack")) {
            contain1 = pack;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"pack\"!"});
        }
        int slotNum = Math.max(0, Math.min(contain1.m_6643_(), slotNumFake - 1));
        return MethodResult.of((Object)VanillaDetailRegistries.ITEM_STACK.getBasicDetails((Object)contain1.m_8020_(slotNum)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItemLimit(int slotNumFake, String targetInv) {
        Inventory inv = this.getInventory();
        SimpleContainer pack = this.getPack();
        if (inv == null || pack == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (targetInv.equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (targetInv.equalsIgnoreCase("pack")) {
            contain1 = pack;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"pack\"!"});
        }
        int slotNum = Math.max(0, Math.min(contain1.m_6643_(), slotNumFake - 1));
        return MethodResult.of((Object)contain1.m_8020_(slotNum).m_41741_());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult size(String targetInv) {
        Inventory inv = this.getInventory();
        SimpleContainer pack = this.getPack();
        if (inv == null || pack == null) {
            return MethodResult.of((Object[])new Object[]{false, "Player doesnt exist!"});
        }
        Inventory contain1 = null;
        if (targetInv.equalsIgnoreCase("inv")) {
            contain1 = inv;
        }
        if (targetInv.equalsIgnoreCase("pack")) {
            contain1 = pack;
        }
        if (contain1 == null) {
            return MethodResult.of((Object[])new Object[]{false, "Invalid Inventory type! Please use \"inv\" or \"pack\"!"});
        }
        return MethodResult.of((Object)contain1.m_6643_());
    }
}

