/*
 * Decompiled with CFR 0.152.
 */
package com.awesoft.ccx_pocket.item.hmd;

import com.awesoft.ccx_pocket.item.hmd.HMDPocketItem;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HMDHolder {
    public ServerLevel level();

    public Vec3 pos();

    public BlockPos blockPos();

    public boolean isValid(ServerComputer var1);

    public void setChanged();

    default public boolean isTerminalAlwaysVisible() {
        return false;
    }

    public record LecternHolder(CustomLecternBlockEntity lectern) implements HMDHolder
    {
        @Override
        public ServerLevel level() {
            return (ServerLevel)this.lectern.m_58904_();
        }

        @Override
        public Vec3 pos() {
            return Vec3.m_82512_((Vec3i)this.lectern.m_58899_());
        }

        @Override
        public BlockPos blockPos() {
            return this.lectern.m_58899_();
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return !this.lectern().m_58901_() && HMDPocketItem.isServerComputer(computer, this.lectern.getItem());
        }

        @Override
        public void setChanged() {
            BlockEntityHelpers.updateBlock((BlockEntity)this.lectern());
        }

        @Override
        public boolean isTerminalAlwaysVisible() {
            return true;
        }
    }

    public static final class ItemEntityHolder
    extends Record
    implements EntityHolder {
        private final ItemEntity entity;

        public ItemEntityHolder(ItemEntity entity) {
            this.entity = entity;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_() && HMDPocketItem.isServerComputer(computer, this.entity().m_32055_());
        }

        @Override
        public void setChanged() {
            this.entity.m_32045_(this.entity.m_32055_().m_41777_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemEntityHolder.class, "entity", "entity"}, this, o);
        }

        public ItemEntity entity() {
            return this.entity;
        }
    }

    public static final class HelmetHolder
    extends Record
    implements EntityHolder {
        private final ServerPlayer entity;

        public HelmetHolder(ServerPlayer entity) {
            this.entity = entity;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_() && HMDPocketItem.isServerComputer(computer, this.entity().m_6844_(EquipmentSlot.HEAD));
        }

        @Override
        public void setChanged() {
            this.entity.m_150109_().m_6596_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HelmetHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HelmetHolder.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HelmetHolder.class, "entity", "entity"}, this, o);
        }

        public ServerPlayer entity() {
            return this.entity;
        }
    }

    public static final class PlayerHolder
    extends Record
    implements EntityHolder {
        private final ServerPlayer entity;
        private final int slot;

        public PlayerHolder(ServerPlayer entity, int slot) {
            this.entity = entity;
            this.slot = slot;
        }

        @Override
        public boolean isValid(ServerComputer computer) {
            return this.entity().m_6084_() && HMDPocketItem.isServerComputer(computer, this.entity().m_150109_().m_8020_(this.slot()));
        }

        @Override
        public void setChanged() {
            this.entity.m_150109_().m_6596_();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerHolder.class, "entity;slot", "entity", "slot"}, this, o);
        }

        public ServerPlayer entity() {
            return this.entity;
        }

        public int slot() {
            return this.slot;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface EntityHolder
    extends HMDHolder {
        public Entity entity();

        @Override
        default public ServerLevel level() {
            return (ServerLevel)this.entity().m_9236_();
        }

        @Override
        default public Vec3 pos() {
            return this.entity().m_146892_();
        }

        @Override
        default public BlockPos blockPos() {
            return this.entity().m_20183_();
        }
    }
}

