/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.audio;

import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.network.PiperClient;
import java.io.ByteArrayInputStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;

public class AudioPlayer {
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static volatile Future<?> currentTask;
    private static volatile SourceDataLine audioLine;

    public static synchronized void speakAsync(String text) {
        if (executor.isShutdown()) {
            NarratorConfig.log("[PiperTTS] The thread pool was closed, creating a new one.");
            executor = Executors.newSingleThreadExecutor();
        }
        if (currentTask != null && !currentTask.isDone()) {
            currentTask.cancel(true);
        }
        if (audioLine != null) {
            audioLine.stop();
            audioLine.close();
            audioLine = null;
        }
        currentTask = executor.submit(() -> {
            try {
                NarratorConfig.log("[PiperTTS] Text synthesis: " + text);
                byte[] audioBytes = PiperClient.synthesizeAudio(text);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (audioBytes != null && audioBytes.length > 0) {
                    AudioPlayer.playWAV(audioBytes);
                }
            }
            catch (CancellationException audioBytes) {
            }
            catch (Exception ex) {
                if (!(ex instanceof InterruptedException) && !(ex instanceof ClosedByInterruptException)) {
                    NarratorConfig.logError("[PiperTTS] Error in synthesis thread: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            finally {
                if (audioLine != null) {
                    audioLine.close();
                    audioLine = null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void playWAV(byte[] audioBytes) {
        if (audioBytes == null || audioBytes.length == 0) {
            return;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(audioBytes);
             AudioInputStream ais = AudioSystem.getAudioInputStream(bais);){
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, ais.getFormat());
            if (!AudioSystem.isLineSupported(info)) {
                NarratorConfig.logError("[PiperTTS] Audio format not supported: " + ais.getFormat());
                return;
            }
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            Class<AudioPlayer> clazz = AudioPlayer.class;
            synchronized (AudioPlayer.class) {
                int bytesRead;
                audioLine = line;
                // ** MonitorExit[var7_17] (shouldn't be in output)
                line.open(ais.getFormat());
                float mcVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
                if (mcVolume < 0.0f) {
                    mcVolume = 0.0f;
                }
                if (mcVolume > 1.0f) {
                    mcVolume = 1.0f;
                }
                if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    float minGain = gainControl.getMinimum();
                    float maxGain = gainControl.getMaximum();
                    float dB = mcVolume == 0.0f ? minGain : (float)(Math.log10(mcVolume) * 20.0);
                    if (dB < minGain) {
                        dB = minGain;
                    }
                    if (dB > maxGain) {
                        dB = maxGain;
                    }
                    gainControl.setValue(dB);
                }
                line.start();
                byte[] buffer = new byte[4096];
                while ((bytesRead = ais.read(buffer)) != -1 && !Thread.currentThread().isInterrupted()) {
                    line.write(buffer, 0, bytesRead);
                }
                line.drain();
                line.close();
            }
        }
        catch (Exception e) {
            if (!(e instanceof ClosedByInterruptException)) {
                NarratorConfig.logError("[PiperTTS] Audio playback error: " + e.getMessage());
                e.printStackTrace();
            }
        }
        finally {
            Class<AudioPlayer> clazz = AudioPlayer.class;
            synchronized (AudioPlayer.class) {
                if (audioLine != null && !audioLine.isOpen()) {
                    audioLine = null;
                }
                // ** MonitorExit[var1_3] (shouldn't be in output)
            }
        }
        {
            return;
        }
    }

    public static synchronized void stop() {
        if (currentTask != null && !currentTask.isDone()) {
            currentTask.cancel(true);
        }
        if (audioLine != null) {
            audioLine.stop();
            audioLine.close();
            audioLine = null;
        }
    }

    public static void shutdown() {
        executor.shutdown();
    }
}

