/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.command;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.event.NarratorEventHandler;
import com.gedeongrays.narrator.network.PiperClient;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import org.apache.commons.io.FileUtils;

public class NarratorCommand
extends CommandBase {
    public String func_71517_b() {
        return "narrator";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/narrator <status|test|cache>";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            String message = I18n.func_135052_a((String)"narrator.command.usage", (Object[])new Object[0]);
            NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "status": {
                boolean foundJson;
                String currentLang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
                File langVoicesDir = new File(PiperClient.getBaseDir(), "voices/" + currentLang);
                File[] onnxFiles = langVoicesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".onnx"));
                File[] jsonFiles = langVoicesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".onnx.json"));
                boolean foundOnnx = onnxFiles != null && onnxFiles.length > 0;
                boolean bl = foundJson = jsonFiles != null && jsonFiles.length > 0;
                if (!foundOnnx && !foundJson) {
                    String message = I18n.func_135052_a((String)"narrator.command.status.missing_both", (Object[])new Object[]{currentLang});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                    break;
                }
                if (!foundOnnx) {
                    String baseName = jsonFiles[0].getName().replace(".onnx.json", "");
                    String missingFile = baseName + ".onnx";
                    String message = I18n.func_135052_a((String)"narrator.command.status.missing_one", (Object[])new Object[]{currentLang, missingFile});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7e", message);
                    break;
                }
                if (!foundJson) {
                    String baseName = onnxFiles[0].getName().replace(".onnx", "");
                    String missingFile = baseName + ".onnx.json";
                    String message = I18n.func_135052_a((String)"narrator.command.status.missing_one", (Object[])new Object[]{currentLang, missingFile});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7e", message);
                    break;
                }
                String onnxFileName = onnxFiles[0].getName();
                String jsonFileName = jsonFiles[0].getName();
                String message = I18n.func_135052_a((String)"narrator.command.status.found_both", (Object[])new Object[]{currentLang, onnxFileName, jsonFileName});
                NarratorEventHandler.printWrappedColoredMessage("\u00a7a", message);
                break;
            }
            case "test": {
                if (args.length < 2) {
                    String message = I18n.func_135052_a((String)"narrator.command.test.usage", (Object[])new Object[0]);
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                    return;
                }
                String textToNarrate = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                AudioPlayer.speakAsync(textToNarrate);
                break;
            }
            case "cache": {
                File cacheDir = PiperClient.getCacheDir();
                if (args.length == 1) {
                    String message = I18n.func_135052_a((String)"narrator.command.cache.usage", (Object[])new Object[0]);
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                    return;
                }
                String cacheSubCommand = args[1].toLowerCase();
                if (cacheSubCommand.equals("info")) {
                    if (cacheDir == null || !cacheDir.exists() || !cacheDir.isDirectory()) {
                        String message = I18n.func_135052_a((String)"narrator.command.cache.error", (Object[])new Object[0]);
                        NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                        return;
                    }
                    File[] cacheFiles = cacheDir.listFiles();
                    int fileCount = cacheFiles != null ? cacheFiles.length : 0;
                    long totalSize = FileUtils.sizeOfDirectory((File)cacheDir);
                    String string = NarratorCommand.getString(totalSize);
                    String message = I18n.func_135052_a((String)"narrator.command.cache.info", (Object[])new Object[]{fileCount, string});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7a", message);
                    break;
                }
                if (cacheSubCommand.equals("clear")) {
                    if (cacheDir == null || !cacheDir.exists() || !cacheDir.isDirectory()) {
                        String message = I18n.func_135052_a((String)"narrator.command.cache.error", (Object[])new Object[0]);
                        NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                        return;
                    }
                    File[] cacheFiles = cacheDir.listFiles();
                    if (cacheFiles == null || cacheFiles.length == 0) {
                        String message = I18n.func_135052_a((String)"narrator.command.cache.empty", (Object[])new Object[0]);
                        NarratorEventHandler.printWrappedColoredMessage("\u00a7a", message);
                        return;
                    }
                    int filesDeleted = 0;
                    long bytesDeleted = 0L;
                    for (File file : cacheFiles) {
                        long fileSize = file.length();
                        if (!file.isFile() || !file.delete()) continue;
                        ++filesDeleted;
                        bytesDeleted += fileSize;
                    }
                    String string = NarratorCommand.getString(bytesDeleted);
                    String message = I18n.func_135052_a((String)"narrator.command.cache.success", (Object[])new Object[]{filesDeleted, string});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7a", message);
                    break;
                }
                String message = I18n.func_135052_a((String)"narrator.command.cache.usage", (Object[])new Object[0]);
                NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                break;
            }
            default: {
                String message = I18n.func_135052_a((String)"narrator.command.usage", (Object[])new Object[0]);
                NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
            }
        }
    }

    private static String getString(long totalSize) {
        String sizeString = totalSize < 1024L ? String.format("%s B", totalSize) : (totalSize < 0x100000L ? String.format("%.2f KB", (double)totalSize / 1024.0) : (totalSize < 0x40000000L ? String.format("%.2f MB", (double)totalSize / 1048576.0) : String.format("%.2f GB", (double)totalSize / 1.073741824E9)));
        return sizeString;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"status", "test", "cache"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("cache")) {
                return CommandBase.func_71530_a((String[])args, (String[])new String[]{"info", "clear"});
            }
            if (args[0].equalsIgnoreCase("test")) {
                return Arrays.asList("Supercalifragilisticexpialidocious");
            }
        }
        return null;
    }
}

