/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class NarratorConfig {
    public static Configuration config;
    public static final String CATEGORY_LISTENERS_ENABLED = "listeners_enabled";
    public static final String CATEGORY_LISTENERS_HOVER_DELAY = "listeners_hover_delay";
    public static final String CATEGORY_GENERAL = "general";
    public static int cacheMaxSizeMB;
    public static int defaultHoverDelay;
    public static boolean defaultListenersEnabled;
    public static boolean enableCaching;
    public static boolean enableJoinMessages;
    public static boolean enableLogging;
    public static int achievementNarratorHoverDelay;
    public static int blockNarratorHoverDelay;
    public static int bookNarratorHoverDelay;
    public static int buttonNarratorHoverDelay;
    public static int chatNarratorHoverDelay;
    public static int configNarratorHoverDelay;
    public static int controlsNarratorHoverDelay;
    public static int creativeTabNarratorHoverDelay;
    public static int deathScreenNarratorHoverDelay;
    public static int debugScreenNarratorHoverDelay;
    public static int flatWorldNarratorHoverDelay;
    public static int hotbarNarratorHoverDelay;
    public static int hudNarratorHoverDelay;
    public static int ingameMenuNarratorHoverDelay;
    public static int ingameModListNarratorHoverDelay;
    public static int inventoryNarratorHoverDelay;
    public static int itemNarratorHoverDelay;
    public static int languageNarratorHoverDelay;
    public static int lanNarratorHoverDelay;
    public static int mainMenuNarratorHoverDelay;
    public static int messageScreenNarratorHoverDelay;
    public static int mobNarratorHoverDelay;
    public static int modListNarratorHoverDelay;
    public static int multiplayerNarratorHoverDelay;
    public static int optionsNarratorHoverDelay;
    public static int presetNarratorHoverDelay;
    public static int realmsNarratorHoverDelay;
    public static int resourcePackNarratorHoverDelay;
    public static int statsNarratorHoverDelay;
    public static int worldNarratorHoverDelay;
    public static boolean enableAchievementListener;
    public static boolean enableBlockListener;
    public static boolean enableBookListener;
    public static boolean enableButtonListener;
    public static boolean enableChatListener;
    public static boolean enableConfigListener;
    public static boolean enableControlsListener;
    public static boolean enableCreativeTabListener;
    public static boolean enableDeathScreenListener;
    public static boolean enableDebugScreenListener;
    public static boolean enableDismountListener;
    public static boolean enableEndPoemListener;
    public static boolean enableFlatWorldListener;
    public static boolean enableHotbarListener;
    public static boolean enableHudListener;
    public static boolean enableIngameMenuListener;
    public static boolean enableIngameModListListener;
    public static boolean enableInventoryListener;
    public static boolean enableItemListener;
    public static boolean enableJukeboxListener;
    public static boolean enableLanguageListener;
    public static boolean enableLanListener;
    public static boolean enableMainMenuListener;
    public static boolean enableMessageScreenListener;
    public static boolean enableMobListener;
    public static boolean enableModListListener;
    public static boolean enableMultiplayerListener;
    public static boolean enableOptionsListener;
    public static boolean enablePresetListener;
    public static boolean enableRealmsListener;
    public static boolean enableResourcePackListener;
    public static boolean enableStatsListener;
    public static boolean enableWorldListener;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            NarratorConfig.loadConfig();
        }
        FMLCommonHandler.instance().bus().register((Object)new NarratorConfig());
    }

    private static void loadConfig() {
        config.load();
        config.setCategoryComment(CATEGORY_GENERAL, "General settings for the Narrator mod.");
        Property cacheMaxSizeMBProp = config.get(CATEGORY_GENERAL, "cacheMaxSizeMB", 1000, "The maximum cache size in megabytes. Once this value is reached, the cache folder is automatically\ncleared. A value of 0 disables automatic clearing. The default value is 1000.");
        cacheMaxSizeMB = cacheMaxSizeMBProp.getInt(0);
        Property defaultHoverDelayProp = config.get(CATEGORY_GENERAL, "defaultHoverDelay", 500, "Delay in milliseconds when hovering over objects in all listeners. A value of 0 disables the delay\ncompletely. The default value is 500.");
        defaultHoverDelay = defaultHoverDelayProp.getInt(500);
        Property defaultListenersEnabledProp = config.get(CATEGORY_GENERAL, "defaultListenersEnabled", true, "Enable/disable all listeners. The default value is true.");
        defaultListenersEnabled = defaultListenersEnabledProp.getBoolean(true);
        Property enableCachingProp = config.get(CATEGORY_GENERAL, "enableCaching", true, "Enable/disable caching. Caching significantly reduces CPU usage. Warning! Cache files can\ntake up a significant amount of disk space over time. You can safely control this using\nthe cacheMaxSizeMB parameter. The default value is true.");
        enableCaching = enableCachingProp.getBoolean(true);
        Property enableJoinMessagesProp = config.get(CATEGORY_GENERAL, "enableJoinMessages", true, "Enable/disable voice model status messages when joining a world. The default value is true.");
        enableJoinMessages = enableJoinMessagesProp.getBoolean(true);
        Property enableLoggingProp = config.get(CATEGORY_GENERAL, "enableLogging", false, "Enable/disable logging in the console/log file. The default value is false.");
        enableLogging = enableLoggingProp.getBoolean(true);
        config.setCategoryComment(CATEGORY_LISTENERS_ENABLED, "Enable/disable a specific listener. The default value is taken from defaultListenersEnabled.");
        enableAchievementListener = NarratorConfig.getListenerEnabled("enableAchievementListener");
        enableBlockListener = NarratorConfig.getListenerEnabled("enableBlockListener");
        enableBookListener = NarratorConfig.getListenerEnabled("enableBookListener");
        enableButtonListener = NarratorConfig.getListenerEnabled("enableButtonListener");
        enableChatListener = NarratorConfig.getListenerEnabled("enableChatListener");
        enableConfigListener = NarratorConfig.getListenerEnabled("enableConfigListener");
        enableControlsListener = NarratorConfig.getListenerEnabled("enableControlsListener");
        enableCreativeTabListener = NarratorConfig.getListenerEnabled("enableCreativeTabListener");
        enableDeathScreenListener = NarratorConfig.getListenerEnabled("enableDeathScreenListener");
        enableDebugScreenListener = NarratorConfig.getListenerEnabled("enableDebugScreenListener");
        enableDismountListener = NarratorConfig.getListenerEnabled("enableDismountListener");
        enableEndPoemListener = NarratorConfig.getListenerEnabled("enableEndPoemListener");
        enableFlatWorldListener = NarratorConfig.getListenerEnabled("enableFlatWorldListener");
        enableHotbarListener = NarratorConfig.getListenerEnabled("enableHotbarListener");
        enableHudListener = NarratorConfig.getListenerEnabled("enableHudListener");
        enableIngameMenuListener = NarratorConfig.getListenerEnabled("enableIngameMenuListener");
        enableIngameModListListener = NarratorConfig.getListenerEnabled("enableIngameModListListener");
        enableInventoryListener = NarratorConfig.getListenerEnabled("enableInventoryListener");
        enableItemListener = NarratorConfig.getListenerEnabled("enableItemListener");
        enableJukeboxListener = NarratorConfig.getListenerEnabled("enableJukeboxListener");
        enableLanguageListener = NarratorConfig.getListenerEnabled("enableLanguageListener");
        enableLanListener = NarratorConfig.getListenerEnabled("enableLanListener");
        enableMainMenuListener = NarratorConfig.getListenerEnabled("enableMainMenuListener");
        enableMessageScreenListener = NarratorConfig.getListenerEnabled("enableMessageScreenListener");
        enableMobListener = NarratorConfig.getListenerEnabled("enableMobListener");
        enableModListListener = NarratorConfig.getListenerEnabled("enableModListListener");
        enableMultiplayerListener = NarratorConfig.getListenerEnabled("enableMultiplayerListener");
        enableOptionsListener = NarratorConfig.getListenerEnabled("enableOptionsListener");
        enablePresetListener = NarratorConfig.getListenerEnabled("enablePresetListener");
        enableRealmsListener = NarratorConfig.getListenerEnabled("enableRealmsListener");
        enableResourcePackListener = NarratorConfig.getListenerEnabled("enableResourcePackListener");
        enableStatsListener = NarratorConfig.getListenerEnabled("enableStatsListener");
        enableWorldListener = NarratorConfig.getListenerEnabled("enableWorldListener");
        config.setCategoryComment(CATEGORY_LISTENERS_HOVER_DELAY, "Delay in milliseconds when hovering over objects in a specific listener. A value of 0 disables the\ndelay completely. The default value is taken from defaultHoverDelay.");
        achievementNarratorHoverDelay = NarratorConfig.getListenerDelay("achievementNarratorHoverDelay");
        blockNarratorHoverDelay = NarratorConfig.getListenerDelay("blockNarratorHoverDelay");
        bookNarratorHoverDelay = NarratorConfig.getListenerDelay("bookNarratorHoverDelay");
        buttonNarratorHoverDelay = NarratorConfig.getListenerDelay("buttonNarratorHoverDelay");
        chatNarratorHoverDelay = NarratorConfig.getListenerDelay("chatNarratorHoverDelay");
        configNarratorHoverDelay = NarratorConfig.getListenerDelay("configNarratorHoverDelay");
        controlsNarratorHoverDelay = NarratorConfig.getListenerDelay("controlsNarratorHoverDelay");
        creativeTabNarratorHoverDelay = NarratorConfig.getListenerDelay("creativeTabNarratorHoverDelay");
        deathScreenNarratorHoverDelay = NarratorConfig.getListenerDelay("deathScreenNarratorHoverDelay");
        debugScreenNarratorHoverDelay = NarratorConfig.getListenerDelay("debugScreenNarratorHoverDelay");
        flatWorldNarratorHoverDelay = NarratorConfig.getListenerDelay("flatWorldNarratorHoverDelay");
        hotbarNarratorHoverDelay = NarratorConfig.getListenerDelay("hotbarNarratorHoverDelay");
        hudNarratorHoverDelay = NarratorConfig.getListenerDelay("hudNarratorHoverDelay");
        ingameMenuNarratorHoverDelay = NarratorConfig.getListenerDelay("ingameMenuNarratorHoverDelay");
        ingameModListNarratorHoverDelay = NarratorConfig.getListenerDelay("ingameModListNarratorHoverDelay");
        inventoryNarratorHoverDelay = NarratorConfig.getListenerDelay("inventoryNarratorHoverDelay");
        itemNarratorHoverDelay = NarratorConfig.getListenerDelay("itemNarratorHoverDelay");
        languageNarratorHoverDelay = NarratorConfig.getListenerDelay("languageNarratorHoverDelay");
        lanNarratorHoverDelay = NarratorConfig.getListenerDelay("lanNarratorHoverDelay");
        mainMenuNarratorHoverDelay = NarratorConfig.getListenerDelay("mainMenuNarratorHoverDelay");
        messageScreenNarratorHoverDelay = NarratorConfig.getListenerDelay("messageScreenNarratorHoverDelay");
        mobNarratorHoverDelay = NarratorConfig.getListenerDelay("mobNarratorHoverDelay");
        modListNarratorHoverDelay = NarratorConfig.getListenerDelay("modListNarratorHoverDelay");
        multiplayerNarratorHoverDelay = NarratorConfig.getListenerDelay("multiplayerNarratorHoverDelay");
        optionsNarratorHoverDelay = NarratorConfig.getListenerDelay("optionsNarratorHoverDelay");
        presetNarratorHoverDelay = NarratorConfig.getListenerDelay("presetNarratorHoverDelay");
        realmsNarratorHoverDelay = NarratorConfig.getListenerDelay("realmsNarratorHoverDelay");
        resourcePackNarratorHoverDelay = NarratorConfig.getListenerDelay("resourcePackNarratorHoverDelay");
        statsNarratorHoverDelay = NarratorConfig.getListenerDelay("statsNarratorHoverDelay");
        worldNarratorHoverDelay = NarratorConfig.getListenerDelay("worldNarratorHoverDelay");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void log(String message) {
        if (enableLogging) {
            System.out.println(message);
        }
    }

    public static void logf(String format, Object ... args) {
        if (enableLogging) {
            System.out.printf(format, args);
        }
    }

    public static void logError(String message) {
        if (enableLogging) {
            System.err.println(message);
        }
    }

    public static void logErrorf(String format, Object ... args) {
        if (enableLogging) {
            System.err.printf(format, args);
        }
    }

    private static int getListenerDelay(String propName) {
        Property prop = config.get(CATEGORY_LISTENERS_HOVER_DELAY, propName, "");
        String value = prop.getString().trim();
        if (value.isEmpty()) {
            return defaultHoverDelay;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            NarratorConfig.logErrorf("[Narrator] Invalid value for property '%s'. Using default general delay.\n", propName);
            return defaultHoverDelay;
        }
    }

    private static boolean getListenerEnabled(String propName) {
        Property prop = config.get(CATEGORY_LISTENERS_ENABLED, propName, "");
        String value = prop.getString().trim().toLowerCase();
        if (value.isEmpty()) {
            return defaultListenersEnabled;
        }
        return value.equals("true");
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("narrator")) {
            NarratorConfig.log("[Narrator] Reloading config.");
            NarratorConfig.loadConfig();
        }
    }
}

