/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.event;

import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.network.PiperClient;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.io.File;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class NarratorEventHandler {
    private static String lastCheckedLanguage = null;
    private static boolean infoMessageShownForLang = false;

    @SubscribeEvent
    public void onClientPlayerLogin(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        String currentLang = mc.field_71474_y.field_74363_ab;
        if (!currentLang.equals(lastCheckedLanguage)) {
            infoMessageShownForLang = false;
            lastCheckedLanguage = currentLang;
        }
        boolean foundPair = this.hasVoiceFiles(currentLang);
        mc.func_152344_a(() -> {
            if (!foundPair) {
                if (NarratorConfig.enableJoinMessages) {
                    String message = I18n.func_135052_a((String)"narrator.voice.warning.missing_pair", (Object[])new Object[]{currentLang});
                    NarratorEventHandler.printWrappedColoredMessage("\u00a7c", message);
                }
                infoMessageShownForLang = false;
            } else if (NarratorConfig.enableJoinMessages && !infoMessageShownForLang) {
                String message = I18n.func_135052_a((String)"narrator.voice.info.found_pair", (Object[])new Object[]{currentLang});
                NarratorEventHandler.printWrappedColoredMessage("\u00a7a", message);
                infoMessageShownForLang = true;
            }
        });
    }

    private boolean hasVoiceFiles(String currentLang) {
        File langVoicesDir = new File(PiperClient.getBaseDir(), "voices/" + currentLang);
        File[] onnxFiles = langVoicesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".onnx"));
        File[] jsonFiles = langVoicesDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".onnx.json"));
        boolean foundPair = false;
        if (onnxFiles != null && jsonFiles != null) {
            for (File onnx : onnxFiles) {
                String baseName = onnx.getName().substring(0, onnx.getName().lastIndexOf(46));
                File json = new File(langVoicesDir, baseName + ".onnx.json");
                if (!json.exists()) continue;
                foundPair = true;
                break;
            }
        }
        return foundPair;
    }

    public static void printWrappedColoredMessage(String colorCode, String message) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71456_v == null || mc.field_71466_p == null) {
            return;
        }
        int chatWidth = mc.field_71456_v.func_146158_b().func_146228_f();
        List wrappedLines = mc.field_71466_p.func_78271_c(message, chatWidth);
        for (String line : wrappedLines) {
            mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(colorCode + line + " "));
        }
    }
}

