/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.keybind;

import com.gedeongrays.narrator.audio.AudioPlayer;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeybindHandler {
    public static final String NARRATOR_CATEGORY = "Narrator";
    public static final KeyBinding toggleNarratorKey = new KeyBinding("narrator.key.toggle", 0, "Narrator");
    public static final KeyBinding stopNarrationKey = new KeyBinding("narrator.key.stop", 0, "Narrator");
    private static boolean isModEnabled = true;
    private static boolean wasToggleKeyPressed = false;
    private static boolean wasStopKeyPressed = false;

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyBinding)toggleNarratorKey);
        ClientRegistry.registerKeyBinding((KeyBinding)stopNarrationKey);
        FMLCommonHandler.instance().bus().register((Object)new KeybindHandler());
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            boolean isToggleKeyPressed = KeybindHandler.isKeyOrMouseButtonDown(toggleNarratorKey.func_151463_i());
            boolean isStopKeyPressed = KeybindHandler.isKeyOrMouseButtonDown(stopNarrationKey.func_151463_i());
            if (isToggleKeyPressed && !wasToggleKeyPressed) {
                isModEnabled = !isModEnabled;
                String message = isModEnabled ? I18n.func_135052_a((String)"narrator.key.toggle.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"narrator.key.toggle.off", (Object[])new Object[0]);
                AudioPlayer.speakAsync(message);
            }
            if (isStopKeyPressed && !wasStopKeyPressed) {
                AudioPlayer.stop();
            }
            wasToggleKeyPressed = isToggleKeyPressed;
            wasStopKeyPressed = isStopKeyPressed;
        }
    }

    private static boolean isKeyOrMouseButtonDown(int keyCode) {
        if (keyCode > 0) {
            return Keyboard.isKeyDown((int)keyCode);
        }
        if (keyCode < 0) {
            return Mouse.isButtonDown((int)(keyCode + 100));
        }
        return false;
    }

    public static boolean isNarratorEnabled() {
        return isModEnabled;
    }
}

