/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.achievement.GuiAchievements;
import net.minecraft.client.resources.I18n;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.AchievementPage;

public class AchievementNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    int delay = NarratorConfig.achievementNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        String narrationText;
        String hoveredElement;
        block25: {
            if (!NarratorConfig.enableAchievementListener || !KeybindHandler.isNarratorEnabled()) {
                return;
            }
            if (!(event.gui instanceof GuiAchievements)) {
                this.currentHoveredElement = null;
                this.hoverStartTime = -1L;
                return;
            }
            GuiAchievements gui = (GuiAchievements)event.gui;
            hoveredElement = null;
            narrationText = null;
            int mouseX = event.mouseX;
            int mouseY = event.mouseY;
            try {
                Field fPaneW = this.findField(GuiAchievements.class, "field_146555_f", "field_146555_f");
                Field fPaneH = this.findField(GuiAchievements.class, "field_146557_g", "field_146557_g");
                Field fZoom = this.findField(GuiAchievements.class, "field_146570_r", "field_146570_r");
                Field fPrevX = this.findField(GuiAchievements.class, "field_146569_s", "field_146569_s");
                Field fPrevY = this.findField(GuiAchievements.class, "field_146568_t", "field_146568_t");
                Field fCurX = this.findField(GuiAchievements.class, "field_146567_u", "field_146567_u");
                Field fCurY = this.findField(GuiAchievements.class, "field_146566_v", "field_146566_v");
                Field fStatWriter = this.findField(GuiAchievements.class, "field_146556_E", "statFileWriter");
                Field fCurrentPage = this.findField(GuiAchievements.class, "currentPage", "currentPage");
                Field fMinecraftAchievements = this.findField(GuiAchievements.class, "minecraftAchievements", "minecraftAchievements");
                if (fPaneW == null || fPaneH == null || fZoom == null || fPrevX == null || fPrevY == null || fCurX == null || fCurY == null || fCurrentPage == null || fMinecraftAchievements == null) {
                    return;
                }
                int paneW = fPaneW.getInt(gui);
                int paneH = fPaneH.getInt(gui);
                float zoom = fZoom.getFloat(gui);
                int left = (gui.field_146294_l - paneW) / 2;
                int top = (gui.field_146295_m - paneH) / 2;
                int visibleXMin = left + 16;
                int visibleXMax = left + 239;
                int visibleYMin = top + 17;
                int visibleYMax = top + 170;
                int anchorX = left + 16;
                int anchorY = top + 17;
                double prevX = fPrevX.getDouble(gui);
                double prevY = fPrevY.getDouble(gui);
                double curX = fCurX.getDouble(gui);
                double curY = fCurY.getDouble(gui);
                float pt = event.renderPartialTicks;
                int k = MathHelper.func_76128_c((double)(prevX + (curX - prevX) * (double)pt));
                int l = MathHelper.func_76128_c((double)(prevY + (curY - prevY) * (double)pt));
                int titleX = left + 14;
                int titleY = top + 4;
                String title = I18n.func_135052_a((String)"gui.achievements", (Object[])new Object[0]);
                int titleWidth = this.mc.field_71466_p.func_78256_a(title);
                if (this.isMouseOver(mouseX, mouseY, titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b)) {
                    hoveredElement = "title";
                    narrationText = title;
                }
                if (hoveredElement != null || mouseX < visibleXMin || mouseX > visibleXMax || mouseY < visibleYMin || mouseY > visibleYMax) break block25;
                List list = null;
                int achPageIndex = fCurrentPage.getInt(gui);
                if (achPageIndex >= 0) {
                    List filteredList;
                    Object achievementPage;
                    Method mGetAchPage = this.findMethod(AchievementPage.class, "getAchievementPage", "getAchievementPage", Integer.TYPE);
                    Method mGetAchievements = this.findMethod(AchievementPage.class, "getAchievements", "getAchievements", new Class[0]);
                    if (mGetAchPage != null && mGetAchievements != null && (achievementPage = mGetAchPage.invoke(null, achPageIndex)) != null && (filteredList = (List)mGetAchievements.invoke(achievementPage, new Object[0])) != null && !filteredList.isEmpty()) {
                        list = filteredList;
                    }
                } else if (achPageIndex == -1) {
                    list = (List)fMinecraftAchievements.get(gui);
                }
                if (list == null) {
                    list = AchievementList.field_76007_e;
                }
                if (list == null) break block25;
                for (Achievement a : list) {
                    int boxSize;
                    int boxScreenY;
                    int i5 = a.field_75993_a * 24 - k;
                    int j5 = a.field_75991_b * 24 - l;
                    float invZoom = 1.0f / Math.max(zoom, 1.0f);
                    int boxScreenX = (int)Math.floor((float)anchorX + (float)i5 * invZoom);
                    if (!this.isMouseOver(mouseX, mouseY, boxScreenX, boxScreenY = (int)Math.floor((float)anchorY + (float)j5 * invZoom), boxSize = (int)Math.ceil(22.0f * invZoom), boxSize)) continue;
                    hoveredElement = a;
                    Method mGetName = this.findMethod(Achievement.class, "func_150951_e", "getStatName", new Class[0]);
                    Method mGetDesc = this.findMethod(Achievement.class, "func_75989_e", "getDescription", new Class[0]);
                    Method mHas = this.findMethod(StatFileWriter.class, "func_77443_a", "hasAchievementUnlocked", Achievement.class);
                    Method mCan = this.findMethod(StatFileWriter.class, "func_77442_b", "canUnlockAchievement", Achievement.class);
                    Method mStatus = this.findMethod(StatFileWriter.class, "func_150874_c", "func_150874_c", Achievement.class);
                    Field fParentAch = this.findField(Achievement.class, "field_75992_c", "parentAchievement");
                    if (mGetName != null && mGetDesc != null && mHas != null && mCan != null && mStatus != null) {
                        StringBuilder sb = new StringBuilder();
                        StatFileWriter stats = (StatFileWriter)fStatWriter.get(gui);
                        if (((Boolean)mHas.invoke((Object)stats, a)).booleanValue()) {
                            IChatComponent name = (IChatComponent)mGetName.invoke((Object)a, new Object[0]);
                            String descKey = (String)mGetDesc.invoke((Object)a, new Object[0]);
                            sb.append(name.func_150261_e()).append(", ").append(I18n.func_135052_a((String)descKey, (Object[])new Object[0])).append(", ").append(I18n.func_135052_a((String)"achievement.taken", (Object[])new Object[0]));
                            narrationText = sb.toString();
                        } else if (((Boolean)mCan.invoke((Object)stats, a)).booleanValue()) {
                            IChatComponent name = (IChatComponent)mGetName.invoke((Object)a, new Object[0]);
                            String descKey = (String)mGetDesc.invoke((Object)a, new Object[0]);
                            sb.append(name.func_150261_e()).append(", ").append(I18n.func_135052_a((String)descKey, (Object[])new Object[0]));
                            narrationText = sb.toString();
                        } else {
                            int status = (Integer)mStatus.invoke((Object)stats, a);
                            if (status < 4) {
                                Object p;
                                String parentName = "unknown";
                                if (fParentAch != null && (p = fParentAch.get(a)) instanceof Achievement) {
                                    IChatComponent parentChat = (IChatComponent)mGetName.invoke(p, new Object[0]);
                                    parentName = parentChat.func_150261_e();
                                }
                                if (status == 3) {
                                    sb.append(I18n.func_135052_a((String)"achievement.unknown", (Object[])new Object[0]));
                                } else {
                                    IChatComponent name = (IChatComponent)mGetName.invoke((Object)a, new Object[0]);
                                    sb.append(name.func_150261_e());
                                }
                                sb.append(", ").append(I18n.func_135052_a((String)"achievement.requires", (Object[])new Object[]{parentName}));
                                narrationText = sb.toString();
                            }
                        }
                    }
                    break;
                }
            }
            catch (Throwable t) {
                NarratorConfig.logError("[Narrator] Error when narrating achievements: " + t.getMessage());
                t.printStackTrace();
            }
        }
        if (this.currentHoveredElement != hoveredElement) {
            this.currentHoveredElement = hoveredElement;
            this.hoverStartTime = System.currentTimeMillis();
        } else if (hoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
            if (narrationText != null && !narrationText.isEmpty()) {
                AudioPlayer.speakAsync(narrationText);
            }
            this.hoverStartTime = -1L;
        }
    }

    private Field findField(Class<?> clazz, String srgName, String deobfName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(srgName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field f = c.getDeclaredField(deobfName);
                    f.setAccessible(true);
                    return f;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz, String srgName, String deobfName, Class<?> ... parameterTypes) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(srgName, parameterTypes);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e) {
                try {
                    Method m = c.getDeclaredMethod(deobfName, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private boolean isMouseOver(int mx, int my, int x, int y, int w, int h) {
        return mx >= x && mx <= x + w && my >= y && my <= y + h;
    }
}

