/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCommandBlock;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.client.gui.GuiHopper;
import net.minecraft.client.gui.GuiRepair;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiBeacon;
import net.minecraft.client.gui.inventory.GuiBrewingStand;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiDispenser;
import net.minecraft.client.gui.inventory.GuiEditSign;
import net.minecraft.client.gui.inventory.GuiFurnace;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraftforge.client.event.GuiScreenEvent;

public class BlockNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.blockNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableBlockListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiChest || event.gui instanceof GuiCrafting || event.gui instanceof GuiFurnace || event.gui instanceof GuiEnchantment || event.gui instanceof GuiRepair || event.gui instanceof GuiDispenser || event.gui instanceof GuiHopper || event.gui instanceof GuiBrewingStand || event.gui instanceof GuiBeacon || event.gui instanceof GuiCommandBlock || event.gui instanceof GuiEditSign)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty()) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = event.gui;
        try {
            if (gui instanceof GuiContainer) {
                Field guiLeftField = this.findField(GuiContainer.class, "guiLeft", "field_147003_i");
                Field guiTopField = this.findField(GuiContainer.class, "guiTop", "field_147009_r");
                Field xSizeField = this.findField(GuiContainer.class, "xSize", "field_146999_f");
                Field ySizeField = this.findField(GuiContainer.class, "ySize", "field_147000_g");
                if (guiLeftField == null || guiTopField == null || xSizeField == null || ySizeField == null) {
                    return null;
                }
                int guiLeft = guiLeftField.getInt(gui);
                int guiTop = guiTopField.getInt(gui);
                int xSize = xSizeField.getInt(gui);
                int ySize = ySizeField.getInt(gui);
                if (gui instanceof GuiChest) {
                    int inventoryLabelHeight;
                    String inventoryLabelKey;
                    String inventoryLabelText;
                    int inventoryLabelWidth;
                    int chestLabelHeight;
                    GuiChest chestGui = (GuiChest)gui;
                    Field lowerChestInventoryField = this.findField(GuiChest.class, "lowerChestInventory", "field_147015_w");
                    if (lowerChestInventoryField == null) {
                        return null;
                    }
                    IInventory chestInventory = (IInventory)lowerChestInventoryField.get(chestGui);
                    int chestLabelX = guiLeft + 7;
                    int chestLabelY = guiTop + 5;
                    String chestLabelKey = chestInventory.func_145825_b();
                    String chestLabelText = chestInventory.func_145818_k_() ? chestLabelKey : I18n.func_135052_a((String)chestLabelKey, (Object[])new Object[0]);
                    int chestLabelWidth = mc.field_71466_p.func_78256_a(chestLabelText);
                    if (this.isMouseOver(mouseX, mouseY, chestLabelX, chestLabelY, chestLabelWidth, chestLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(chestLabelText, "chest_label", chestLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + chestInventory.func_70302_i_() / 9 * 18 + 20;
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText = I18n.func_135052_a((String)(inventoryLabelKey = "container.inventory"), (Object[])new Object[0])), inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiCrafting) {
                    int inventoryLabelHeight;
                    int craftingLabelHeight;
                    int craftingLabelX = guiLeft + 27;
                    int craftingLabelY = guiTop + 5;
                    String craftingLabelKey = "container.crafting";
                    String craftingLabelText = I18n.func_135052_a((String)craftingLabelKey, (Object[])new Object[0]);
                    int craftingLabelWidth = mc.field_71466_p.func_78256_a(craftingLabelText);
                    if (this.isMouseOver(mouseX, mouseY, craftingLabelX, craftingLabelY, craftingLabelWidth, craftingLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(craftingLabelText, "crafting_label", craftingLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = "container.inventory";
                    String inventoryLabelText = I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiFurnace) {
                    int inventoryLabelHeight;
                    int furnaceLabelHeight;
                    int furnaceLabelY;
                    GuiFurnace furnaceGui = (GuiFurnace)gui;
                    Field tileFurnaceField = this.findField(GuiFurnace.class, "tileFurnace", "field_147086_v");
                    if (tileFurnaceField == null) {
                        return null;
                    }
                    TileEntityFurnace tileFurnace = (TileEntityFurnace)tileFurnaceField.get(furnaceGui);
                    String furnaceLabelKey = tileFurnace.func_145825_b();
                    String furnaceLabelText = tileFurnace.func_145818_k_() ? furnaceLabelKey : I18n.func_135052_a((String)furnaceLabelKey, (Object[])new Object[0]);
                    int furnaceLabelWidth = mc.field_71466_p.func_78256_a(furnaceLabelText);
                    int furnaceLabelX = guiLeft + xSize / 2 - furnaceLabelWidth / 2 - 1;
                    if (this.isMouseOver(mouseX, mouseY, furnaceLabelX, furnaceLabelY = guiTop + 5, furnaceLabelWidth, furnaceLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(furnaceLabelText, "furnace_label", furnaceLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = "container.inventory";
                    String inventoryLabelText = I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiEnchantment) {
                    int inventoryLabelHeight;
                    int enchantmentLabelHeight;
                    int enchantmentLabelX = guiLeft + 11;
                    int enchantmentLabelY = guiTop + 4;
                    String enchantmentLabelKey = "container.enchant";
                    String enchantmentLabelText = I18n.func_135052_a((String)enchantmentLabelKey, (Object[])new Object[0]);
                    int enchantmentLabelWidth = mc.field_71466_p.func_78256_a(enchantmentLabelText);
                    if (this.isMouseOver(mouseX, mouseY, enchantmentLabelX, enchantmentLabelY, enchantmentLabelWidth, enchantmentLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(enchantmentLabelText, "enchantment_label", enchantmentLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = "container.inventory";
                    String inventoryLabelText = I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiRepair) {
                    boolean suppressCostNarration;
                    int repairLabelHeight;
                    GuiRepair repairGui = (GuiRepair)gui;
                    Field containerField = this.findField(GuiRepair.class, "anvil", "field_147092_v");
                    Field nameField = this.findField(GuiRepair.class, "nameField", "field_147091_w");
                    if (containerField == null || nameField == null) {
                        return null;
                    }
                    ContainerRepair container = (ContainerRepair)containerField.get(repairGui);
                    GuiTextField nameFieldObj = (GuiTextField)nameField.get(repairGui);
                    int repairLabelX = guiLeft + 59;
                    int repairLabelY = guiTop + 5;
                    String repairLabelKey = "container.repair";
                    String repairLabelText = I18n.func_135052_a((String)repairLabelKey, (Object[])new Object[0]);
                    int repairLabelWidth = mc.field_71466_p.func_78256_a(repairLabelText);
                    if (this.isMouseOver(mouseX, mouseY, repairLabelX, repairLabelY, repairLabelWidth, repairLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(repairLabelText, "repair_label", repairLabelKey);
                    }
                    int nameFieldX = nameFieldObj.field_146209_f - 1;
                    int nameFieldY = nameFieldObj.field_146210_g - 2;
                    int nameFieldWidth = nameFieldObj.field_146218_h + 2;
                    int nameFieldHeight = nameFieldObj.field_146219_i - 1;
                    String nameText = nameFieldObj.func_146179_b();
                    if (nameText == null || nameText.trim().isEmpty()) {
                        return null;
                    }
                    if (this.isMouseOver(mouseX, mouseY, nameFieldX, nameFieldY, nameFieldWidth, nameFieldHeight)) {
                        return new HoverResult(nameText, "name_field", "name_field");
                    }
                    int costRightX = guiLeft + 167;
                    int costY = guiTop + 67;
                    int costHeight = mc.field_71466_p.field_78288_b - 1;
                    boolean isCreative = mc.field_71439_g.field_71075_bZ.field_75098_d;
                    boolean isOnlyFirstSlotOccupied = container.func_75139_a(0).func_75216_d() && !container.func_75139_a(1).func_75216_d() && !container.func_75139_a(2).func_75216_d();
                    boolean isResultSlotEmpty = container.func_75139_a(0).func_75216_d() && container.func_75139_a(1).func_75216_d() && !container.func_75139_a(2).func_75216_d();
                    boolean bl = suppressCostNarration = isCreative && isOnlyFirstSlotOccupied || !isCreative && isOnlyFirstSlotOccupied && container.field_82854_e < 40 || !isCreative && isResultSlotEmpty;
                    if (!suppressCostNarration) {
                        String costKey;
                        String costText;
                        int costWidth;
                        int costX;
                        if (!isCreative && container.field_82854_e >= 40) {
                            String tooExpensiveKey = "container.repair.expensive";
                            String tooExpensiveText = I18n.func_135052_a((String)tooExpensiveKey, (Object[])new Object[0]);
                            int tooExpensiveWidth = mc.field_71466_p.func_78256_a(tooExpensiveText);
                            int tooExpensiveX = costRightX - tooExpensiveWidth;
                            if (this.isMouseOver(mouseX, mouseY, tooExpensiveX, costY, tooExpensiveWidth, costHeight)) {
                                return new HoverResult(tooExpensiveText, "too_expensive", tooExpensiveKey);
                            }
                        } else if (container.field_82854_e > 0 && this.isMouseOver(mouseX, mouseY, costX = costRightX - (costWidth = mc.field_71466_p.func_78256_a(costText = I18n.func_135052_a((String)(costKey = "container.repair.cost"), (Object[])new Object[]{container.field_82854_e}))), costY, costWidth, costHeight)) {
                            return new HoverResult(costText, "cost_label", costKey + container.field_82854_e);
                        }
                    }
                } else if (gui instanceof GuiDispenser) {
                    int inventoryLabelHeight;
                    int guiLabelHeight;
                    int guiLabelY;
                    GuiDispenser dispenserGui = (GuiDispenser)gui;
                    Field tileDispenserField = this.findField(GuiDispenser.class, "tileDispenser", "field_147089_u");
                    if (tileDispenserField == null) {
                        return null;
                    }
                    TileEntityDispenser tileDispenser = (TileEntityDispenser)tileDispenserField.get(dispenserGui);
                    String guiLabelKey = tileDispenser.func_145825_b();
                    String guiLabelText = tileDispenser.func_145818_k_() ? guiLabelKey : I18n.func_135052_a((String)guiLabelKey, (Object[])new Object[0]);
                    int guiLabelWidth = mc.field_71466_p.func_78256_a(guiLabelText);
                    int guiLabelX = guiLeft + xSize / 2 - guiLabelWidth / 2 - 1;
                    if (this.isMouseOver(mouseX, mouseY, guiLabelX, guiLabelY = guiTop + 5, guiLabelWidth, guiLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(guiLabelText, "gui_label", guiLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = "container.inventory";
                    String inventoryLabelText = I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiHopper) {
                    int inventoryLabelHeight;
                    int hopperLabelHeight;
                    GuiHopper hopperGui = (GuiHopper)gui;
                    Field hopperInventoryField = this.findField(GuiHopper.class, "field_147083_w", "field_147083_w");
                    Field playerInventoryField = this.findField(GuiHopper.class, "field_147084_v", "field_147084_v");
                    if (hopperInventoryField == null || playerInventoryField == null) {
                        return null;
                    }
                    IInventory hopperInventory = (IInventory)hopperInventoryField.get(hopperGui);
                    IInventory playerInventory = (IInventory)playerInventoryField.get(hopperGui);
                    int hopperLabelX = guiLeft + 7;
                    int hopperLabelY = guiTop + 5;
                    String hopperLabelKey = hopperInventory.func_145825_b();
                    String hopperLabelText = hopperInventory.func_145818_k_() ? hopperLabelKey : I18n.func_135052_a((String)hopperLabelKey, (Object[])new Object[0]);
                    int hopperLabelWidth = mc.field_71466_p.func_78256_a(hopperLabelText);
                    if (this.isMouseOver(mouseX, mouseY, hopperLabelX, hopperLabelY, hopperLabelWidth, hopperLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(hopperLabelText, "hopper_label", hopperLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = playerInventory.func_145825_b();
                    String inventoryLabelText = playerInventory.func_145818_k_() ? inventoryLabelKey : I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiBrewingStand) {
                    int inventoryLabelHeight;
                    int brewingLabelHeight;
                    int brewingLabelY;
                    GuiBrewingStand brewingGui = (GuiBrewingStand)gui;
                    Field tileBrewingField = this.findField(GuiBrewingStand.class, "tileBrewingStand", "field_147013_v");
                    if (tileBrewingField == null) {
                        return null;
                    }
                    TileEntityBrewingStand tileBrewingStand = (TileEntityBrewingStand)tileBrewingField.get(brewingGui);
                    String brewingLabelKey = tileBrewingStand.func_145825_b();
                    String brewingLabelText = tileBrewingStand.func_145818_k_() ? brewingLabelKey : I18n.func_135052_a((String)brewingLabelKey, (Object[])new Object[0]);
                    int brewingLabelWidth = mc.field_71466_p.func_78256_a(brewingLabelText);
                    int brewingLabelX = guiLeft + xSize / 2 - brewingLabelWidth / 2 - 1;
                    if (this.isMouseOver(mouseX, mouseY, brewingLabelX, brewingLabelY = guiTop + 5, brewingLabelWidth, brewingLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(brewingLabelText, "brewing_label", brewingLabelKey);
                    }
                    int inventoryLabelX = guiLeft + 7;
                    int inventoryLabelY = guiTop + ySize - 94;
                    String inventoryLabelKey = "container.inventory";
                    String inventoryLabelText = I18n.func_135052_a((String)inventoryLabelKey, (Object[])new Object[0]);
                    int inventoryLabelWidth = mc.field_71466_p.func_78256_a(inventoryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, inventoryLabelX, inventoryLabelY, inventoryLabelWidth, inventoryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(inventoryLabelText, "inventory_label", inventoryLabelKey);
                    }
                } else if (gui instanceof GuiBeacon) {
                    int secondaryLabelHeight;
                    int primaryLabelHeight;
                    int primaryLabelX = guiLeft + 25;
                    int primaryLabelY = guiTop + 9;
                    String primaryLabelKey = "tile.beacon.primary";
                    String primaryLabelText = I18n.func_135052_a((String)primaryLabelKey, (Object[])new Object[0]);
                    int primaryLabelWidth = mc.field_71466_p.func_78256_a(primaryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, primaryLabelX, primaryLabelY, primaryLabelWidth, primaryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(primaryLabelText, "primary_label", primaryLabelKey);
                    }
                    int secondaryLabelX = guiLeft + 124;
                    int secondaryLabelY = guiTop + 9;
                    String secondaryLabelKey = "tile.beacon.secondary";
                    String secondaryLabelText = I18n.func_135052_a((String)secondaryLabelKey, (Object[])new Object[0]);
                    int secondaryLabelWidth = mc.field_71466_p.func_78256_a(secondaryLabelText);
                    if (this.isMouseOver(mouseX, mouseY, secondaryLabelX, secondaryLabelY, secondaryLabelWidth, secondaryLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(secondaryLabelText, "secondary_label", secondaryLabelKey);
                    }
                    Field buttonListField = this.findField(GuiScreen.class, "buttonList", "field_146292_n");
                    if (buttonListField != null) {
                        List buttonList = (List)buttonListField.get(gui);
                        for (Object buttonObj : buttonList) {
                            if (!(buttonObj instanceof GuiButton)) continue;
                            GuiButton button = (GuiButton)buttonObj;
                            if (!this.isMouseOver(mouseX, mouseY, button.field_146128_h, button.field_146129_i, button.field_146120_f - 1, button.field_146121_g - 1)) continue;
                            if (button.field_146127_k == -1) {
                                return new HoverResult(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button, "button_done");
                            }
                            if (button.field_146127_k == -2) {
                                return new HoverResult(I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button, "button_cancel");
                            }
                            try {
                                String potionName;
                                Class<?> powerButtonClass = Class.forName("net.minecraft.client.gui.inventory.GuiBeacon$PowerButton");
                                if (!powerButtonClass.isInstance(buttonObj)) continue;
                                Field potionIdField = this.findField(powerButtonClass, "field_146149_p", "field_146149_p");
                                Field tierField = this.findField(powerButtonClass, "field_146148_q", "field_146148_q");
                                if (potionIdField == null || tierField == null) continue;
                                int potionId = potionIdField.getInt(buttonObj);
                                int tier = tierField.getInt(buttonObj);
                                if (potionId < 0 || potionId >= Potion.field_76425_a.length || Potion.field_76425_a[potionId] == null) continue;
                                Potion potion = Potion.field_76425_a[potionId];
                                String narrationText = potionName = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                                if (tier >= 3 && potionId != Potion.field_76428_l.field_76415_H) {
                                    narrationText = narrationText + " II";
                                }
                                return new HoverResult(narrationText, buttonObj, "effect_button_" + potionId);
                            }
                            catch (ClassNotFoundException e) {
                                NarratorConfig.logError("[Narrator] GuiBeacon$PowerButton class not found. This might be an issue with the environment.");
                            }
                        }
                    }
                }
            } else if (gui instanceof GuiCommandBlock) {
                int allPlayersHeight;
                int randomPlayerHeight;
                int nearestPlayerHeight;
                String nearestPlayerKey;
                String nearestPlayerText;
                int nearestPlayerWidth;
                int nearestPlayerY;
                int nearestPlayerX;
                int prevOutputLabelHeight;
                String prevOutputLabelKey;
                String prevOutputLabelText;
                int prevOutputLabelWidth;
                int prevOutputLabelY;
                int prevOutputLabelX;
                int commandLabelHeight;
                int setTitleHeight;
                int setTitleY;
                GuiCommandBlock commandBlockGui = (GuiCommandBlock)gui;
                String setTitleKey = "advMode.setCommand";
                String setTitleText = I18n.func_135052_a((String)setTitleKey, (Object[])new Object[0]);
                int setTitleWidth = mc.field_71466_p.func_78256_a(setTitleText);
                int setTitleX = gui.field_146294_l / 2 - setTitleWidth / 2 - 1;
                if (this.isMouseOver(mouseX, mouseY, setTitleX, setTitleY = 19, setTitleWidth, setTitleHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(setTitleText, setTitleKey, setTitleKey);
                }
                int commandLabelX = gui.field_146294_l / 2 - 151;
                int commandLabelY = 36;
                String commandLabelKey = "advMode.command";
                String commandLabelText = I18n.func_135052_a((String)commandLabelKey, (Object[])new Object[0]);
                int commandLabelWidth = mc.field_71466_p.func_78256_a(commandLabelText);
                if (this.isMouseOver(mouseX, mouseY, commandLabelX, commandLabelY, commandLabelWidth, commandLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(commandLabelText, commandLabelKey, commandLabelKey);
                }
                Field commandTextField = this.findField(GuiCommandBlock.class, "commandTextField", "field_146485_f");
                if (commandTextField != null) {
                    GuiTextField textField = (GuiTextField)commandTextField.get(commandBlockGui);
                    String text = textField.func_146179_b();
                    if (this.isMouseOver(mouseX, mouseY, textField.field_146209_f, textField.field_146210_g + 1, textField.field_146218_h - 1, textField.field_146219_i - 2)) {
                        if (text != null && !text.trim().isEmpty()) {
                            return new HoverResult(text, "command_field", "command_field");
                        }
                        return null;
                    }
                }
                if (this.isMouseOver(mouseX, mouseY, prevOutputLabelX = gui.field_146294_l / 2 - 151, prevOutputLabelY = 121, prevOutputLabelWidth = mc.field_71466_p.func_78256_a(prevOutputLabelText = I18n.func_135052_a((String)(prevOutputLabelKey = "advMode.previousOutput"), (Object[])new Object[0])), prevOutputLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(prevOutputLabelText, prevOutputLabelKey, prevOutputLabelKey);
                }
                Field prevOutputTextField = this.findField(GuiCommandBlock.class, "field_146486_g", "field_146486_g");
                if (prevOutputTextField != null) {
                    GuiTextField textField = (GuiTextField)prevOutputTextField.get(commandBlockGui);
                    String text = textField.func_146179_b();
                    if (this.isMouseOver(mouseX, mouseY, textField.field_146209_f, textField.field_146210_g + 1, textField.field_146218_h - 1, textField.field_146219_i - 2)) {
                        if (text != null && !text.trim().isEmpty()) {
                            return new HoverResult(text, "previous_output_field", "previous_output_field");
                        }
                        return null;
                    }
                }
                if (this.isMouseOver(mouseX, mouseY, nearestPlayerX = gui.field_146294_l / 2 - 151, nearestPlayerY = 75, nearestPlayerWidth = mc.field_71466_p.func_78256_a(nearestPlayerText = I18n.func_135052_a((String)(nearestPlayerKey = "advMode.nearestPlayer"), (Object[])new Object[0])), nearestPlayerHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(nearestPlayerText, nearestPlayerKey, nearestPlayerKey);
                }
                int randomPlayerX = gui.field_146294_l / 2 - 151;
                int randomPlayerY = 84;
                String randomPlayerKey = "advMode.randomPlayer";
                String randomPlayerText = I18n.func_135052_a((String)randomPlayerKey, (Object[])new Object[0]);
                int randomPlayerWidth = mc.field_71466_p.func_78256_a(randomPlayerText);
                if (this.isMouseOver(mouseX, mouseY, randomPlayerX, randomPlayerY, randomPlayerWidth, randomPlayerHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(randomPlayerText, randomPlayerKey, randomPlayerKey);
                }
                int allPlayersX = gui.field_146294_l / 2 - 151;
                int allPlayersY = 93;
                String allPlayersKey = "advMode.allPlayers";
                String allPlayersText = I18n.func_135052_a((String)allPlayersKey, (Object[])new Object[0]);
                int allPlayersWidth = mc.field_71466_p.func_78256_a(allPlayersText);
                if (this.isMouseOver(mouseX, mouseY, allPlayersX, allPlayersY, allPlayersWidth, allPlayersHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(allPlayersText, allPlayersKey, allPlayersKey);
                }
            } else if (gui instanceof GuiEditSign) {
                int editLabelHeight;
                int editLabelY;
                GuiEditSign signGui = (GuiEditSign)gui;
                Field tileSignField = this.findField(GuiEditSign.class, "tileSign", "field_146848_f");
                if (tileSignField == null) {
                    return null;
                }
                TileEntitySign tileSign = (TileEntitySign)tileSignField.get(signGui);
                String editLabelKey = "sign.edit";
                String editLabelText = I18n.func_135052_a((String)editLabelKey, (Object[])new Object[0]);
                int editLabelWidth = mc.field_71466_p.func_78256_a(editLabelText);
                int editLabelX = gui.field_146294_l / 2 - editLabelWidth / 2 - 1;
                if (this.isMouseOver(mouseX, mouseY, editLabelX, editLabelY = 39, editLabelWidth, editLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                    return new HoverResult(editLabelText, editLabelKey, editLabelKey);
                }
                String[] signText = tileSign.field_145915_a;
                for (int i = 0; i < signText.length; ++i) {
                    int lineHeight;
                    String line = signText[i];
                    if (line == null || line.trim().isEmpty()) continue;
                    int lineY = 70 + i * 11;
                    int lineWidth = mc.field_71466_p.func_78256_a(line);
                    int lineX = gui.field_146294_l / 2 - lineWidth / 2 - 1;
                    if (!this.isMouseOver(mouseX, mouseY, lineX, lineY, lineWidth, lineHeight = 8)) continue;
                    return new HoverResult(line, "sign_line", "sign_line");
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during block inventory narration.");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(deobfName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(srgName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

