/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.client.event.GuiScreenEvent;

public class BookNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.bookNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableBookListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiScreenBook)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty()) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = event.gui;
        try {
            if (gui instanceof GuiScreenBook) {
                GuiScreenBook bookGui = (GuiScreenBook)gui;
                Field bookGettingSignedField = this.findField("bookGettingSigned", "field_146480_s");
                Field bookPagesField = this.findField("bookPages", "field_146483_y");
                Field currPageField = this.findField("currPage", "field_146484_x");
                Field bookTotalPagesField = this.findField("bookTotalPages", "field_146476_w");
                Field bookImageWidthField = this.findField("bookImageWidth", "field_146478_u");
                Field bookTitleField = this.findField("bookTitle", "field_146482_z");
                if (bookGettingSignedField == null || bookPagesField == null || currPageField == null || bookTotalPagesField == null || bookImageWidthField == null || bookTitleField == null) {
                    return null;
                }
                boolean bookGettingSigned = bookGettingSignedField.getBoolean(bookGui);
                if (!bookGettingSigned) {
                    int pageIndicatorHeight;
                    int pageIndicatorY;
                    int currPage = currPageField.getInt(bookGui);
                    int bookTotalPages = bookTotalPagesField.getInt(bookGui);
                    String pageIndicator = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{currPage + 1, bookTotalPages});
                    int pageIndicatorWidth = mc.field_71466_p.func_78256_a(pageIndicator);
                    int pageIndicatorRightX = gui.field_146294_l / 2 + 51 - pageIndicatorWidth;
                    if (this.isMouseOver(mouseX, mouseY, pageIndicatorRightX, pageIndicatorY = 17, pageIndicatorWidth, pageIndicatorHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(pageIndicator, "book_page_indicator", "book_page_indicator");
                    }
                    NBTTagList bookPages = (NBTTagList)bookPagesField.get(bookGui);
                    if (currPage >= 0 && currPage < bookPages.func_74745_c()) {
                        String pageText = bookPages.func_150307_f(currPage);
                        List lines = mc.field_71466_p.func_78271_c(pageText, 118);
                        int lineY = 34;
                        for (String line : lines) {
                            int lineHeight;
                            int lineWidth;
                            int lineX;
                            if (!line.trim().isEmpty() && this.isMouseOver(mouseX, mouseY, lineX = gui.field_146294_l / 2 - 61, lineY, lineWidth = 118, lineHeight = 7)) {
                                return new HoverResult(pageText, "book_page", "book_page");
                            }
                            lineY += mc.field_71466_p.field_78288_b;
                        }
                    }
                } else {
                    int authorTextHeight;
                    int authorTextY;
                    int titleHeight;
                    int titleY;
                    int titleX;
                    int titleLabelHeight;
                    int titleLabelY;
                    String titleLabelKey;
                    String titleLabelText;
                    int titleLabelWidth;
                    int bookImageWidth = bookImageWidthField.getInt(bookGui);
                    int bookLeft = (gui.field_146294_l - bookImageWidth) / 2;
                    int titleLabelX = bookLeft + 35 + (116 - (titleLabelWidth = mc.field_71466_p.func_78256_a(titleLabelText = I18n.func_135052_a((String)(titleLabelKey = "book.editTitle"), (Object[])new Object[0])))) / 2;
                    if (this.isMouseOver(mouseX, mouseY, titleLabelX, titleLabelY = 33, titleLabelWidth, titleLabelHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(titleLabelText, "book_title_label", "book_title_label");
                    }
                    String bookTitle = (String)bookTitleField.get(bookGui);
                    int titleWidth = mc.field_71466_p.func_78256_a(bookTitle);
                    if (bookTitle != null && !bookTitle.trim().isEmpty() && this.isMouseOver(mouseX, mouseY, titleX = bookLeft + 32 + (116 - titleWidth) / 2, titleY = 49, titleWidth, titleHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(bookTitle, "book_title_textfield", "book_title_textfield");
                    }
                    String authorText = I18n.func_135052_a((String)"book.byAuthor", (Object[])new Object[]{mc.field_71439_g.func_70005_c_()});
                    int authorTextWidth = mc.field_71466_p.func_78256_a(authorText);
                    int authorTextX = bookLeft + 35 + (116 - authorTextWidth) / 2;
                    if (this.isMouseOver(mouseX, mouseY, authorTextX, authorTextY = 59, authorTextWidth, authorTextHeight = mc.field_71466_p.field_78288_b - 1)) {
                        return new HoverResult(authorText, "book_author_label", "book_author_label");
                    }
                    String warningLabelKey = "book.finalizeWarning";
                    String warningLabelText = I18n.func_135052_a((String)warningLabelKey, (Object[])new Object[0]);
                    List warningLines = mc.field_71466_p.func_78271_c(warningLabelText, 116);
                    int warningLineY = 81;
                    Iterator iterator = warningLines.iterator();
                    while (iterator.hasNext()) {
                        int lineHeight;
                        int lineX = bookLeft + 35;
                        String line = (String)iterator.next();
                        int lineWidth = mc.field_71466_p.func_78256_a(line);
                        if (this.isMouseOver(mouseX, mouseY, lineX, warningLineY, lineWidth, lineHeight = mc.field_71466_p.field_78288_b)) {
                            return new HoverResult(warningLabelText, "book_warning_label", "book_warning_label");
                        }
                        warningLineY += mc.field_71466_p.field_78288_b;
                    }
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during book narration.");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(String deobfName, String srgName) {
        for (Class c = GuiScreenBook.class; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(deobfName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(srgName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

