/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class ChatNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private boolean wasButtonDownLastTick = false;
    private String lastNarratedInputText = null;
    private long hoverStartTimeInput = -1L;
    private long hoverStartTimeChat = -1L;
    private String lastNarratedTooltipText = null;
    int delay = NarratorConfig.chatNarratorHoverDelay;
    private Field chatMessagesField;
    private Field chatLineCreatedCounterField;
    private Method chatLineComponentMethod;
    private Field chatScrollField;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableChatListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        boolean isButtonDown = Mouse.isButtonDown((int)0);
        if (event.gui instanceof GuiChat) {
            GuiChat guiChat = (GuiChat)event.gui;
            int mouseX = Mouse.getX();
            int mouseY = Mouse.getY();
            if (isButtonDown && !this.wasButtonDownLastTick) {
                try {
                    String textToNarrate;
                    IChatComponent componentToNarrate = this.getFullComponentAt(mouseX, mouseY);
                    if (componentToNarrate != null && (textToNarrate = this.getTextFromComponent(componentToNarrate)) != null && !textToNarrate.isEmpty()) {
                        AudioPlayer.speakAsync(textToNarrate);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.handleInputHover(guiChat, event.mouseX, event.mouseY);
            this.handleChatHover(mouseX, mouseY);
        }
        this.wasButtonDownLastTick = isButtonDown;
    }

    private IChatComponent getFullComponentAt(int mouseX, int mouseY) {
        try {
            List allLines;
            GuiNewChat chat = this.mc.field_71456_v.func_146158_b();
            Class<?> chatLineClass = Class.forName("net.minecraft.client.gui.ChatLine");
            if (this.chatMessagesField == null) {
                this.chatMessagesField = GuiNewChat.class.getDeclaredField("field_146253_i");
                this.chatMessagesField.setAccessible(true);
            }
            if (this.chatLineComponentMethod == null) {
                try {
                    this.chatLineComponentMethod = chatLineClass.getDeclaredMethod("func_151461_a", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    this.chatLineComponentMethod = chatLineClass.getDeclaredMethod("getChatComponent", new Class[0]);
                }
                this.chatLineComponentMethod.setAccessible(true);
            }
            if (this.chatScrollField == null) {
                try {
                    this.chatScrollField = GuiNewChat.class.getDeclaredField("field_146250_j");
                }
                catch (NoSuchFieldException e) {
                    this.chatScrollField = GuiNewChat.class.getDeclaredField("scrollPos");
                }
                this.chatScrollField.setAccessible(true);
            }
            if ((allLines = (List)this.chatMessagesField.get(chat)) == null || allLines.isEmpty()) {
                return null;
            }
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            int scaleFactor = scaledresolution.func_78325_e();
            float chatScale = chat.func_146244_h();
            int l = mouseX / scaleFactor - 2;
            int i1 = mouseY / scaleFactor - 27;
            l = MathHelper.func_76141_d((float)((float)l / chatScale));
            i1 = MathHelper.func_76141_d((float)((float)i1 / chatScale));
            if (l < 0 || i1 < 0) {
                return null;
            }
            int visibleLines = Math.min(chat.func_146232_i(), allLines.size());
            int maxChatWidth = MathHelper.func_76141_d((float)((float)chat.func_146228_f() / chatScale));
            if (l > maxChatWidth || i1 >= this.mc.field_71466_p.field_78288_b * visibleLines + visibleLines) {
                return null;
            }
            int scrollOffset = this.chatScrollField.getInt(chat);
            int k1 = i1 / this.mc.field_71466_p.field_78288_b + scrollOffset;
            if (k1 < 0 || k1 >= allLines.size()) {
                return null;
            }
            Object clickedChatLine = allLines.get(k1);
            IChatComponent clickedComp = (IChatComponent)this.chatLineComponentMethod.invoke(clickedChatLine, new Object[0]);
            if (clickedComp == null) {
                return null;
            }
            int textWidth = this.mc.field_71466_p.func_78256_a(clickedComp.func_150254_d());
            if (l > textWidth) {
                return null;
            }
            return clickedComp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void handleInputHover(GuiChat guiChat, int mouseX, int mouseY) {
        try {
            Field inputField;
            try {
                inputField = GuiChat.class.getDeclaredField("field_146415_a");
            }
            catch (NoSuchFieldException e) {
                inputField = GuiChat.class.getDeclaredField("inputField");
            }
            inputField.setAccessible(true);
            GuiTextField textField = (GuiTextField)inputField.get(guiChat);
            String narrationText = textField.func_146179_b();
            int textWidth = this.mc.field_71466_p.func_78256_a(narrationText);
            if (this.isMouseOver(textField.field_146209_f, textField.field_146210_g, textWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                if (!narrationText.trim().isEmpty()) {
                    if (this.lastNarratedInputText == null) {
                        this.hoverStartTimeInput = System.currentTimeMillis();
                        this.lastNarratedInputText = "";
                    } else if (this.lastNarratedInputText.isEmpty() && System.currentTimeMillis() - this.hoverStartTimeInput >= (long)this.delay) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedInputText = narrationText;
                    }
                }
            } else {
                this.lastNarratedInputText = null;
                this.hoverStartTimeInput = -1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleChatHover(int mouseX, int mouseY) {
        IChatComponent hoveredComponent = this.getChatComponentAt(mouseX, mouseY);
        HoverEvent hoverEvent = this.findHoverEvent(hoveredComponent);
        String tooltipText = null;
        if (hoverEvent != null) {
            if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
                try {
                    NBTTagCompound nbtTag;
                    ItemStack itemStack;
                    String nbtString = hoverEvent.func_150702_b().func_150260_c();
                    NBTBase nbtbase = JsonToNBT.func_150315_a((String)nbtString);
                    if (nbtbase instanceof NBTTagCompound && (itemStack = ItemStack.func_77949_a((NBTTagCompound)(nbtTag = (NBTTagCompound)nbtbase))) != null) {
                        List tooltipLines = itemStack.func_82840_a((EntityPlayer)this.mc.field_71439_g, this.mc.field_71474_y.field_82882_x);
                        StringBuilder sb = new StringBuilder();
                        String lastCleanLine = "";
                        for (String line : tooltipLines) {
                            String cleanLine = EnumChatFormatting.func_110646_a((String)line).trim();
                            if (cleanLine.isEmpty()) continue;
                            if (sb.length() > 0) {
                                if (lastCleanLine.endsWith(":")) {
                                    sb.append(" ");
                                } else {
                                    sb.append(", ");
                                }
                            }
                            sb.append(cleanLine);
                            lastCleanLine = cleanLine;
                        }
                        tooltipText = sb.toString();
                    }
                }
                catch (NBTException e) {
                    NarratorConfig.logError("[Narrator] Failed to parse NBT string for item tooltip: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (hoverEvent.func_150701_a() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
                try {
                    String statId = hoverEvent.func_150702_b().func_150260_c();
                    StatBase stat = StatList.func_151177_a((String)statId);
                    if (stat instanceof Achievement) {
                        Achievement achievement = (Achievement)stat;
                        String name = EnumChatFormatting.func_110646_a((String)achievement.func_150951_e().func_150260_c());
                        String description = EnumChatFormatting.func_110646_a((String)achievement.func_75989_e());
                        if (!name.isEmpty() && !description.isEmpty()) {
                            tooltipText = StatCollector.func_74838_a((String)"stats.tooltip.type.achievement") + ": " + name + ", " + description;
                        } else if (!name.isEmpty()) {
                            tooltipText = StatCollector.func_74838_a((String)"stats.tooltip.type.achievement") + ": " + name;
                        }
                    } else if (stat != null) {
                        String name = EnumChatFormatting.func_110646_a((String)stat.func_150951_e().func_150260_c());
                        tooltipText = StatCollector.func_74838_a((String)"stats.tooltip.type.statistic") + ": " + name;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                tooltipText = this.getTextFromComponent(hoverEvent.func_150702_b());
            }
        }
        if (tooltipText != null && !tooltipText.isEmpty()) {
            if (!tooltipText.equals(this.lastNarratedTooltipText)) {
                this.hoverStartTimeChat = System.currentTimeMillis();
                this.lastNarratedTooltipText = tooltipText;
            }
            if (this.hoverStartTimeChat != -1L && System.currentTimeMillis() - this.hoverStartTimeChat >= (long)this.delay) {
                AudioPlayer.speakAsync(this.lastNarratedTooltipText);
                this.hoverStartTimeChat = -1L;
            }
        } else {
            this.lastNarratedTooltipText = null;
            this.hoverStartTimeChat = -1L;
        }
    }

    private HoverEvent findHoverEvent(IChatComponent component) {
        HoverEvent hoverEvent;
        if (component == null) {
            return null;
        }
        ChatStyle style = component.func_150256_b();
        if (style != null && (hoverEvent = style.func_150210_i()) != null) {
            return hoverEvent;
        }
        List siblings = component.func_150253_a();
        if (siblings != null && !siblings.isEmpty()) {
            for (IChatComponent sibling : siblings) {
                HoverEvent tooltip = this.findHoverEvent(sibling);
                if (tooltip == null) continue;
                return tooltip;
            }
        }
        return null;
    }

    private IChatComponent getChatComponentAt(int mouseX, int mouseY) {
        GuiNewChat chat = this.mc.field_71456_v.func_146158_b();
        return chat.func_146236_a(mouseX, mouseY);
    }

    private String getTextFromComponent(IChatComponent component) {
        if (component == null) {
            return "";
        }
        return EnumChatFormatting.func_110646_a((String)component.func_150260_c());
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

