/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArray;
import cpw.mods.fml.client.config.GuiSelectString;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;

public class ConfigNarrator {
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private static final String UNDO_CHAR = "\u21b6";
    private static final String COMET_CHAR = "\u2604";
    int delay = NarratorConfig.configNarratorHoverDelay;
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        boolean isConfigScreen;
        if (!NarratorConfig.enableConfigListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        boolean bl = isConfigScreen = event.gui instanceof GuiConfig || event.gui instanceof GuiEditArray || event.gui instanceof GuiSelectString;
        if (isConfigScreen) {
            GuiScreen currentGui = event.gui;
            String hoveredElement = null;
            int mouseX = event.mouseX;
            int mouseY = event.mouseY;
            try {
                Field listField;
                Field buttonListField;
                int title1Y;
                int title1Width;
                int title1X;
                String title1Text = null;
                String title2Text = null;
                String title3Text = null;
                Field titleField = this.findFieldInHierarchy(currentGui.getClass(), "title");
                Field title2Field = this.findFieldInHierarchy(currentGui.getClass(), "titleLine2");
                Field title3Field = this.findFieldInHierarchy(currentGui.getClass(), "titleLine3");
                if (titleField != null) {
                    titleField.setAccessible(true);
                    title1Text = (String)titleField.get(currentGui);
                }
                if (title2Field != null) {
                    title2Field.setAccessible(true);
                    title2Text = (String)title2Field.get(currentGui);
                }
                if (title3Field != null) {
                    title3Field.setAccessible(true);
                    title3Text = (String)title3Field.get(currentGui);
                }
                int elipsisWidth = this.mc.field_71466_p.func_78256_a("...");
                if (title3Text != null && !title3Text.isEmpty()) {
                    int title3Y;
                    int title3Width;
                    int title3X;
                    String displayedTitle3 = title3Text;
                    if (this.mc.field_71466_p.func_78256_a(displayedTitle3) > currentGui.field_146294_l - 6) {
                        displayedTitle3 = this.mc.field_71466_p.func_78269_a(displayedTitle3, currentGui.field_146294_l - 6 - elipsisWidth).trim() + "...";
                    }
                    if (this.isMouseOver(title3X = currentGui.field_146294_l / 2 - (title3Width = this.mc.field_71466_p.func_78256_a(displayedTitle3)) / 2 - 1, title3Y = 27, title3Width, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        hoveredElement = "config_title_3";
                    }
                }
                if (title2Text != null && !title2Text.isEmpty() && hoveredElement == null) {
                    int title2Y;
                    int title2Width;
                    int title2X;
                    String displayedTitle2 = title2Text;
                    if (this.mc.field_71466_p.func_78256_a(displayedTitle2) > currentGui.field_146294_l - 6) {
                        displayedTitle2 = this.mc.field_71466_p.func_78269_a(displayedTitle2, currentGui.field_146294_l - 6 - elipsisWidth).trim() + "...";
                    }
                    if (this.isMouseOver(title2X = currentGui.field_146294_l / 2 - (title2Width = this.mc.field_71466_p.func_78256_a(displayedTitle2)) / 2 - 1, title2Y = 17, title2Width, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                        hoveredElement = "config_title_2";
                    }
                }
                if (title1Text != null && !title1Text.isEmpty() && hoveredElement == null && this.isMouseOver(title1X = currentGui.field_146294_l / 2 - (title1Width = this.mc.field_71466_p.func_78256_a(title1Text)) / 2 - 1, title1Y = 7, title1Width, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                    hoveredElement = "config_title_1";
                }
                if (hoveredElement == null && (buttonListField = this.findFieldInHierarchy(GuiScreen.class, "buttonList", "field_146292_n")) != null) {
                    buttonListField.setAccessible(true);
                    List buttonList = (List)buttonListField.get(currentGui);
                    if (buttonList != null) {
                        for (GuiButton button : buttonList) {
                            if (!this.isMouseOver(button, mouseX, mouseY)) continue;
                            hoveredElement = button;
                            break;
                        }
                    }
                }
                if (hoveredElement == null && (listField = this.findFieldInHierarchy(currentGui.getClass(), "entryList", "entriesList")) != null) {
                    Method getIndexMethod;
                    listField.setAccessible(true);
                    Object entryList = listField.get(currentGui);
                    if (entryList != null && (getIndexMethod = this.findMethodInHierarchy(entryList.getClass(), "func_148124_c", Integer.TYPE, Integer.TYPE)) != null) {
                        Field entriesField;
                        getIndexMethod.setAccessible(true);
                        int slotIndex = (Integer)getIndexMethod.invoke(entryList, mouseX, mouseY);
                        if (slotIndex >= 0 && (entriesField = this.findFieldInHierarchy(entryList.getClass(), "listEntries")) != null) {
                            entriesField.setAccessible(true);
                            List entries = (List)entriesField.get(entryList);
                            if (slotIndex < entries.size()) {
                                hoveredElement = entries.get(slotIndex);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                NarratorConfig.logError("[Narrator] Failed to access config elements: " + e.getMessage());
                e.printStackTrace();
            }
            this.narrateElement(hoveredElement, mouseX, mouseY);
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private Field findFieldInHierarchy(Class<?> clazz, String ... possibleFieldNames) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            for (String fieldName : possibleFieldNames) {
                try {
                    return current.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
        }
        return null;
    }

    private Method findMethodInHierarchy(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    private void narrateElement(Object hoveredElement, int mouseX, int mouseY) {
        if (!Objects.equals(hoveredElement, this.currentHoveredElement)) {
            this.currentHoveredElement = hoveredElement;
            this.hoverStartTime = System.currentTimeMillis();
            this.lastNarratedText = null;
        }
        if (hoveredElement == null || System.currentTimeMillis() - this.hoverStartTime <= (long)this.delay) {
            return;
        }
        String narrationText = null;
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (hoveredElement instanceof GuiButton) {
            narrationText = this.getNarrationForButton((GuiButton)hoveredElement);
        } else if (hoveredElement instanceof GuiConfigEntries.IConfigEntry) {
            narrationText = this.getNarrationForConfigEntry((GuiConfigEntries.IConfigEntry)hoveredElement, mouseX, mouseY);
        } else {
            String entryClassName = hoveredElement.getClass().getName();
            if (entryClassName.contains("GuiEditArrayEntries$")) {
                narrationText = this.getNarrationForArrayEntry(hoveredElement, mouseX, mouseY);
            } else if (entryClassName.contains("GuiSelectStringEntries$")) {
                narrationText = this.getNarrationForSelectStringEntry(hoveredElement);
            }
        }
        if (narrationText == null && hoveredElement instanceof String && ((String)hoveredElement).startsWith("config_title_")) {
            boolean title3Exists = this.getTitleText(guiScreen, "titleLine3") != null;
            boolean title2Exists = this.getTitleText(guiScreen, "titleLine2") != null;
            String lastTitleElement = "config_title_1";
            if (title3Exists) {
                lastTitleElement = "config_title_3";
            } else if (title2Exists) {
                lastTitleElement = "config_title_2";
            }
            String titleFieldName = null;
            String currentTitleText = null;
            if ("config_title_3".equals(hoveredElement)) {
                String tooltip;
                titleFieldName = "titleLine3";
                if (lastTitleElement.equals("config_title_3") && (tooltip = this.getTooltip(guiScreen)) != null && !tooltip.isEmpty()) {
                    narrationText = tooltip;
                }
                currentTitleText = this.getTitleText(guiScreen, titleFieldName);
            } else if ("config_title_2".equals(hoveredElement)) {
                String tooltip;
                titleFieldName = "titleLine2";
                if (lastTitleElement.equals("config_title_2") && (tooltip = this.getTooltip(guiScreen)) != null && !tooltip.isEmpty()) {
                    narrationText = tooltip;
                }
                currentTitleText = this.getTitleText(guiScreen, titleFieldName);
            } else if ("config_title_1".equals(hoveredElement)) {
                String tooltip;
                titleFieldName = "title";
                if (lastTitleElement.equals("config_title_1") && (tooltip = this.getTooltip(guiScreen)) != null && !tooltip.isEmpty()) {
                    narrationText = tooltip;
                }
                currentTitleText = this.getTitleText(guiScreen, titleFieldName);
            }
            if (narrationText == null && currentTitleText != null) {
                narrationText = currentTitleText;
            }
        }
        if (narrationText != null && !narrationText.trim().isEmpty()) {
            String cleanedText = EnumChatFormatting.func_110646_a((String)narrationText);
            if (this.lastNarratedText == null) {
                AudioPlayer.speakAsync(cleanedText);
                this.lastNarratedText = cleanedText;
            }
        }
    }

    private String getTitleText(GuiScreen guiScreen, String fieldName) {
        if (guiScreen == null) {
            return null;
        }
        try {
            Field titleField = this.findFieldInHierarchy(guiScreen.getClass(), fieldName);
            if (titleField != null) {
                titleField.setAccessible(true);
                String text = (String)titleField.get(guiScreen);
                return text != null && !text.isEmpty() ? text : null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getTooltip(GuiScreen guiScreen) {
        try {
            Field tooltipField = this.findFieldInHierarchy(guiScreen.getClass(), "toolTip");
            if (tooltipField != null) {
                tooltipField.setAccessible(true);
                Object tooltipObj = tooltipField.get(guiScreen);
                if (tooltipObj instanceof List) {
                    List lines = (List)tooltipObj;
                    StringBuilder sb = new StringBuilder();
                    for (Object line : lines) {
                        sb.append(line.toString()).append(" ");
                    }
                    return sb.toString().trim();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getNarrationForSelectStringEntry(Object entry) {
        try {
            Field valueEntryField = this.findFieldInHierarchy(entry.getClass(), "value");
            if (valueEntryField != null) {
                valueEntryField.setAccessible(true);
                Object mapEntry = valueEntryField.get(entry);
                Method getValueMethod = this.findMethodInHierarchy(mapEntry.getClass(), "getValue", new Class[0]);
                if (getValueMethod != null) {
                    getValueMethod.setAccessible(true);
                    Object result = getValueMethod.invoke(mapEntry, new Object[0]);
                    if (result instanceof String) {
                        return (String)result;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getNarrationForArrayEntry(Object entry, int mouseX, int mouseY) {
        String value;
        List<GuiButton> buttons = this.findButtonsInEntry(entry);
        for (GuiButton button : buttons) {
            if (!this.isMouseOver(button, mouseX, mouseY)) continue;
            if ("+".equals(this.getNarrationForButton(button))) {
                return StatCollector.func_74838_a((String)"fml.configgui.tooltip.addNewEntryAbove");
            }
            if (!"x".equals(this.getNarrationForButton(button))) continue;
            return StatCollector.func_74838_a((String)"fml.configgui.tooltip.removeEntry");
        }
        GuiTextField textField = this.findTextFieldInEntry(entry);
        if (textField != null && this.isMouseOver(textField, mouseX, mouseY) && (value = textField.func_146179_b()) != null && !value.isEmpty()) {
            return value;
        }
        Field valueField = this.findFieldInHierarchy(entry.getClass(), "value", "entryValue");
        if (valueField != null) {
            try {
                valueField.setAccessible(true);
                Object value2 = valueField.get(entry);
                if (value2 != null) {
                    String narration = value2.toString();
                    if (narration.length() > 50) {
                        narration = narration.substring(0, 50) + "...";
                    }
                    return EnumChatFormatting.func_110646_a((String)narration);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (entry.getClass().getSimpleName().equals("NewEntry")) {
            return StatCollector.func_74838_a((String)"fml.configgui.tooltip.add");
        }
        return null;
    }

    private String getNarrationForConfigEntry(GuiConfigEntries.IConfigEntry entry, int mouseX, int mouseY) {
        String value;
        List<GuiButton> buttons = this.findButtonsInEntry(entry);
        for (GuiButton button : buttons) {
            String buttonText;
            if (!this.isMouseOver(button, mouseX, mouseY) || (buttonText = this.getButtonText(button)) == null) continue;
            String cleanedText = EnumChatFormatting.func_110646_a((String)buttonText);
            if (cleanedText.equals(UNDO_CHAR)) {
                return StatCollector.func_74838_a((String)"fml.configgui.tooltip.undoChanges");
            }
            if (!cleanedText.equals(COMET_CHAR)) continue;
            return StatCollector.func_74838_a((String)"fml.configgui.tooltip.resetToDefault");
        }
        for (GuiButton button : buttons) {
            String tooltip;
            if (!this.isMouseOver(button, mouseX, mouseY)) continue;
            if (entry.getLabelWidth() == 0 && (tooltip = this.getNarrationFromTooltip(entry)) != null && !tooltip.isEmpty()) {
                return tooltip;
            }
            return this.getNarrationForButton(button);
        }
        GuiTextField textField = this.findTextFieldInEntry(entry);
        if (textField != null && this.isMouseOver(textField, mouseX, mouseY) && (value = textField.func_146179_b()) != null && !value.isEmpty()) {
            return value;
        }
        String tooltip = this.getNarrationFromTooltip(entry);
        if (tooltip != null && !tooltip.isEmpty()) {
            return tooltip;
        }
        return this.getNarrationFromName(entry);
    }

    private String getButtonText(GuiButton button) {
        try {
            Field displayStringField = this.findFieldInHierarchy(GuiButton.class, "displayString", "field_146126_j");
            if (displayStringField != null) {
                displayStringField.setAccessible(true);
                return (String)displayStringField.get(button);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getNarrationForButton(GuiButton button) {
        String buttonText = this.getButtonText(button);
        if (buttonText == null || buttonText.isEmpty()) {
            return null;
        }
        String trimmedText = buttonText.trim();
        if (!(this.mc.field_71462_r instanceof GuiSelectString) && !(this.mc.field_71462_r instanceof GuiEditArray)) {
            if (trimmedText.equals(StatCollector.func_74838_a((String)"fml.configgui.tooltip.undoChanges"))) {
                return StatCollector.func_74838_a((String)"fml.configgui.tooltip.undoChanges") + ". " + StatCollector.func_74838_a((String)"fml.configgui.tooltip.undoAll");
            }
            if (trimmedText.equals(StatCollector.func_74838_a((String)"fml.configgui.tooltip.resetToDefault"))) {
                return StatCollector.func_74838_a((String)"fml.configgui.tooltip.resetToDefault") + ". " + StatCollector.func_74838_a((String)"fml.configgui.tooltip.resetAll");
            }
            if (trimmedText.equals(StatCollector.func_74838_a((String)"fml.configgui.applyGlobally"))) {
                return StatCollector.func_74838_a((String)"fml.configgui.applyGlobally") + ". " + StatCollector.func_74838_a((String)"fml.configgui.tooltip.applyGlobally");
            }
        }
        return EnumChatFormatting.func_110646_a((String)trimmedText);
    }

    private List<GuiButton> findButtonsInEntry(Object entry) {
        ArrayList<GuiButton> buttons = new ArrayList<GuiButton>();
        for (Class<?> clazz = entry.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!GuiButton.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    Object obj = field.get(entry);
                    if (!(obj instanceof GuiButton)) continue;
                    buttons.add((GuiButton)obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return buttons;
    }

    private String getNarrationFromTooltip(GuiConfigEntries.IConfigEntry entry) {
        Field tooltipField = this.findFieldInHierarchy(entry.getClass(), "toolTip");
        if (tooltipField != null) {
            try {
                tooltipField.setAccessible(true);
                List tooltipLines = (List)tooltipField.get(entry);
                if (tooltipLines != null && !tooltipLines.isEmpty()) {
                    StringBuilder tooltipBuilder = new StringBuilder();
                    for (String line : tooltipLines) {
                        tooltipBuilder.append(line).append(" ");
                    }
                    return tooltipBuilder.toString().trim();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String getNarrationFromName(GuiConfigEntries.IConfigEntry entry) {
        try {
            Field nameField = this.findFieldInHierarchy(entry.getClass(), "name");
            if (nameField != null) {
                nameField.setAccessible(true);
                String name = (String)nameField.get(entry);
                if (name != null && !name.isEmpty()) {
                    return StatCollector.func_74838_a((String)name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private GuiTextField findTextFieldInEntry(Object entry) {
        for (Class<?> clazz = entry.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!GuiTextField.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    Object obj = field.get(entry);
                    if (!(obj instanceof GuiTextField)) continue;
                    return (GuiTextField)obj;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private boolean isMouseOver(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.field_146128_h && mouseX <= button.field_146128_h + button.field_146120_f && mouseY >= button.field_146129_i && mouseY <= button.field_146129_i + button.field_146121_g;
    }

    private boolean isMouseOver(GuiTextField textField, int mouseX, int mouseY) {
        return mouseX >= textField.field_146209_f && mouseX <= textField.field_146209_f + textField.field_146218_h && mouseY >= textField.field_146210_g && mouseY <= textField.field_146210_g + textField.field_146219_i;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

