/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;

public class ControlsNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    int delay = NarratorConfig.controlsNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableControlsListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.gui instanceof GuiControls) {
            try {
                GuiListExtended keyBindingList;
                Field keyBindingListField;
                String title;
                GuiControls guiScreen = (GuiControls)event.gui;
                String hoveredElement = null;
                Field titleField = this.findField(GuiControls.class, "screenTitle", "field_146495_a");
                if (titleField != null && this.isMouseOverTitle(guiScreen, title = (String)titleField.get(guiScreen), event.mouseX, event.mouseY)) {
                    hoveredElement = title;
                }
                if (hoveredElement == null && (keyBindingListField = this.findField(GuiControls.class, "keyBindingList", "field_146494_r")) != null && (keyBindingList = (GuiListExtended)keyBindingListField.get(guiScreen)) != null) {
                    Method getSizeMethod = this.findMethod(GuiSlot.class, new String[]{"getSize", "func_148127_b"}, new Class[0]);
                    Method getListEntryMethod = this.findMethod(GuiListExtended.class, new String[]{"getListEntry", "func_148180_b"}, Integer.TYPE);
                    if (getSizeMethod != null && getListEntryMethod != null) {
                        int size = (Integer)getSizeMethod.invoke((Object)keyBindingList, new Object[0]);
                        float scrollDistance = ((Float)this.findField(GuiSlot.class, "amountScrolled", "field_148169_q").get(keyBindingList)).floatValue();
                        int slotHeight = (Integer)this.findField(GuiSlot.class, "slotHeight", "field_148149_f").get(keyBindingList);
                        int top = (Integer)this.findField(GuiSlot.class, "top", "field_148153_b").get(keyBindingList);
                        int bottom = (Integer)this.findField(GuiSlot.class, "bottom", "field_148154_c").get(keyBindingList);
                        for (int i = 0; i < size; ++i) {
                            String keyDesc;
                            int descWidth;
                            int descX;
                            String categoryName;
                            int titleWidth;
                            int titleX;
                            GuiListExtended.IGuiListEntry entry = (GuiListExtended.IGuiListEntry)getListEntryMethod.invoke((Object)keyBindingList, i);
                            int itemY = keyBindingList.field_148153_b + 7 - (int)scrollDistance + i * slotHeight;
                            if (event.mouseY < top || event.mouseY > bottom || itemY + slotHeight <= top || itemY >= bottom) continue;
                            Field categoryNameField = this.findField(entry.getClass(), "labelText", "field_148285_b");
                            if (categoryNameField != null && this.isMouseOver(event.mouseX, event.mouseY, titleX = guiScreen.field_146294_l / 2 - (titleWidth = this.mc.field_71466_p.func_78256_a(StatCollector.func_74838_a((String)(categoryName = (String)categoryNameField.get(entry))))) / 2 - 1, itemY + 2, titleWidth, this.mc.field_71466_p.field_78288_b)) {
                                hoveredElement = categoryName;
                                break;
                            }
                            Field keyDescField = this.findField(entry.getClass(), "field_148283_c", "field_148283_c");
                            if (keyDescField != null && this.isMouseOver(event.mouseX, event.mouseY, descX = guiScreen.field_146294_l / 2 - 160, itemY, descWidth = this.mc.field_71466_p.func_78256_a(StatCollector.func_74838_a((String)(keyDesc = (String)keyDescField.get(entry)))), this.mc.field_71466_p.field_78288_b)) {
                                hoveredElement = keyDesc;
                                break;
                            }
                            for (Field field : entry.getClass().getDeclaredFields()) {
                                if (!field.getType().equals(GuiButton.class)) continue;
                                field.setAccessible(true);
                                GuiButton button = (GuiButton)field.get(entry);
                                if (button == null || !this.isMouseOver(button, event.mouseX, event.mouseY)) continue;
                                hoveredElement = button;
                                break;
                            }
                            if (hoveredElement != null) break;
                        }
                    }
                }
                this.narrateHoveredElement(hoveredElement);
            }
            catch (Exception e) {
                NarratorConfig.logError("[Narrator] Error accessing elements: " + e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private void narrateHoveredElement(Object hoveredElement) {
        if (hoveredElement != null) {
            if (hoveredElement != this.currentHoveredElement) {
                this.currentHoveredElement = hoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                String cleanedText;
                String narratedText = null;
                if (hoveredElement instanceof GuiButton) {
                    try {
                        Field displayStringField = this.findField(GuiButton.class, "displayString", "field_146126_j");
                        if (displayStringField != null) {
                            narratedText = (String)displayStringField.get(hoveredElement);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (hoveredElement instanceof String) {
                    narratedText = (String)hoveredElement;
                }
                if (narratedText != null && !(cleanedText = EnumChatFormatting.func_110646_a((String)narratedText).trim()).isEmpty() && this.lastNarratedText == null) {
                    AudioPlayer.speakAsync(cleanedText);
                    this.lastNarratedText = cleanedText;
                }
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private boolean isMouseOver(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.field_146128_h && mouseX <= button.field_146128_h + button.field_146120_f - 1 && mouseY >= button.field_146129_i && mouseY <= button.field_146129_i + button.field_146121_g - 1;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private boolean isMouseOverTitle(GuiControls gui, String title, int mouseX, int mouseY) {
        String titleText = I18n.func_135052_a((String)title, (Object[])new Object[0]);
        FontRenderer fontRenderer = this.findFontRenderer((GuiScreen)gui);
        if (fontRenderer == null) {
            return false;
        }
        int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
        int titleHeight = this.mc.field_71466_p.field_78288_b;
        int titleX = (gui.field_146294_l - titleWidth) / 2 - 1;
        int titleY = 7;
        return mouseX >= titleX && mouseX <= titleX + titleWidth && mouseY >= titleY && mouseY <= titleY + titleHeight;
    }

    private FontRenderer findFontRenderer(GuiScreen screen) {
        try {
            Field fontRendererField = this.findField(GuiScreen.class, "fontRendererObj", "field_146289_q");
            if (fontRendererField != null) {
                return (FontRenderer)fontRendererField.get(screen);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Field field = currentClass.getDeclaredField(deobfName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                try {
                    Field srgField = currentClass.getDeclaredField(srgName);
                    srgField.setAccessible(true);
                    return srgField;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private Method findMethod(Class<?> clazz, String[] names, Class<?> ... parameterTypes) {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (String name : names) {
                try {
                    Method method = currentClass.getDeclaredMethod(name, parameterTypes);
                    method.setAccessible(true);
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return null;
    }
}

