/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class CreativeTabNarrator {
    private long hoverStartTime = -1L;
    private String lastNarratedElementText = null;
    private boolean hasBeenNarrated = false;
    int delay = NarratorConfig.creativeTabNarratorHoverDelay;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!NarratorConfig.enableCreativeTabListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiScreen currentScreen = mc.field_71462_r;
            if (currentScreen instanceof GuiContainerCreative) {
                try {
                    CreativeTabs currentHoveredTab;
                    GuiContainerCreative guiScreen = (GuiContainerCreative)currentScreen;
                    int mouseX = Mouse.getX() * guiScreen.field_146294_l / mc.field_71443_c;
                    int mouseY = guiScreen.field_146295_m - Mouse.getY() * guiScreen.field_146295_m / mc.field_71440_d - 1;
                    String currentHoveredElementText = this.getHoveredPageTitle(mouseX, mouseY, guiScreen);
                    if (currentHoveredElementText == null && (currentHoveredTab = this.getHoveredTab(mouseX, mouseY, guiScreen)) != null) {
                        currentHoveredElementText = I18n.func_135052_a((String)currentHoveredTab.func_78024_c(), (Object[])new Object[0]);
                    }
                    if (currentHoveredElementText == null) {
                        if (this.lastNarratedElementText != null) {
                            this.lastNarratedElementText = null;
                            this.hoverStartTime = -1L;
                            this.hasBeenNarrated = false;
                        }
                    } else {
                        if (!currentHoveredElementText.equals(this.lastNarratedElementText)) {
                            this.lastNarratedElementText = currentHoveredElementText;
                            this.hoverStartTime = System.currentTimeMillis();
                            this.hasBeenNarrated = false;
                        }
                        if (!this.hasBeenNarrated && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                            AudioPlayer.speakAsync(currentHoveredElementText);
                            this.hasBeenNarrated = true;
                        }
                    }
                }
                catch (Exception e) {
                    NarratorConfig.logError("[Narrator] Failed to get creative tab name or title name on hover: " + e.getMessage());
                }
            } else {
                this.lastNarratedElementText = null;
                this.hoverStartTime = -1L;
                this.hasBeenNarrated = false;
            }
        }
    }

    private CreativeTabs getHoveredTab(int mouseX, int mouseY, GuiContainerCreative gui) {
        try {
            int yPos;
            int searchTabY;
            int tabPage;
            Field guiLeftField = this.findField(GuiContainer.class, "field_147003_i", "guiLeft");
            Field guiTopField = this.findField(GuiContainer.class, "field_147009_r", "guiTop");
            Field xSizeField = this.findField(GuiContainer.class, "field_146999_f", "xSize");
            Field ySizeField = this.findField(GuiContainer.class, "field_147000_g", "ySize");
            Field tabPageField = this.findField(GuiContainerCreative.class, "tabPage", "tabPage");
            int n = tabPage = tabPageField != null ? tabPageField.getInt(null) : 0;
            if (guiLeftField == null || guiTopField == null || xSizeField == null || ySizeField == null) {
                return null;
            }
            int xSize = xSizeField.getInt(gui);
            int ySize = ySizeField.getInt(gui);
            int xPos = guiLeftField.getInt(gui);
            int searchTabX = xPos + xSize - 24;
            if (this.isMouseOver(mouseX, mouseY, searchTabX, searchTabY = (yPos = guiTopField.getInt(gui)) - 30, 24, 28)) {
                return CreativeTabs.field_78027_g;
            }
            int inventoryTabX = xPos + xSize - 24;
            int inventoryTabY = yPos + ySize + 2;
            if (this.isMouseOver(mouseX, mouseY, inventoryTabX, inventoryTabY, 24, 28)) {
                return CreativeTabs.field_78036_m;
            }
            if (tabPage == 0) {
                int startIndex = 0;
                int endIndex = Math.min(12, CreativeTabs.field_78032_a.length);
                for (int i = startIndex; i < endIndex; ++i) {
                    int tabY;
                    int tabX;
                    CreativeTabs tab = CreativeTabs.field_78032_a[i];
                    if (tab == null || tab == CreativeTabs.field_78027_g || tab == CreativeTabs.field_78036_m) continue;
                    if (i < 6) {
                        tabX = xPos + i * 29 + 2;
                        tabY = yPos - 30;
                    } else {
                        tabX = xPos + (i - 6) * 29 + 2;
                        tabY = yPos + ySize + 2;
                    }
                    if (!this.isMouseOver(mouseX, mouseY, tabX, tabY, 24, 28)) continue;
                    return tab;
                }
            } else {
                int startIndex = tabPage * 10 + 2;
                int endIndex = Math.min(startIndex + 10, CreativeTabs.field_78032_a.length);
                for (int i = startIndex; i < endIndex; ++i) {
                    int tabY;
                    int tabX;
                    int relativeIndex;
                    CreativeTabs tab = CreativeTabs.field_78032_a[i];
                    if (tab == null || tab == CreativeTabs.field_78027_g || tab == CreativeTabs.field_78036_m || !((relativeIndex = i - startIndex) < 5 ? this.isMouseOver(mouseX, mouseY, tabX = xPos + relativeIndex * 29 + 2, tabY = yPos - 30, 24, 28) : this.isMouseOver(mouseX, mouseY, tabX = xPos + (relativeIndex - 5) * 29 + 2, tabY = yPos + ySize + 2, 24, 28))) continue;
                    return tab;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getHoveredPageTitle(int mouseX, int mouseY, GuiContainerCreative gui) {
        try {
            int titleHeight;
            Field guiLeftField = this.findField(GuiContainer.class, "field_147003_i", "guiLeft");
            Field guiTopField = this.findField(GuiContainer.class, "field_147009_r", "guiTop");
            Field selectedTabIndexField = this.findField(GuiContainerCreative.class, "field_147058_w", "selectedTabIndex");
            if (guiLeftField == null || guiTopField == null || selectedTabIndexField == null) {
                return null;
            }
            int xPos = guiLeftField.getInt(gui);
            int yPos = guiTopField.getInt(gui);
            int selectedTabIndex = selectedTabIndexField.getInt(gui);
            CreativeTabs selectedTab = CreativeTabs.field_78032_a[selectedTabIndex];
            if (selectedTab == CreativeTabs.field_78036_m) {
                return null;
            }
            int titleX = xPos + 7;
            int titleY = yPos + 5;
            String title = I18n.func_135052_a((String)selectedTab.func_78024_c(), (Object[])new Object[0]);
            int titleWidth = gui.field_146297_k.field_71466_p.func_78256_a(title);
            if (this.isMouseOver(mouseX, mouseY, titleX, titleY, titleWidth, titleHeight = gui.field_146297_k.field_71466_p.field_78288_b)) {
                return title;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String srgName, String obfName) {
        try {
            Field field = clazz.getDeclaredField(srgName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = clazz.getDeclaredField(obfName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
                Class<?> superClass = clazz.getSuperclass();
                if (superClass != null) {
                    return this.findField(superClass, srgName, obfName);
                }
                return null;
            }
        }
    }
}

