/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;

public class DeathScreenNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Map<String, Long> hoverStartTimes = new HashMap<String, Long>();
    private final Map<String, String> lastNarratedTexts = new HashMap<String, String>();
    private final int delay = NarratorConfig.deathScreenNarratorHoverDelay;
    private static Field buttonListField;

    private void setupButtonListField() throws NoSuchFieldException {
        if (buttonListField == null) {
            try {
                buttonListField = GuiScreen.class.getDeclaredField("field_146292_n");
            }
            catch (NoSuchFieldException e) {
                buttonListField = GuiScreen.class.getDeclaredField("buttonList");
            }
            buttonListField.setAccessible(true);
        }
    }

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) throws NoSuchFieldException {
        if (!NarratorConfig.enableDeathScreenListener || !KeybindHandler.isNarratorEnabled()) {
            this.hoverStartTimes.clear();
            this.lastNarratedTexts.clear();
            return;
        }
        if (event.gui instanceof GuiGameOver) {
            GuiGameOver guiGameOver = (GuiGameOver)event.gui;
            this.setupButtonListField();
            int mouseX = event.mouseX;
            int mouseY = event.mouseY;
            HoverResult hoveredResult = null;
            boolean isHardcore = this.mc.field_71441_e.func_72912_H().func_76093_s();
            String titleText = isHardcore ? I18n.func_135052_a((String)"deathScreen.title.hardcore", (Object[])new Object[0]) : I18n.func_135052_a((String)"deathScreen.title", (Object[])new Object[0]);
            int titleY = 58;
            int textWidthUnscaled = this.mc.field_71466_p.func_78256_a(titleText);
            int boundingBoxWidth = (int)((float)textWidthUnscaled * 2.0f + 2.0f);
            int boundingBoxHeight = (int)((float)this.mc.field_71466_p.field_78288_b * 2.0f + 1.0f);
            int boundingBoxXStart = guiGameOver.field_146294_l / 2 - boundingBoxWidth / 2 - 2;
            if (this.isMouseOver(boundingBoxXStart, titleY, boundingBoxWidth, boundingBoxHeight, mouseX, mouseY)) {
                hoveredResult = new HoverResult("DeathTitle", titleText);
            }
            if (hoveredResult == null) {
                int scoreBoxHeight;
                String scoreBaseText = I18n.func_135052_a((String)"deathScreen.score", (Object[])new Object[0]);
                String scoreValue = String.valueOf(this.mc.field_71439_g.func_71037_bA());
                String scoreText = scoreBaseText + ": " + scoreValue;
                int scoreY = 99;
                String fullScoreText = scoreBaseText + ": " + EnumChatFormatting.YELLOW + scoreValue;
                int scoreTextWidth = this.mc.field_71466_p.func_78256_a(fullScoreText) + 1;
                int scoreBoxXStart = guiGameOver.field_146294_l / 2 - scoreTextWidth / 2 - 1;
                if (this.isMouseOver(scoreBoxXStart, scoreY, scoreTextWidth, scoreBoxHeight = this.mc.field_71466_p.field_78288_b + 1, mouseX, mouseY)) {
                    hoveredResult = new HoverResult("Score", scoreText);
                }
            }
            if (hoveredResult == null && isHardcore) {
                int hardcoreBoxHeight;
                String hardcoreText = I18n.func_135052_a((String)"deathScreen.hardcoreInfo", (Object[])new Object[0]);
                int hardcoreY = 143;
                int hardcoreTextWidth = this.mc.field_71466_p.func_78256_a(hardcoreText) + 1;
                int hardcoreBoxXStart = guiGameOver.field_146294_l / 2 - hardcoreTextWidth / 2 - 1;
                if (this.isMouseOver(hardcoreBoxXStart, hardcoreY, hardcoreTextWidth, hardcoreBoxHeight = this.mc.field_71466_p.field_78288_b + 1, mouseX, mouseY)) {
                    hoveredResult = new HoverResult("HardcoreInfo", hardcoreText);
                }
            }
            if (hoveredResult != null) {
                this.handleNarrationState(hoveredResult.narrationKey, hoveredResult.narrationText);
            } else {
                this.handleNarrationState(null, null);
            }
        }
    }

    private void handleNarrationState(String key, String text) {
        if (key != null && text != null && text.length() >= 3) {
            if (this.lastNarratedTexts.containsKey(key) && Objects.equals(this.lastNarratedTexts.get(key), text)) {
                return;
            }
            if (!this.hoverStartTimes.containsKey(key)) {
                this.hoverStartTimes.put(key, System.currentTimeMillis());
                this.lastNarratedTexts.clear();
            } else if (System.currentTimeMillis() - this.hoverStartTimes.get(key) >= (long)this.delay) {
                AudioPlayer.speakAsync(text);
                this.lastNarratedTexts.put(key, text);
            }
        } else {
            this.hoverStartTimes.clear();
            this.lastNarratedTexts.clear();
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private static class HoverResult {
        public final String narrationKey;
        public final String narrationText;

        public HoverResult(String key, String text) {
            this.narrationKey = key;
            this.narrationText = text;
        }
    }
}

