/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class DebugScreenNarrator {
    private String lastNarratedText = null;
    private String currentHoveredId = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.debugScreenNarratorHoverDelay;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        List<String> right;
        if (!NarratorConfig.enableDebugScreenListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChat)) {
            this.resetHover();
            return;
        }
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!mc.field_71474_y.field_74330_P) {
            this.resetHover();
            return;
        }
        int mouseX = Mouse.getX() * event.resolution.func_78326_a() / mc.field_71443_c;
        int mouseY = event.resolution.func_78328_b() - Mouse.getY() * event.resolution.func_78328_b() / mc.field_71440_d - 1;
        List<String> left = this.generateLeftDebugStrings(mc);
        String hoveredLine = this.getHoveredLine(left, right = this.generateRightDebugStrings(mc), mc, mouseX, mouseY, event.resolution.func_78326_a());
        if (hoveredLine != null) {
            String narrationText = hoveredLine.trim();
            String hoverId = narrationText.replaceAll("\\d+", "").replaceAll("\\s+", "");
            if (!hoverId.equals(this.currentHoveredId)) {
                this.currentHoveredId = hoverId;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay && this.lastNarratedText == null) {
                AudioPlayer.speakAsync(narrationText);
                this.lastNarratedText = hoverId;
            }
        } else {
            this.resetHover();
        }
    }

    private void resetHover() {
        this.currentHoveredId = null;
        this.hoverStartTime = -1L;
        this.lastNarratedText = null;
    }

    private String getHoveredLine(List<String> left, List<String> right, Minecraft mc, int mouseX, int mouseY, int screenWidth) {
        int height;
        String line;
        int i;
        FontRenderer fontRenderer = mc.field_71466_p;
        int lineHeight = fontRenderer.field_78288_b + 1;
        for (i = 0; i < left.size(); ++i) {
            int width;
            int y;
            int x;
            line = left.get(i);
            if (line == null || !this.isMouseOver(x = 1, y = 2 + i * lineHeight, width = fontRenderer.func_78256_a(line), height = fontRenderer.field_78288_b, mouseX, mouseY)) continue;
            return line;
        }
        for (i = 0; i < right.size(); ++i) {
            int y;
            int width;
            int x;
            line = right.get(i);
            if (line == null || !this.isMouseOver(x = screenWidth - 11 - (width = fontRenderer.func_78256_a(line)), y = 2 + i * lineHeight, width, height = fontRenderer.field_78288_b, mouseX, mouseY)) continue;
            return line;
        }
        return null;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private List<String> generateLeftDebugStrings(Minecraft mc) {
        EntityClientPlayerMP player = mc.field_71439_g;
        WorldClient world = mc.field_71441_e;
        ArrayList<String> list = new ArrayList<String>();
        list.add("Minecraft 1.7.10 (" + mc.field_71426_K + ")");
        list.add(mc.func_71393_m());
        list.add(mc.func_71408_n());
        list.add(mc.func_71374_p());
        list.add(mc.func_71388_o());
        list.add(null);
        if (player != null) {
            int x = MathHelper.func_76128_c((double)player.field_70165_t);
            int y = MathHelper.func_76128_c((double)player.field_70163_u);
            int z = MathHelper.func_76128_c((double)player.field_70161_v);
            float yaw = player.field_70177_z;
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            list.add(String.format("x: %.5f (%d) // c: %d (%d)", player.field_70165_t, x, x >> 4, x & 0xF));
            list.add(String.format("y: %.3f (feet pos, %.3f eyes pos)", player.field_70121_D.field_72338_b, player.field_70163_u));
            list.add(String.format("z: %.5f (%d) // c: %d (%d)", player.field_70161_v, z, z >> 4, z & 0xF));
            list.add(String.format("f: %d (%s) / %f", heading, Direction.field_82373_c[heading], Float.valueOf(MathHelper.func_76142_g((float)yaw))));
            if (world.func_72899_e(x, y, z)) {
                Chunk chunk = world.func_72938_d(x, z);
                list.add(String.format("lc: %d b: %s bl: %d sl: %d rl: %d", chunk.func_76625_h() + 15, chunk.func_76591_a((int)(x & 0xF), (int)(z & 0xF), (WorldChunkManager)world.func_72959_q()).field_76791_y, chunk.func_76614_a(EnumSkyBlock.Block, x & 0xF, y, z & 0xF), chunk.func_76614_a(EnumSkyBlock.Sky, x & 0xF, y, z & 0xF), chunk.func_76629_c(x & 0xF, y, z & 0xF, 0)));
            } else {
                list.add(null);
            }
            list.add(String.format("ws: %.3f, fs: %.3f, g: %b, fl: %d", Float.valueOf(player.field_71075_bZ.func_75094_b()), Float.valueOf(player.field_71075_bZ.func_75093_a()), player.field_70122_E, world.func_72976_f(x, z)));
            if (mc.field_71460_t != null && mc.field_71460_t.func_147702_a()) {
                list.add(String.format("shader: %s", mc.field_71460_t.func_147706_e().func_148022_b()));
            }
        }
        return list;
    }

    private List<String> generateRightDebugStrings(Minecraft mc) {
        ArrayList<String> list = new ArrayList<String>();
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        long used = total - free;
        list.add("Used memory: " + used * 100L / max + "% (" + used / 1024L / 1024L + "MB) of " + max / 1024L / 1024L + "MB");
        list.add("Allocated memory: " + total * 100L / max + "% (" + total / 1024L / 1024L + "MB)");
        list.add(null);
        list.addAll(FMLCommonHandler.instance().getBrandings(false));
        return list;
    }
}

