/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;

public class EndPoemNarrator {
    private boolean hasNarratedPoem = false;

    @SubscribeEvent
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!NarratorConfig.enableEndPoemListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.gui instanceof GuiWinGame && !this.hasNarratedPoem) {
            this.narrateEndPoem((GuiWinGame)event.gui);
            this.hasNarratedPoem = true;
        } else if (!(event.gui instanceof GuiWinGame)) {
            this.hasNarratedPoem = false;
        }
    }

    private void narrateEndPoem(GuiWinGame gui) {
        try {
            Field poemLinesField = this.findField();
            if (poemLinesField != null) {
                String combinedText;
                poemLinesField.setAccessible(true);
                List poemLines = (List)poemLinesField.get(gui);
                if (poemLines != null && !poemLines.isEmpty() && !(combinedText = poemLines.stream().map(line -> {
                    String cleanedLine = EnumChatFormatting.func_110646_a((String)line);
                    cleanedLine = cleanedLine.replace("[C]", "").replace("=", "");
                    cleanedLine = cleanedLine.replaceAll("X{2,}", "nnnmmmnnn").trim();
                    return cleanedLine;
                }).collect(Collectors.joining(" "))).isEmpty()) {
                    AudioPlayer.speakAsync("Minecraft.    " + combinedText);
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] Failed to narrate End Poem: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Field findField() {
        for (Class currentClass = GuiWinGame.class; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField("field_146582_i");
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

