/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateFlatWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class FlatWorldNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private GuiScreen currentGuiScreen = null;
    int delay = NarratorConfig.flatWorldNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableFlatWorldListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (this.currentGuiScreen != event.gui) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
            this.currentGuiScreen = event.gui;
        }
        Object narrationResult = null;
        Object hoveredElement = null;
        if (event.gui instanceof GuiCreateFlatWorld) {
            Object[] result = this.getFlatWorldHoverText((GuiCreateFlatWorld)event.gui);
            narrationResult = result[0];
            hoveredElement = result[1];
        }
        if (hoveredElement != null) {
            String narrationText = narrationResult instanceof String[] ? String.join((CharSequence)", ", (String[])narrationResult) : (String)narrationResult;
            if (this.currentHoveredElement != hoveredElement) {
                this.currentHoveredElement = hoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                if (narrationText != null && !narrationText.equals(this.lastNarratedText)) {
                    AudioPlayer.speakAsync(narrationText);
                    this.lastNarratedText = narrationText;
                }
                this.hoverStartTime = -1L;
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private Object[] getFlatWorldHoverText(GuiCreateFlatWorld guiScreen) {
        try {
            int mouseX = Mouse.getX() * guiScreen.field_146294_l / this.mc.field_71443_c;
            int mouseY = guiScreen.field_146295_m - Mouse.getY() * guiScreen.field_146295_m / this.mc.field_71440_d;
            String titleText = StatCollector.func_74838_a((String)"createWorld.customize.flat.title");
            int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
            int titleX = (guiScreen.field_146294_l - titleWidth) / 2 - 1;
            int titleY = 8;
            if (this.isMouseOver(titleX, titleY, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{titleText, "title_flat_world"};
            }
            int tileX = guiScreen.field_146294_l / 2 - 109;
            int tileY = 32;
            String tileTitle = I18n.func_135052_a((String)"createWorld.customize.flat.tile", (Object[])new Object[0]);
            int tileWidth = this.mc.field_71466_p.func_78256_a(tileTitle);
            if (this.isMouseOver(tileX, tileY, tileWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{tileTitle, "tile_title"};
            }
            int heightX = guiScreen.field_146294_l / 2 + 76;
            int heightY = 32;
            String heightTitle = I18n.func_135052_a((String)"createWorld.customize.flat.height", (Object[])new Object[0]);
            int heightWidth = this.mc.field_71466_p.func_78256_a(heightTitle);
            if (this.isMouseOver(heightX, heightY, heightWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                return new Object[]{heightTitle, "height_title"};
            }
            Field detailsField = this.findField("createFlatWorldListSlotGui", "field_146390_s");
            if (detailsField == null) {
                return new Object[]{null, null};
            }
            detailsField.setAccessible(true);
            GuiSlot detailsObject = (GuiSlot)detailsField.get(guiScreen);
            int top = 43;
            int bottom = guiScreen.field_146295_m - 60;
            int listX = guiScreen.field_146294_l / 2 - 110;
            int listWidth = 220;
            if (mouseX >= listX && mouseX <= listX + listWidth && mouseY >= top && mouseY <= bottom) {
                Method getSlotIndex = this.findMethod(GuiSlot.class, new String[]{"func_148124_c", "getSlotIndexFromScreenCoords"}, Integer.TYPE, Integer.TYPE);
                if (getSlotIndex == null) {
                    return new Object[]{null, null};
                }
                getSlotIndex.setAccessible(true);
                int hoveredIndex = (Integer)getSlotIndex.invoke((Object)detailsObject, mouseX, mouseY);
                if (hoveredIndex >= 0) {
                    Field infoField = this.findField("theFlatGeneratorInfo", "field_146387_g");
                    if (infoField == null) {
                        return new Object[]{null, null};
                    }
                    infoField.setAccessible(true);
                    FlatGeneratorInfo info = (FlatGeneratorInfo)infoField.get(guiScreen);
                    List layers = info.func_82650_c();
                    if (hoveredIndex < layers.size()) {
                        int correctIndex = layers.size() - 1 - hoveredIndex;
                        FlatLayerInfo layerInfo = (FlatLayerInfo)layers.get(correctIndex);
                        Method getBlockMethod = this.findMethod(FlatLayerInfo.class, new String[]{"func_151536_b", "func_151536_b"}, new Class[0]);
                        if (getBlockMethod == null) {
                            return new Object[]{null, null};
                        }
                        getBlockMethod.setAccessible(true);
                        Block block = (Block)getBlockMethod.invoke((Object)layerInfo, new Object[0]);
                        Method getMetaMethod = this.findMethod(FlatLayerInfo.class, new String[]{"func_82658_c", "getFillBlockMeta"}, new Class[0]);
                        if (getMetaMethod == null) {
                            return new Object[]{null, null};
                        }
                        getMetaMethod.setAccessible(true);
                        int meta = (Integer)getMetaMethod.invoke((Object)layerInfo, new Object[0]);
                        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)block), 1, meta);
                        String blockName = itemStack.func_82833_r();
                        int count = layerInfo.func_82657_a();
                        int totalLayers = layers.size();
                        String formattedHeight = hoveredIndex == 0 ? StatCollector.func_74837_a((String)"createWorld.customize.flat.layer.top", (Object[])new Object[]{count}) : (hoveredIndex == totalLayers - 1 ? StatCollector.func_74837_a((String)"createWorld.customize.flat.layer.bottom", (Object[])new Object[]{count}) : StatCollector.func_74837_a((String)"createWorld.customize.flat.layer", (Object[])new Object[]{count}));
                        String narrationText = String.format("%s: %s", blockName, formattedHeight);
                        return new Object[]{narrationText, layerInfo};
                    }
                }
            }
            return new Object[]{null, null};
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object[]{null, null};
        }
    }

    private Field findField(String deobfName, String srgName) {
        try {
            return GuiCreateFlatWorld.class.getDeclaredField(deobfName);
        }
        catch (NoSuchFieldException e) {
            try {
                return GuiCreateFlatWorld.class.getDeclaredField(srgName);
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        }
    }

    private Method findMethod(Class<?> clazz, String[] names, Class<?> ... parameterTypes) {
        for (String name : names) {
            try {
                return clazz.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

