/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.item.ItemStack;

@SideOnly(value=Side.CLIENT)
public class HotbarNarrator {
    private int lastItemIndex = -1;
    private ItemStack lastItemStack = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.hotbarNarratorHoverDelay;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!NarratorConfig.enableHotbarListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == null || mc.field_71439_g.field_71071_by == null || mc.field_71462_r != null && !(mc.field_71462_r instanceof GuiChat)) {
                this.hoverStartTime = -1L;
                return;
            }
            int currentItemIndex = mc.field_71439_g.field_71071_by.field_70461_c;
            ItemStack currentStack = mc.field_71439_g.field_71071_by.func_70301_a(currentItemIndex);
            boolean slotChanged = currentItemIndex != this.lastItemIndex;
            boolean itemChanged = false;
            if (currentStack != null) {
                if (this.lastItemStack == null || currentStack.func_77973_b() != this.lastItemStack.func_77973_b() || !currentStack.func_82833_r().equals(this.lastItemStack.func_82833_r())) {
                    itemChanged = true;
                }
            } else if (this.lastItemStack != null) {
                itemChanged = true;
            }
            if (slotChanged || itemChanged) {
                this.lastItemIndex = currentItemIndex;
                this.lastItemStack = currentStack != null ? currentStack.func_77946_l() : null;
                this.hoverStartTime = System.currentTimeMillis();
                return;
            }
            if (currentStack != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                String itemName = currentStack.func_82833_r();
                AudioPlayer.speakAsync(itemName);
                this.hoverStartTime = -1L;
            }
        }
    }
}

