/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class HudNarrator {
    private String lastNarratedText = null;
    private Object currentHoveredElement = null;
    private long hoverStartTime = -1L;
    int delay = NarratorConfig.hudNarratorHoverDelay;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (!NarratorConfig.enableHudListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r instanceof GuiChat)) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
            return;
        }
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        String hoveredElementId = null;
        String narrationText = null;
        int mouseX = Mouse.getX() * event.resolution.func_78326_a() / mc.field_71443_c;
        int mouseY = event.resolution.func_78328_b() - Mouse.getY() * event.resolution.func_78328_b() / mc.field_71440_d - 1;
        if (BossStatus.field_82827_c != null && BossStatus.field_82826_b > 0) {
            int textHeight;
            int textWidth;
            int textY;
            String text;
            FontRenderer fontrenderer = mc.field_71466_p;
            ScaledResolution scaledresolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            int scaledWidth = scaledresolution.func_78326_a();
            int textX = scaledWidth / 2 - fontrenderer.func_78256_a(text = BossStatus.field_82827_c) / 2 - 1;
            if (this.isMouseOver(textX, textY = 1, textWidth = fontrenderer.func_78256_a(text), textHeight = fontrenderer.field_78288_b, mouseX, mouseY)) {
                hoveredElementId = "boss_bar";
                narrationText = EnumChatFormatting.func_110646_a((String)text).trim();
            }
        }
        if (mc.field_71442_b.func_78763_f() && mc.field_71439_g.field_71068_ca > 0) {
            int height;
            int width;
            int y;
            FontRenderer fontRenderer = mc.field_71466_p;
            String text = String.valueOf(mc.field_71439_g.field_71068_ca);
            int x = (event.resolution.func_78326_a() - fontRenderer.func_78256_a(text)) / 2 - 1;
            if (this.isMouseOver(x, y = event.resolution.func_78328_b() - 35, width = fontRenderer.func_78256_a(text), height = fontRenderer.field_78288_b - 1, mouseX, mouseY)) {
                hoveredElementId = "experience_level";
                narrationText = text;
            }
        }
        if (hoveredElementId != null) {
            if (!hoveredElementId.equals(this.currentHoveredElement)) {
                this.currentHoveredElement = hoveredElementId;
                this.hoverStartTime = System.currentTimeMillis();
                this.lastNarratedText = null;
            } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay && this.lastNarratedText == null) {
                AudioPlayer.speakAsync(narrationText);
                this.lastNarratedText = narrationText;
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

