/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class IngameMenuNarrator {
    private final Minecraft mc = Minecraft.func_71410_x();
    private String lastNarratedText = null;
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private GuiScreen lastGui = null;
    int delay = NarratorConfig.ingameMenuNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableIngameMenuListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        GuiScreen currentGui = event.gui;
        if (currentGui != this.lastGui) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.lastNarratedText = null;
            this.lastGui = currentGui;
        }
        if (currentGui instanceof GuiIngameMenu) {
            int titleY;
            int mouseX = Mouse.getX() * currentGui.field_146294_l / this.mc.field_71443_c;
            int mouseY = currentGui.field_146295_m - Mouse.getY() * currentGui.field_146295_m / this.mc.field_71440_d - 1;
            String narrationText = null;
            String hoveredElement = null;
            String titleText = StatCollector.func_74838_a((String)"menu.game");
            int titleWidth = this.mc.field_71466_p.func_78256_a(titleText);
            int titleX = currentGui.field_146294_l / 2 - titleWidth / 2 - 1;
            if (this.isMouseOver(titleX, titleY = 39, titleWidth, this.mc.field_71466_p.field_78288_b, mouseX, mouseY)) {
                narrationText = titleText;
                hoveredElement = "ingameMenuTitle";
            }
            if (hoveredElement != null) {
                if (this.currentHoveredElement != hoveredElement) {
                    this.currentHoveredElement = hoveredElement;
                    this.hoverStartTime = System.currentTimeMillis();
                    this.lastNarratedText = null;
                } else if (System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                    if (narrationText != null && !narrationText.equals(this.lastNarratedText)) {
                        AudioPlayer.speakAsync(narrationText);
                        this.lastNarratedText = narrationText;
                    }
                    this.hoverStartTime = -1L;
                }
            } else {
                this.currentHoveredElement = null;
                this.hoverStartTime = -1L;
                this.lastNarratedText = null;
            }
        }
    }

    private boolean isMouseOver(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }
}

