/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.client.GuiIngameModOptions;
import cpw.mods.fml.client.GuiModOptionList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Mouse;

public class IngameModListNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.ingameModListNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableIngameModListListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiIngameModOptions)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = Mouse.getX() * event.gui.field_146294_l / Minecraft.func_71410_x().field_71443_c;
        int mouseY = event.gui.field_146295_m - Mouse.getY() * event.gui.field_146295_m / Minecraft.func_71410_x().field_71440_d - 1;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty() && Objects.equals(result.narrationKey, this.currentNarrationKey)) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        GuiIngameModOptions gui = (GuiIngameModOptions)event.gui;
        Minecraft mc = Minecraft.func_71410_x();
        try {
            int slotY;
            int titleY;
            String titleText;
            int titleWidth;
            int titleX;
            Field titleField = this.findField(GuiIngameModOptions.class, "title", "title");
            if (titleField != null && this.isMouseOver(mouseX, mouseY, titleX = gui.field_146294_l / 2 - (titleWidth = mc.field_71466_p.func_78256_a(titleText = (String)titleField.get(gui))) / 2 - 1, titleY = 14, titleWidth, mc.field_71466_p.field_78288_b)) {
                return new HoverResult(titleText, titleText, "modOptionsTitle");
            }
            Field optionListField = this.findField(GuiIngameModOptions.class, "optionList", "optionList");
            if (optionListField == null) {
                return null;
            }
            GuiModOptionList optionList = (GuiModOptionList)optionListField.get(gui);
            Field leftField = this.findField(GuiModOptionList.class, "left", "left");
            Field topField = this.findField(GuiModOptionList.class, "top", "top");
            Field bottomField = this.findField(GuiModOptionList.class, "bottom", "bottom");
            Field slotHeightField = this.findField(GuiModOptionList.class, "slotHeight", "slotHeight");
            Field scrollDistanceField = this.findField(GuiModOptionList.class.getSuperclass(), "scrollDistance", "scrollDistance");
            if (leftField == null || topField == null || bottomField == null || slotHeightField == null || scrollDistanceField == null) {
                return null;
            }
            int listLeft = leftField.getInt(optionList);
            int listTop = topField.getInt(optionList);
            int listBottom = bottomField.getInt(optionList);
            int slotHeight = slotHeightField.getInt(optionList);
            float scrollDistance = scrollDistanceField.getFloat(optionList);
            if (mouseX >= listLeft && mouseX <= listLeft + 150 && mouseY >= listTop && mouseY <= listBottom && this.isMouseOver(mouseX, mouseY, listLeft, slotY = listTop - (int)scrollDistance, 150, slotHeight)) {
                String combinedText = "Test 1, TEST 2, DISABLED";
                return new HoverResult(combinedText, combinedText, "mod_options_combined");
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during ingame mod options narration.");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(deobfName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(srgName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

