/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.GuiScreenEvent;

public class InventoryNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private boolean hasNarrated = false;
    int delay = NarratorConfig.inventoryNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableInventoryListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiInventory) && !(event.gui instanceof GuiContainerCreative)) {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.hasNarrated = false;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        Object newHoveredElement = null;
        String narrationText = null;
        if (result != null) {
            newHoveredElement = result.hoveredElement;
            narrationText = result.narrationText;
        }
        if (newHoveredElement != null) {
            if (newHoveredElement != this.currentHoveredElement) {
                this.currentHoveredElement = newHoveredElement;
                this.hoverStartTime = System.currentTimeMillis();
                this.hasNarrated = false;
            }
            if (!this.hasNarrated && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                AudioPlayer.speakAsync(narrationText);
                this.hasNarrated = true;
            }
        } else {
            this.currentHoveredElement = null;
            this.hoverStartTime = -1L;
            this.hasNarrated = false;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            int guiTop;
            Field guiTopField;
            Field guiLeftField;
            GuiContainerCreative gui;
            Collection activeEffectsCollection;
            ArrayList activeEffects;
            if (event.gui instanceof InventoryEffectRenderer && !(activeEffects = new ArrayList(activeEffectsCollection = mc.field_71439_g.func_70651_bq())).isEmpty()) {
                Field guiLeftField2 = this.findField(GuiContainer.class, "guiLeft", "field_147003_i");
                Field guiTopField2 = this.findField(GuiContainer.class, "guiTop", "field_147009_r");
                if (guiLeftField2 != null && guiTopField2 != null) {
                    int guiLeft = guiLeftField2.getInt(event.gui);
                    int guiTop2 = guiTopField2.getInt(event.gui);
                    int x = guiLeft - 124;
                    int width = 119;
                    int height = 32;
                    int k = 33;
                    if (activeEffects.size() > 5) {
                        k = 132 / (activeEffects.size() - 1);
                    }
                    for (int i = activeEffects.size() - 1; i >= 0; --i) {
                        PotionEffect effect = (PotionEffect)activeEffects.get(i);
                        int y = guiTop2 + i * k;
                        if (!this.isMouseOver(mouseX, mouseY, x, y, width, height)) continue;
                        Potion potion = Potion.field_76425_a[effect.func_76456_a()];
                        String narration = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                        int amplifier = effect.func_76458_c();
                        if (amplifier > 0 && amplifier < 10) {
                            narration = narration + " " + I18n.func_135052_a((String)("enchantment.level." + (amplifier + 1)), (Object[])new Object[0]);
                        } else if (amplifier >= 10) {
                            narration = narration + " " + (amplifier + 1);
                        }
                        String formattedTime = this.formatTime(effect.func_76459_b());
                        narration = narration + ", " + formattedTime;
                        return new HoverResult(narration, effect, potion.func_76393_a() + "_" + effect.func_76458_c());
                    }
                }
            }
            if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
                String searchText;
                GuiTextField searchField;
                Field searchFieldField;
                int selectedTabIndex;
                int destroySlotHeight;
                int destroySlotWidth;
                int destroySlotY;
                gui = (GuiContainerCreative)event.gui;
                guiLeftField = this.findField(GuiContainer.class, "guiLeft", "field_147003_i");
                guiTopField = this.findField(GuiContainer.class, "guiTop", "field_147009_r");
                if (guiLeftField == null || guiTopField == null) {
                    return null;
                }
                int guiLeft = guiLeftField.getInt(gui);
                int destroySlotX = guiLeft + 172;
                if (this.isMouseOver(mouseX, mouseY, destroySlotX, destroySlotY = (guiTop = guiTopField.getInt(gui)) + 111, destroySlotWidth = 17, destroySlotHeight = 17)) {
                    String narrationText = I18n.func_135052_a((String)"inventory.binSlot", (Object[])new Object[0]);
                    return new HoverResult(narrationText, "destroy_slot", "destroy_slot");
                }
                Field selectedTabIndexField = this.findField(GuiContainerCreative.class, "selectedTabIndex", "field_147058_w");
                boolean isSearchTabActive = false;
                if (selectedTabIndexField != null && (selectedTabIndex = selectedTabIndexField.getInt(gui)) == CreativeTabs.field_78027_g.func_78021_a()) {
                    isSearchTabActive = true;
                }
                if (isSearchTabActive && (searchFieldField = this.findField(GuiContainerCreative.class, "searchField", "field_147062_A")) != null && (searchField = (GuiTextField)searchFieldField.get(gui)) != null && !(searchText = searchField.func_146179_b()).trim().isEmpty() && this.isMouseOver(mouseX, mouseY, searchField.field_146209_f - 1, searchField.field_146210_g - 1, searchField.field_146218_h - 2, searchField.field_146219_i)) {
                    return new HoverResult(searchText, "creative_search", "creative_search");
                }
            } else {
                int craftingLabelHeight;
                String craftingLabelText;
                int craftingLabelWidth;
                int craftingLabelY;
                gui = (GuiInventory)event.gui;
                guiLeftField = this.findField(GuiContainer.class, "guiLeft", "field_147003_i");
                guiTopField = this.findField(GuiContainer.class, "guiTop", "field_147009_r");
                if (guiLeftField == null || guiTopField == null) {
                    return null;
                }
                int guiLeft = guiLeftField.getInt(gui);
                int craftingLabelX = guiLeft + 85;
                if (this.isMouseOver(mouseX, mouseY, craftingLabelX, craftingLabelY = (guiTop = guiTopField.getInt(gui)) + 14, craftingLabelWidth = mc.field_71466_p.func_78256_a(craftingLabelText = I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0])), craftingLabelHeight = mc.field_71466_p.field_78288_b)) {
                    return new HoverResult(craftingLabelText, "crafting", "crafting");
                }
            }
        }
        catch (Exception e) {
            NarratorConfig.logError("[Narrator] An error occurred during inventory narration.");
            e.printStackTrace();
        }
        return null;
    }

    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }

    private boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    private Field findField(Class<?> clazz, String deobfName, String srgName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(deobfName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException f) {
                try {
                    Field f2 = c.getDeclaredField(srgName);
                    f2.setAccessible(true);
                    return f2;
                }
                catch (NoSuchFieldException ex) {
                    continue;
                }
            }
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

