/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

@SideOnly(value=Side.CLIENT)
public class ItemNarrator {
    private long hoverStartTime = -1L;
    private ItemStack hoveredStack = null;
    private ItemStack lastNarratedStack = null;
    int delay = NarratorConfig.itemNarratorHoverDelay;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        block21: {
            if (!NarratorConfig.enableItemListener || !KeybindHandler.isNarratorEnabled()) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.func_71410_x();
                GuiScreen currentScreen = mc.field_71462_r;
                if (currentScreen instanceof GuiContainer) {
                    try {
                        GuiContainer containerScreen = (GuiContainer)currentScreen;
                        Field slotField = this.findField(GuiContainer.class, "field_147006_u", "theSlot");
                        if (slotField == null) break block21;
                        Slot currentSlot = (Slot)slotField.get(containerScreen);
                        ItemStack stackInSlot = null;
                        if (currentSlot != null && currentSlot.func_75216_d()) {
                            stackInSlot = currentSlot.func_75211_c();
                        }
                        if (!ItemStack.func_77989_b(stackInSlot, (ItemStack)this.hoveredStack)) {
                            this.hoveredStack = stackInSlot;
                            this.hoverStartTime = System.currentTimeMillis();
                            this.lastNarratedStack = null;
                        }
                        if (stackInSlot != null && !ItemStack.func_77989_b((ItemStack)stackInSlot, (ItemStack)this.lastNarratedStack) && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                            List tooltip = stackInSlot.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
                            StringBuilder fullTooltipText = new StringBuilder();
                            String lastCleanLine = "";
                            for (String line : tooltip) {
                                String cleanLine = EnumChatFormatting.func_110646_a((String)line).trim();
                                if (cleanLine.isEmpty()) continue;
                                if (fullTooltipText.length() > 0) {
                                    if (lastCleanLine.endsWith(":")) {
                                        fullTooltipText.append(" ");
                                    } else {
                                        fullTooltipText.append(", ");
                                    }
                                }
                                fullTooltipText.append(cleanLine);
                                lastCleanLine = cleanLine;
                            }
                            if (currentScreen instanceof GuiContainerCreative) {
                                int selectedTabIndex;
                                GuiContainerCreative creativeScreen = (GuiContainerCreative)currentScreen;
                                Field selectedTabIndexField = this.findField(GuiContainerCreative.class, "field_147058_w", "selectedTabIndex");
                                if (selectedTabIndexField != null && (selectedTabIndex = selectedTabIndexField.getInt(creativeScreen)) == CreativeTabs.field_78027_g.func_78021_a()) {
                                    Map enchantments;
                                    CreativeTabs itemTab = stackInSlot.func_77973_b().func_77640_w();
                                    if (stackInSlot.func_77973_b() == Items.field_151134_bR && !(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stackInSlot)).isEmpty()) {
                                        for (Object enchantmentIdObj : enchantments.keySet()) {
                                            int enchantmentId;
                                            Enchantment enchantment;
                                            if (!(enchantmentIdObj instanceof Integer) || (enchantment = Enchantment.field_77331_b[enchantmentId = ((Integer)enchantmentIdObj).intValue()]) == null) continue;
                                            if (enchantment.field_77351_y == EnumEnchantmentType.digger || enchantment.field_77351_y == EnumEnchantmentType.fishing_rod || enchantment.field_77351_y == EnumEnchantmentType.breakable) {
                                                itemTab = CreativeTabs.field_78040_i;
                                                break;
                                            }
                                            if (enchantment.field_77351_y != EnumEnchantmentType.weapon && enchantment.field_77351_y != EnumEnchantmentType.armor && enchantment.field_77351_y != EnumEnchantmentType.bow && enchantment.field_77351_y != EnumEnchantmentType.armor_head && enchantment.field_77351_y != EnumEnchantmentType.armor_torso && enchantment.field_77351_y != EnumEnchantmentType.armor_legs && enchantment.field_77351_y != EnumEnchantmentType.armor_feet) continue;
                                            itemTab = CreativeTabs.field_78037_j;
                                            break;
                                        }
                                    }
                                    if (itemTab != null && itemTab.func_78024_c() != null) {
                                        String tabName = I18n.func_135052_a((String)itemTab.func_78024_c(), (Object[])new Object[0]);
                                        if (fullTooltipText.length() > 0) {
                                            fullTooltipText.append(", ");
                                        }
                                        fullTooltipText.append(tabName);
                                    }
                                }
                            }
                            if (!fullTooltipText.toString().trim().isEmpty()) {
                                AudioPlayer.speakAsync(fullTooltipText.toString().trim());
                                this.lastNarratedStack = stackInSlot;
                            }
                        }
                    }
                    catch (Exception e) {
                        NarratorConfig.logError("[Narrator] Failed to get item tooltip: " + e.getMessage());
                    }
                } else {
                    this.hoveredStack = null;
                    this.lastNarratedStack = null;
                    this.hoverStartTime = -1L;
                }
            }
        }
    }

    private Field findField(Class<?> clazz, String srgName, String obfName) {
        try {
            Field field = clazz.getDeclaredField(srgName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = clazz.getDeclaredField(obfName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
        }
    }
}

