/*
 * Decompiled with CFR 0.152.
 */
package com.gedeongrays.narrator.listener;

import com.gedeongrays.narrator.audio.AudioPlayer;
import com.gedeongrays.narrator.config.NarratorConfig;
import com.gedeongrays.narrator.keybind.KeybindHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiShareToLan;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;

public class LanNarrator {
    private long hoverStartTime = -1L;
    private Object currentHoveredElement = null;
    private String currentNarrationKey = null;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    int delay = NarratorConfig.lanNarratorHoverDelay;

    @SubscribeEvent
    public void onPostDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!NarratorConfig.enableLanListener || !KeybindHandler.isNarratorEnabled()) {
            return;
        }
        if (!(event.gui instanceof GuiShareToLan)) {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
            return;
        }
        int mouseX = event.mouseX;
        int mouseY = event.mouseY;
        if (mouseX == this.lastMouseX && mouseY == this.lastMouseY) {
            if (this.currentHoveredElement != null && this.hoverStartTime != -1L && System.currentTimeMillis() - this.hoverStartTime >= (long)this.delay) {
                HoverResult result = this.getHoverResult(event, mouseX, mouseY);
                if (result != null && result.narrationText != null && !result.narrationText.isEmpty()) {
                    AudioPlayer.speakAsync(result.narrationText);
                }
                this.hoverStartTime = -1L;
            }
            return;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        HoverResult result = this.getHoverResult(event, mouseX, mouseY);
        if (result != null) {
            if (!Objects.equals(this.currentNarrationKey, result.narrationKey)) {
                this.currentHoveredElement = result.hoveredElement;
                this.currentNarrationKey = result.narrationKey;
                this.hoverStartTime = System.currentTimeMillis();
            }
        } else {
            this.currentHoveredElement = null;
            this.currentNarrationKey = null;
            this.hoverStartTime = -1L;
        }
    }

    private HoverResult getHoverResult(GuiScreenEvent.DrawScreenEvent.Post event, int mouseX, int mouseY) {
        GuiShareToLan gui = (GuiShareToLan)event.gui;
        Minecraft mc = Minecraft.func_71410_x();
        String titleText = I18n.func_135052_a((String)"lanServer.title", (Object[])new Object[0]);
        int titleWidth = mc.field_71466_p.func_78256_a(titleText);
        int titleX = gui.field_146294_l / 2 - titleWidth / 2 - 1;
        int titleY = 49;
        int titleHeight = mc.field_71466_p.field_78288_b;
        if (mouseX >= titleX && mouseX <= titleX + titleWidth && mouseY >= titleY && mouseY <= titleY + titleHeight) {
            return new HoverResult(titleText, "lan_title", "lan_title");
        }
        String subtitleText = I18n.func_135052_a((String)"lanServer.otherPlayers", (Object[])new Object[0]);
        int subtitleWidth = mc.field_71466_p.func_78256_a(subtitleText);
        int subtitleX = gui.field_146294_l / 2 - subtitleWidth / 2 - 1;
        int subtitleY = 81;
        int subtitleHeight = mc.field_71466_p.field_78288_b;
        if (mouseX >= subtitleX && mouseX <= subtitleX + subtitleWidth && mouseY >= subtitleY && mouseY <= subtitleY + subtitleHeight) {
            return new HoverResult(subtitleText, "lan_subtitle", "lan_subtitle");
        }
        return null;
    }

    private static class HoverResult {
        public final String narrationText;
        public final Object hoveredElement;
        public final String narrationKey;

        public HoverResult(String text, Object element, String key) {
            this.narrationText = text;
            this.hoveredElement = element;
            this.narrationKey = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HoverResult that = (HoverResult)o;
            return Objects.equals(this.narrationKey, that.narrationKey);
        }

        public int hashCode() {
            return Objects.hash(this.narrationKey);
        }
    }
}

